/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.EventFilter;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.WebsocketRecipients;
import de.virtimo.bpc.api.apikey.APIKeyException;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CatchAllBpcEventsHandler;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.apikey.APIKey;
import de.virtimo.bpc.core.apikey.APIKeySession;
import de.virtimo.bpc.core.apikey.APIKeys;
import de.virtimo.bpc.core.auth.ClientSessionImpl;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.core.utils.EventUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class ClientSessionManagerImpl
implements ClientSessionManager,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(ClientSessionManagerImpl.class);
    private static final Object SESSIONS_LOCK = new Object();
    private final BundleContext bundleContext;
    private final ModuleManager moduleManager;
    private final CoreBundleConfiguration coreBundleConfiguration;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final Map<String, ClientSession> sessionMap;
    private ExecutorService executorService;
    private final CatchAllBpcEventsHandler catchAllBpcEventsHandler;
    private final EventRegistration eventRegistration;

    public ClientSessionManagerImpl(BundleContext bundleContext, ModuleManager moduleManager, CoreBundleConfiguration coreBundleConfiguration) {
        LOGGER.info("ClientSessionManagerImpl");
        this.bundleContext = bundleContext;
        this.moduleManager = moduleManager;
        this.coreBundleConfiguration = coreBundleConfiguration;
        this.sessionMap = new ConcurrentHashMap<String, ClientSession>();
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.executorService = Executors.newFixedThreadPool(3, new ThreadFactoryWithNamePrefix("bpc-core-websocket-notifications"));
        this.catchAllBpcEventsHandler = new CatchAllBpcEventsHandler(this, moduleManager);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forAllBpcEvents(this.catchAllBpcEventsHandler);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            this.removeAllSessions(true, identityProvider);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to remove all user sessions", (Throwable)ex);
        }
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManager.getModuleById("_core");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsSession(String sessionId) {
        LOGGER.debug("existsSession sessionId=...");
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            return sessionId != null && this.sessionMap.containsKey(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(String sessionId, Session websocketSession) {
        LOGGER.info("addSession sessionId=..., websocketSession=...");
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            if (this.sessionMap.containsKey(sessionId)) {
                this.sessionMap.get(sessionId).addWebsocketSession(websocketSession);
            } else {
                LOGGER.warn("There is something wrong, a websocket session cannot be added for an not existing client session: " + sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(String sessionId, UserSession userSession) {
        LOGGER.info("addSession sessionId=..., userSession=...");
        try {
            boolean sessionAdded = false;
            Object object = SESSIONS_LOCK;
            synchronized (object) {
                if (this.sessionMap.containsKey(sessionId)) {
                    this.sessionMap.get(sessionId).setUserSession(userSession);
                } else {
                    ClientSessionImpl cs = new ClientSessionImpl(sessionId, userSession);
                    this.sessionMap.put(sessionId, cs);
                    sessionAdded = true;
                }
            }
            if (sessionAdded) {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/auth/sessionAdded", "SessionId", sessionId);
            }
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Failed to fire add session event", (Throwable)ex);
        }
    }

    @Override
    public void removeAllSessions(boolean alsoInformIdentityProvider) throws ModuleNotFoundException, ServiceNotFoundException {
        LOGGER.info("removeAllSessions alsoInformIdentityProvider={}", (Object)alsoInformIdentityProvider);
        IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
        this.removeAllSessions(alsoInformIdentityProvider, identityProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllSessions(boolean alsoInformIdentityProvider, IdentityProvider identityProvider) {
        LOGGER.info("removeAllSessions alsoInformIdentityProvider={}, identityProvider=...", (Object)alsoInformIdentityProvider);
        HashSet<ClientSession> removedClientSessions = new HashSet<ClientSession>();
        Iterator iterator = SESSIONS_LOCK;
        synchronized (iterator) {
            HashSet<String> clientSessionIDs = new HashSet<String>(this.sessionMap.keySet());
            for (String clientSessionID : clientSessionIDs) {
                ClientSession removedClientSession = this.sessionMap.remove(clientSessionID);
                if (removedClientSession == null) continue;
                removedClientSessions.add(removedClientSession);
            }
        }
        for (ClientSession removedClientSession : removedClientSessions) {
            try {
                this.cleanupRemovedSession(removedClientSession, alsoInformIdentityProvider, identityProvider);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to remove session.", (Throwable)ex);
            }
        }
    }

    @Override
    public void removeSession(String sessionId, boolean alsoInformIdentityProvider) throws ModuleNotFoundException, ServiceNotFoundException {
        LOGGER.info("removeSession sessionId=..., alsoInformIdentityProvider={}", (Object)alsoInformIdentityProvider);
        IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
        this.removeSession(sessionId, alsoInformIdentityProvider, identityProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(String sessionId, boolean alsoInformIdentityProvider, IdentityProvider identityProvider) {
        ClientSession removedClientSession;
        LOGGER.info("removeSession sessionId=..., alsoInformIdentityProvider={}, identityProvider=...", (Object)alsoInformIdentityProvider);
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            removedClientSession = this.sessionMap.remove(sessionId);
        }
        if (removedClientSession != null) {
            try {
                this.cleanupRemovedSession(removedClientSession, alsoInformIdentityProvider, identityProvider);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to remove session.", (Throwable)ex);
            }
        }
    }

    private void cleanupRemovedSession(ClientSession clientSession, boolean alsoInformIdentityProvider, IdentityProvider identityProvider) throws ServiceNotFoundException {
        LOGGER.info("cleanupRemovedSession clientSession={}, alsoInformIdentityProvider={}, identityProvider=...", (Object)clientSession, (Object)alsoInformIdentityProvider);
        String clientSessionId = clientSession.getSessionId();
        if (alsoInformIdentityProvider && identityProvider != null) {
            try {
                identityProvider.logout(clientSessionId);
            }
            catch (Throwable ex) {
                LOGGER.warn("Failed to logout from identity provider: " + ex.getMessage());
            }
        }
        if (clientSession.getUserSession() != null) {
            UserAuditLog.debug(clientSession.getUserSession(), "UserLogout", "Logout");
        }
        this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/auth/sessionRemoved", "SessionId", clientSessionId);
        clientSession.closeAndRemoveAllWebsocketSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(String sessionId, Session websocketSession) {
        LOGGER.info("removeSession sessionId=..., websocketSession=...");
        if (websocketSession != null) {
            Object object = SESSIONS_LOCK;
            synchronized (object) {
                ClientSession clientSession = this.sessionMap.get(sessionId);
                if (clientSession != null) {
                    if (websocketSession.isOpen()) {
                        websocketSession.close();
                    }
                    clientSession.removeWebsocketSession(websocketSession);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionCount() {
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            return this.sessionMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClientSession> getAllSessions() {
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            return new ArrayList<ClientSession>(this.sessionMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferWebsocketConnections(UserSession fromUserSession, UserSession toUserSession) {
        LOGGER.info("transferWebsocketConnections fromUserSession=..., toUserSession=...");
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            ClientSession fromClientSession = this.sessionMap.get(fromUserSession.getSessionId());
            ClientSession toClientSession = this.sessionMap.get(toUserSession.getSessionId());
            if (fromClientSession != null && toClientSession != null) {
                ArrayList<Session> websocketSessions = fromClientSession.getWebsocketSessions();
                for (Session websocketSession : websocketSessions) {
                    toClientSession.addWebsocketSession(websocketSession);
                    fromClientSession.removeWebsocketSession(websocketSession);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOpenWebsocketConnectionsCount() {
        LOGGER.info("getOpenWebsocketConnectionsCount");
        int cnt = 0;
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            for (ClientSession clientSession : this.sessionMap.values()) {
                for (Session websocketSession : clientSession.getWebsocketSessions()) {
                    if (websocketSession == null || !websocketSession.isOpen()) continue;
                    ++cnt;
                }
            }
        }
        return cnt;
    }

    private void sendWebsocketMessage(Session websocketSession, String message) {
        block3: {
            LOGGER.info("sendWebsocketMessage websocketSession={}, message=...", (Object)websocketSession);
            RemoteEndpoint remote = websocketSession.getRemote();
            Future future = null;
            try {
                future = remote.sendStringByFuture(message);
                future.get(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.error("Websocket send failed.", (Throwable)ex);
            }
            catch (TimeoutException ex) {
                LOGGER.error("Websocket send timed out.", (Throwable)ex);
                if (future == null) break block3;
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendByWebsocket(String sessionId, String message) {
        LOGGER.info("sendByWebsocket sessionId=..., message=...");
        HashSet<ClientSession> relatedClientSessions = new HashSet<ClientSession>();
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            ClientSession clientSession = this.sessionMap.get(sessionId);
            if (clientSession != null) {
                relatedClientSessions.add(clientSession);
            } else {
                LOGGER.warn("sendByWebsocket: Session " + sessionId + " not found?");
            }
        }
        this.sendByWebsocket(relatedClientSessions, message);
    }

    private void sendByWebsocket(Set<ClientSession> clientSessions, String message) {
        LOGGER.info("sendByWebsocket clientSessions={}, message=...", clientSessions);
        if (clientSessions != null) {
            for (ClientSession clientSession : clientSessions) {
                this.sendByWebsocket(clientSession, message);
            }
        }
    }

    @Override
    public void sendByWebsocket(ClientSession clientSession, String message) {
        LOGGER.info("sendByWebsocket clientSession={}, message=...", (Object)clientSession);
        if (clientSession != null) {
            String sessionId = clientSession.getSessionId();
            for (Session websocketSession : clientSession.getWebsocketSessions()) {
                if (websocketSession != null && websocketSession.isOpen()) {
                    LOGGER.info("sendByWebsocket: Message to sessionId=... is on the way: " + message);
                    this.sendWebsocketMessage(websocketSession, message);
                    continue;
                }
                LOGGER.info("sendByWebsocket: Websocket session of user session=... is closed, removing it.");
                clientSession.removeWebsocketSession(websocketSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToUserRolesByWebsocket(Set<String> userRoles, String message) {
        LOGGER.info("sendToUserRolesByWebsocket userRoles={}, message=...", userRoles);
        HashSet<ClientSession> relatedClientSessions = new HashSet<ClientSession>();
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            for (ClientSession clientSession : this.sessionMap.values()) {
                UserSession userSession = clientSession.getUserSession();
                if (userSession == null || userRoles == null || !userSession.hasAnyRole(userRoles)) continue;
                relatedClientSessions.add(clientSession);
            }
        }
        this.sendByWebsocket(relatedClientSessions, message);
    }

    @Override
    public void sendToUserRolesByWebsocketAsync(Set<String> userRoles, String eventTopic, Map<String, Object> info) {
        LOGGER.info("sendToUserRolesByWebsocketAsync userRoles={}, eventTopic={}, info={}", userRoles, (Object)eventTopic, info);
        this.sendToUserRolesByWebsocketAsync(userRoles, eventTopic, Collections.singletonList(info));
    }

    @Override
    public void sendToUserRolesByWebsocketAsync(final Set<String> userRoles, final String eventTopic, final List<Map<String, Object>> infos) {
        LOGGER.info("sendToUserRolesByWebsocketAsync userRoles={}, eventTopic={}, infos={}", userRoles, (Object)eventTopic, infos);
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String message = EventUtil.eventAsJsonString(new Event(eventTopic, MapUtil.mapOf("data", infos)));
                    ClientSessionManagerImpl.this.sendToUserRolesByWebsocket(userRoles, message);
                }
                catch (JsonProcessingException ex) {
                    LOGGER.error("Sending message by Websocket failed. Could not convert the given infos object to JSON.", (Throwable)ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcastMessage(String message) {
        LOGGER.info("broadcastMessage message=...");
        HashSet<ClientSession> relatedClientSessions = new HashSet<ClientSession>();
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            for (ClientSession clientSession : this.sessionMap.values()) {
                relatedClientSessions.add(clientSession);
            }
        }
        this.sendByWebsocket(relatedClientSessions, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcastMessage(String message, WebsocketRecipients websocketRecipients) {
        LOGGER.info("broadcastMessage message=..., websocketRecipients={}", (Object)websocketRecipients);
        HashSet<ClientSession> relatedClientSessions = new HashSet<ClientSession>();
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            for (ClientSession clientSession : this.sessionMap.values()) {
                UserSession userSession = clientSession.getUserSession();
                if (userSession == null) continue;
                boolean mustSend = false;
                if (!mustSend) {
                    for (String user : websocketRecipients.getUsers()) {
                        if (!user.equalsIgnoreCase(userSession.getLoginName())) continue;
                        mustSend = true;
                        break;
                    }
                }
                if (!mustSend && userSession.hasAnyRole(websocketRecipients.getRoles())) {
                    mustSend = true;
                }
                if (!mustSend && userSession.hasAnyOrganisation(websocketRecipients.getOrganizations())) {
                    mustSend = true;
                }
                if (!mustSend) continue;
                relatedClientSessions.add(clientSession);
            }
        }
        this.sendByWebsocket(relatedClientSessions, message);
    }

    @Override
    public void addBlacklistEventFilter(EventFilter eventFilter) {
        this.catchAllBpcEventsHandler.addBlacklistFilter(eventFilter);
    }

    @Override
    public String getSessionId(HttpHeaders httpHeaders) {
        String bpcCookieName;
        Cookie cookie;
        Map cookies;
        LOGGER.info("getSessionId httpHeaders=...");
        if (httpHeaders != null && (cookies = httpHeaders.getCookies()) != null && (cookie = (Cookie)cookies.get(bpcCookieName = this.coreBundleConfiguration.getCookieName())) != null) {
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public String getSessionId(HttpServletRequest httpServletRequest) {
        javax.servlet.http.Cookie[] cookies;
        LOGGER.info("getSessionId httpServletRequest=...");
        String sessionId = null;
        if (httpServletRequest != null && (cookies = httpServletRequest.getCookies()) != null) {
            String bpcCookieName = this.coreBundleConfiguration.getCookieName();
            for (javax.servlet.http.Cookie cookie : cookies) {
                if (cookie == null || !cookie.getName().equals(bpcCookieName) || !this.existsSession(sessionId = cookie.getValue())) continue;
                return sessionId;
            }
        }
        return sessionId;
    }

    @Override
    public String getSessionId(List<HttpCookie> httpCookies) {
        LOGGER.info("getSessionId httpCookies=...");
        String sessionId = null;
        if (httpCookies != null) {
            String bpcCookieName = this.coreBundleConfiguration.getCookieName();
            for (HttpCookie cookie : httpCookies) {
                if (cookie == null || !cookie.getName().equals(bpcCookieName) || !this.existsSession(sessionId = cookie.getValue())) continue;
                return sessionId;
            }
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionIdFromNonHijackableSessionId(String nonHijackableSessionId) {
        if (!StringUtil.isNullOrEmpty(nonHijackableSessionId)) {
            Object object = SESSIONS_LOCK;
            synchronized (object) {
                for (ClientSession clientSession : this.sessionMap.values()) {
                    if (!nonHijackableSessionId.equals(clientSession.getNonHijackableSessionId())) continue;
                    return clientSession.getSessionId();
                }
            }
        }
        return null;
    }

    private String getAPIKey(HttpHeaders httpHeaders) {
        List apiKeyHeader;
        LOGGER.info("getAPIKey httpHeaders=...");
        if (httpHeaders != null && (apiKeyHeader = httpHeaders.getRequestHeader("X-APIKey")) != null && apiKeyHeader.size() > 0) {
            return (String)apiKeyHeader.get(0);
        }
        return null;
    }

    private String getAPIKey(HttpServletRequest httpServletRequest) {
        LOGGER.info("getAPIKey httpServletRequest=...");
        if (httpServletRequest != null) {
            return httpServletRequest.getHeader("X-APIKey");
        }
        return null;
    }

    private APIKeySession createAPIKeySession(String apikey) throws APIKeyException {
        LOGGER.info("createAPIKeySession apikey=...");
        try {
            APIKeys apiKeys = APIKeys.of(this.getCoreModule().getConfiguration().getSetting("apiKeys"));
            APIKey apiKey = apiKeys.getAPIKey(apikey);
            if (apiKey == null) {
                throw new APIKeyException(apikey, "CORE_ERROR_APIKEY_NOT_FOUND");
            }
            if (!apiKey.isValid()) {
                throw new APIKeyException(apikey, "CORE_ERROR_APIKEY_WRONG_CONFIGURATION");
            }
            if (apiKey.isNotActive()) {
                throw new APIKeyException(apikey, "CORE_ERROR_APIKEY_NOT_ACTIVE");
            }
            if (apiKey.isExpired()) {
                throw new APIKeyException(apikey, "CORE_ERROR_APIKEY_IS_EXPIRED");
            }
            return new APIKeySession(apiKey);
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            throw new APIKeyException(apikey, "CORE_ERROR_APIKEY_UNEXPECTED_EXCEPTION", (Throwable)ex);
        }
    }

    @Override
    public UserSession getUserSession(HttpHeaders httpHeaders) throws APIKeyException {
        LOGGER.info("getUserSession httpHeaders=...");
        return this.getUserSession(this.getAPIKey(httpHeaders), this.getSessionId(httpHeaders));
    }

    @Override
    public UserSession getUserSession(HttpServletRequest httpServletRequest) throws APIKeyException {
        LOGGER.info("getUserSession httpServletRequest=...");
        return this.getUserSession(this.getAPIKey(httpServletRequest), this.getSessionId(httpServletRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserSession> findUserSessionByCustomData(String key, Object value) {
        ArrayList<UserSession> resultList = new ArrayList<UserSession>();
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            for (ClientSession clientSession : this.sessionMap.values()) {
                Map<String, Object> customData = clientSession.getUserSession().getCustomData();
                if (!customData.containsKey(key) || !customData.get(key).equals(value)) continue;
                resultList.add(clientSession.getUserSession());
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserSession> findUserSessionBySensitiveCustomData(String key, Object value) {
        ArrayList<UserSession> resultList = new ArrayList<UserSession>();
        Object object = SESSIONS_LOCK;
        synchronized (object) {
            for (ClientSession clientSession : this.sessionMap.values()) {
                Map<String, Object> sensitiveCustomData = clientSession.getUserSession().getSensitiveCustomData();
                if (!sensitiveCustomData.containsKey(key) || !sensitiveCustomData.get(key).equals(value)) continue;
                resultList.add(clientSession.getUserSession());
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserSession getUserSession(String apiKey, String sessionId) throws APIKeyException {
        Object object;
        LOGGER.info("getUserSession apiKey=..., sessionId=...");
        UserSession userSession = null;
        if (userSession == null && apiKey != null) {
            object = SESSIONS_LOCK;
            synchronized (object) {
                if (this.sessionMap.containsKey(apiKey)) {
                    userSession = this.sessionMap.get(apiKey).getUserSession();
                    LOGGER.info("Found a user session with this key");
                }
            }
            if (userSession == null) {
                userSession = this.createAPIKeySession(apiKey);
            }
            LOGGER.info("session found with API key=...");
        }
        if (userSession == null && sessionId != null) {
            object = SESSIONS_LOCK;
            synchronized (object) {
                if (this.sessionMap.containsKey(sessionId)) {
                    userSession = this.sessionMap.get(sessionId).getUserSession();
                }
            }
            if (userSession == null) {
                LOGGER.warn("No session found for id '...'.");
            } else {
                LOGGER.info("User session found ...");
                this.refreshTokensWhenPossibleAndNecessary(userSession);
            }
        }
        return userSession;
    }

    private void refreshTokensWhenPossibleAndNecessary(UserSession userSession) {
        LOGGER.info("refreshTokensWhenPossibleAndNecessary userSession=...");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider instanceof OidcIdentityProvider) {
                OidcIdentityProvider oidcIdentityProvider = (OidcIdentityProvider)identityProvider;
                oidcIdentityProvider.refreshTokensWithFocusOnExpiredAccessToken(userSession);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to refresh the OIDC tokens of the user session.", (Throwable)ex);
        }
    }
}

