/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.inubit;

import de.virtimo.bpc.core.auth.AbstractUserSession;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.jaas.inubit.response.LoginResponse;
import java.util.Date;

public class InubitUserSession
extends AbstractUserSession {
    private final LoginResponse loginResponse;

    public InubitUserSession(LoginResponse loginResponse) {
        this.loginResponse = loginResponse;
        this.organisations.addAll(OrganisationFactory.getOrganisations(loginResponse.getData().getOrganisations()));
        this.roles.addAll(RolesFactory.getRoles(loginResponse.getData().getRoles()));
        this.rights.addAll(RightFactory.getRights(loginResponse.getData().getRights()));
    }

    @Override
    public String getSessionId() {
        return this.loginResponse.getSessionId();
    }

    @Override
    public String getFirstName() {
        return this.loginResponse.getData().getFirstName();
    }

    @Override
    public String getLastName() {
        return this.loginResponse.getData().getLastName();
    }

    @Override
    public String getLoginName() {
        return this.loginResponse.getUserName();
    }

    @Override
    public String getEmail() {
        return this.loginResponse.getData().getEmail();
    }

    @Override
    public Date getExpirationDate() {
        return this.loginResponse.getExpirationDate();
    }
}

