/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.keycloak;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerUnsupportedOperationException;
import de.virtimo.bpc.core.apikey.APIKeySession;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.UserFactory;
import de.virtimo.bpc.core.auth.UserNotFoundException;
import de.virtimo.bpc.core.auth.keycloak.KeycloakAccountApi;
import de.virtimo.bpc.core.auth.keycloak.KeycloakAdminApi;
import de.virtimo.bpc.core.auth.keycloak.KeycloakException;
import de.virtimo.bpc.core.auth.keycloak.dtos.KeycloakGroupDto;
import de.virtimo.bpc.core.auth.keycloak.dtos.KeycloakRoleDto;
import de.virtimo.bpc.core.auth.keycloak.dtos.KeycloakUserDto;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.core.utils.RestWebServiceClientInitException;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.ListUtil;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class KeycloakIdentityProvider
extends OidcIdentityProvider
implements IdentityManager {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakIdentityProvider.class);
    public static final String CONFIG_KEY = "keycloak";
    private final String clientId;
    private final String clientSecret;
    private AccessToken clientAccessToken;
    private String oidcDiscoveryUrlForClientAccessToken;
    private ScheduledExecutorService scheduler;

    public KeycloakIdentityProvider(BundleContext bundleContext, IdentityProviderConfiguration configuration, int sessionExpirationMinutes) throws URISyntaxException, IdentityProviderException, IllegalArgumentException {
        super(bundleContext, configuration, sessionExpirationMinutes);
        this.clientId = configuration.getOidcClientId();
        this.clientSecret = configuration.getOidcClientSecret();
        this.initClientAccessToken();
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
        super.destroy();
    }

    @Override
    public User getUser(String userId) throws IdentityManagerException {
        LOGGER.warn("getUser deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public User getUser(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.warn("getUser deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public User getUser(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            KeycloakUserDto user = KeycloakAdminApi.getUserByUserName(discoveryUrl, requestingUserSession, userId);
            if (user != null) {
                return this.getUser(user);
            }
            throw new UserNotFoundException(userId);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to get the user '" + userId + "'.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the user '" + userId + "'.", (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER", MapUtil.mapOf("user", userId), (Throwable)ex);
        }
    }

    @Override
    public List<User> getUsers() throws IdentityManagerException {
        LOGGER.warn("getUsers deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public List<User> getUsers(UserSession requestingUserSession) throws IdentityManagerException {
        LOGGER.warn("getUsers deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public List<User> getUsers(UserSession requestingUserSession, HttpServletRequest request) throws IdentityManagerException {
        LOGGER.info("getUsers requestingUserSession={}, request={}", (Object)requestingUserSession, (Object)request);
        try {
            boolean fetchAllKeycloakUsersWithOneCall = Boolean.parseBoolean(System.getProperty("bpc.fetch.all.keycloak.users.with.one.call", "false"));
            if (fetchAllKeycloakUsersWithOneCall) {
                return this.getAllUsersWithOneCall(requestingUserSession, request);
            }
            return this.getAllUsersByUsingPagination(requestingUserSession, request);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to get the users.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the users.", (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USERS", ex);
        }
    }

    private List<User> getAllUsersWithOneCall(UserSession requestingUserSession, HttpServletRequest request) throws KeycloakException, IOException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException, IdentityProviderException {
        LOGGER.debug("getAllUsersWithOneCall requestingUserSession={}, request={}", (Object)requestingUserSession, (Object)request);
        String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
        ArrayList<User> result = new ArrayList<User>();
        List<KeycloakUserDto> users = KeycloakAdminApi.getUsers(discoveryUrl, requestingUserSession);
        if (users != null) {
            for (KeycloakUserDto user : users) {
                result.add(this.getUser(user));
            }
        }
        return result;
    }

    private List<User> getAllUsersByUsingPagination(UserSession requestingUserSession, HttpServletRequest request) throws KeycloakException, IOException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException, IdentityProviderException {
        LOGGER.debug("getAllUsersByUsingPagination requestingUserSession={}, request={}", (Object)requestingUserSession, (Object)request);
        String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
        ArrayList<User> result = new ArrayList<User>();
        boolean receivedAllUsers = false;
        int offset = 0;
        int limit = Integer.parseInt(System.getProperty("bpc.fetch.all.keycloak.users.limit", "250"));
        do {
            List<KeycloakUserDto> users;
            if ((users = KeycloakAdminApi.getUsers(discoveryUrl, requestingUserSession, offset, limit)) != null && !users.isEmpty()) {
                for (KeycloakUserDto user : users) {
                    result.add(this.getUser(user));
                }
                offset += limit;
            }
            if (users != null && !users.isEmpty() && users.size() >= limit) continue;
            receivedAllUsers = true;
        } while (!receivedAllUsers);
        return result;
    }

    private void addKeycloakGroupsAsOrganisations(Set<Organisation> result, List<KeycloakGroupDto> groups, KeycloakGroupDto parentGroup) {
        if (groups != null) {
            for (KeycloakGroupDto group : groups) {
                result.add(this.getOrganisation(group, parentGroup));
                if (group.getSubGroups() == null) continue;
                this.addKeycloakGroupsAsOrganisations(result, group.getSubGroups(), group);
            }
        }
    }

    @Override
    public Set<Organisation> getOrganisations() throws IdentityManagerException {
        LOGGER.warn("getOrganisations deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Organisation> getOrganisations(UserSession requestingUserSession) throws IdentityManagerException {
        LOGGER.warn("getOrganisations deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Organisation> getOrganisations(UserSession requestingUserSession, HttpServletRequest request) throws IdentityManagerException {
        LOGGER.info("getOrganisations requestingUserSession={}, request={}", (Object)requestingUserSession, (Object)request);
        HashSet<Organisation> result = new HashSet<Organisation>();
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            List<KeycloakGroupDto> groups = KeycloakAdminApi.getGroups(discoveryUrl, requestingUserSession);
            this.addKeycloakGroupsAsOrganisations(result, groups, null);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to get the organisations.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the organisations.", (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_ORGANISATIONS", ex);
        }
        return result;
    }

    @Override
    public Set<Role> getRoles() throws IdentityManagerException {
        LOGGER.warn("getRoles deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Role> getRoles(UserSession requestingUserSession) throws IdentityManagerException {
        LOGGER.warn("getRoles deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Role> getRoles(UserSession requestingUserSession, HttpServletRequest request) throws IdentityManagerException {
        LOGGER.info("getRoles requestingUserSession={}, request={}", (Object)requestingUserSession, (Object)request);
        KeycloakRolesCollector rolesCollector = new KeycloakRolesCollector();
        IdentityManagerException realmRolesException = null;
        IdentityManagerException clientRolesException = null;
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            List<KeycloakRoleDto> realmRoles = KeycloakAdminApi.getRealmRoles(discoveryUrl, requestingUserSession);
            rolesCollector.addFromKeycloakResponse(realmRoles);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to get the realm-roles.", (Throwable)ex);
            realmRolesException = ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the realm-roles.", (Throwable)ex);
            realmRolesException = new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_ROLES", ex);
        }
        try {
            List<KeycloakRoleDto> clientRoles = KeycloakAdminApi.getClientRoles(this.providerMetadata.getOidcDiscoveryUrl(request.getRequestURL().toString()), requestingUserSession, this.clientId);
            rolesCollector.addFromKeycloakResponse(clientRoles);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to get the roles.", (Throwable)ex);
            clientRolesException = ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the roles.", (Throwable)ex);
            clientRolesException = new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_ROLES", ex);
        }
        if (realmRolesException != null && clientRolesException != null) {
            throw realmRolesException;
        }
        return rolesCollector.asSet();
    }

    @Override
    public Set<Right> getRights() throws IdentityManagerException {
        LOGGER.warn("getRights deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Right> getRights(UserSession requestingUserSession) throws IdentityManagerException {
        LOGGER.warn("getRights deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Right> getRights(UserSession requestingUserSession, HttpServletRequest request) throws IdentityManagerException {
        LOGGER.info("getRights requestingUserSession={}, request={}", (Object)requestingUserSession, (Object)request);
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            return this.unsupportedIdentityProviderOperationsFallbackHandler.getRights();
        }
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS_UNSUPPORTED");
    }

    @Override
    public Set<Organisation> getUserOrganisations(String userId) throws IdentityManagerException {
        LOGGER.warn("getUserOrganisations deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Organisation> getUserOrganisations(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.warn("getUserOrganisations deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Organisation> getUserOrganisations(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        LOGGER.info("getUserOrganisations requestingUserSession={}, request={}, userId={}", (Object)requestingUserSession, (Object)request, (Object)userId);
        HashSet<Organisation> result = new HashSet<Organisation>();
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            List<KeycloakGroupDto> userGroups = KeycloakAdminApi.getUserGroups(discoveryUrl, requestingUserSession, userId);
            this.addKeycloakGroupsAsOrganisations(result, userGroups, null);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to get the user groups.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the user groups.", (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ORGANISATIONS", MapUtil.mapOf("user", userId), (Throwable)ex);
        }
        return result;
    }

    @Override
    public Set<Role> getUserRoles(String userId) throws IdentityManagerException {
        LOGGER.warn("getUserRoles deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Role> getUserRoles(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.warn("getUserRoles deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Role> getUserRoles(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        LOGGER.info("getUserRoles requestingUserSession={}, request={}, userId={}", (Object)requestingUserSession, (Object)request, (Object)userId);
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            KeycloakRolesCollector rolesCollector = new KeycloakRolesCollector();
            List<KeycloakRoleDto> userRealmRoles = KeycloakAdminApi.getUserRealmRoles(discoveryUrl, requestingUserSession, userId);
            rolesCollector.addFromKeycloakResponse(userRealmRoles);
            List<KeycloakRoleDto> userClientRoles = KeycloakAdminApi.getUserClientRoles(discoveryUrl, requestingUserSession, userId, this.clientId);
            rolesCollector.addFromKeycloakResponse(userClientRoles);
            return rolesCollector.asSet();
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ROLES", MapUtil.mapOf("user", userId), (Throwable)ex);
        }
    }

    @Override
    public Set<Right> getUserRights(String userId) throws IdentityManagerException {
        LOGGER.warn("getUserRights deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Right> getUserRights(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.warn("getUserRights deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public Set<Right> getUserRights(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        LOGGER.info("getUserRights requestingUserSession={}, request={}, userId={}", (Object)requestingUserSession, (Object)request, (Object)userId);
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            return this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRights(userId);
        }
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS_UNSUPPORTED");
    }

    private User getUser(KeycloakUserDto user) {
        return UserFactory.getUser(user.username(), user.username(), user.firstName(), user.lastName(), user.email());
    }

    private Organisation getOrganisation(KeycloakGroupDto group, KeycloakGroupDto parentGroup) {
        return OrganisationFactory.getOrganisation(group.getName());
    }

    @Override
    public void addUser(String userId, String userPassword) throws IdentityManagerException {
        LOGGER.warn("addUser deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public void addUser(UserSession requestingUserSession, String userId, String userPassword) throws IdentityManagerException {
        LOGGER.warn("addUser deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public void addUser(UserSession requestingUserSession, HttpServletRequest request, String userId, String userPassword) throws IdentityManagerException {
        this.addUser(requestingUserSession, request, UserFactory.getUser(userId), userPassword);
    }

    @Override
    public void addUser(User user, String userPassword) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED");
    }

    @Override
    public void addUser(UserSession requestingUserSession, User user, String userPassword) throws IdentityManagerException {
        LOGGER.warn("addUser deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public void addUser(UserSession requestingUserSession, HttpServletRequest request, User user, String userPassword) throws IdentityManagerException {
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            KeycloakAdminApi.createUser(discoveryUrl, requestingUserSession, user.getUserName(), user.getFirstName(), user.getLastName(), user.getEmail(), userPassword);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to create the user " + user, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create the user " + user, (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_API_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER", ex);
        }
    }

    @Override
    public void addOrganisation(String userId, String orgName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void addOrganisation(UserSession requestingUserSession, String userId, String orgName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void addOrganisation(UserSession requestingUserSession, HttpServletRequest request, String userId, String orgName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void addRight(String userId, String rightName) throws IdentityManagerException {
        this.addRight(null, null, userId, rightName);
    }

    @Override
    public void addRight(UserSession requestingUserSession, String userId, String rightName) throws IdentityManagerException {
        this.addRight(requestingUserSession, null, userId, rightName);
    }

    @Override
    public void addRight(UserSession requestingUserSession, HttpServletRequest request, String userId, String rightName) throws IdentityManagerException {
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            try {
                this.unsupportedIdentityProviderOperationsFallbackHandler.addRight(userId, rightName);
            }
            catch (Exception e) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER", e);
            }
        } else {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER_UNSUPPORTED");
        }
    }

    @Override
    public void addRole(String userId, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER_UNSUPPORTED");
    }

    @Override
    public void addRole(UserSession requestingUserSession, String userId, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER_UNSUPPORTED");
    }

    @Override
    public void addRole(UserSession requestingUserSession, HttpServletRequest request, String userId, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER_UNSUPPORTED");
    }

    @Override
    public void addOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void addOrganisationRole(UserSession requestingUserSession, String orgName, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void addOrganisationRole(UserSession requestingUserSession, HttpServletRequest request, String orgName, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteUser(String userId) throws IdentityManagerException {
        LOGGER.warn("deleteUser deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public void deleteUser(UserSession requestingUserSession, String userId) throws IdentityManagerException {
        LOGGER.warn("deleteUser deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public void deleteUser(UserSession requestingUserSession, HttpServletRequest request, String userId) throws IdentityManagerException {
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            KeycloakAdminApi.deleteUser(discoveryUrl, requestingUserSession, userId);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to delete the user " + userId, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to delete the user " + userId, (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_API_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER", ex);
        }
    }

    @Override
    public void deleteOrganisation(String userId, String orgName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisation(UserSession requestingUserSession, String userId, String orgName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisation(UserSession requestingUserSession, HttpServletRequest request, String userId, String orgName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteRole(String userId, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER_UNSUPPORTED");
    }

    @Override
    public void deleteRole(UserSession requestingUserSession, String userId, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER_UNSUPPORTED");
    }

    @Override
    public void deleteRole(UserSession requestingUserSession, HttpServletRequest request, String userId, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisationRole(UserSession requestingUserSession, String orgName, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisationRole(UserSession requestingUserSession, HttpServletRequest request, String orgName, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteRight(String userId, String rightName) throws IdentityManagerException {
        this.deleteRight(null, null, userId, rightName);
    }

    @Override
    public void deleteRight(UserSession requestingUserSession, String userId, String rightName) throws IdentityManagerException {
        this.deleteRight(requestingUserSession, null, userId, rightName);
    }

    @Override
    public void deleteRight(UserSession requestingUserSession, HttpServletRequest request, String userId, String rightName) throws IdentityManagerException {
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            try {
                this.unsupportedIdentityProviderOperationsFallbackHandler.deleteRight(userId, rightName);
            }
            catch (Exception e) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER", e);
            }
        } else {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER_UNSUPPORTED");
        }
    }

    @Override
    public void updateUser(User user) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_UNSUPPORTED");
    }

    @Override
    public void updateUser(UserSession requestingUserSession, User user) throws IdentityManagerException {
        LOGGER.warn("updateUser deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public void updateUser(UserSession requestingUserSession, HttpServletRequest request, User user) throws IdentityManagerException {
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            KeycloakAdminApi.updateUser(discoveryUrl, requestingUserSession, user.getId(), user.getFirstName(), user.getLastName(), user.getEmail());
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to update the user " + user.getId(), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to update the user " + user.getId(), (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_API_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER", ex);
        }
    }

    @Override
    public void updateUserPassword(String userName, String userPassword) throws IdentityManagerException {
        LOGGER.info("updateUserPassword userName={}, userPassword=...", (Object)userName);
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public void updateUserPassword(UserSession requestingUserSession, String userId, String userPassword) throws IdentityManagerException {
        LOGGER.warn("updateUserPassword deprecated");
        throw new IdentityManagerUnsupportedOperationException("no longer supported");
    }

    @Override
    public void updateUserPassword(UserSession requestingUserSession, HttpServletRequest request, String userId, String userPassword) throws IdentityManagerException {
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            KeycloakAdminApi.updateUserPassword(discoveryUrl, requestingUserSession, userId, userPassword);
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to update the user password for" + userId, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to update the user password for" + userId, (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_API_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", ex);
        }
    }

    @Override
    public boolean checkUserPassword(String userName, String userPassword) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD_UNSUPPORTED");
    }

    @Override
    public boolean checkUserPassword(UserSession requestingUserSession, String userId, String userPassword) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD_UNSUPPORTED");
    }

    @Override
    public boolean checkUserPassword(UserSession requestingUserSession, HttpServletRequest request, String userId, String userPassword) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD_UNSUPPORTED");
    }

    public UserSession impersonateUser(UserSession requestingUserSession, HttpServletRequest req, String userName) throws IdentityManagerException {
        LOGGER.info("impersonateUser requestingUserSession=..., req=..., userName={}", (Object)userName);
        try (Client client = null;){
            this.refreshTokensWithFocusOnExpiredAccessToken(requestingUserSession);
            String currentUserAccessToken = requestingUserSession.getSensitiveCustomData().get("oidc.accessToken").toString();
            KeycloakUserDto user = KeycloakAdminApi.getUserByUserName(this.providerMetadata.getOidcDiscoveryUrl(req.getRequestURL().toString()), requestingUserSession, userName);
            if (user == null) {
                throw new UserNotFoundException(userName);
            }
            String keycloakUserId = user.id();
            OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(req.getRequestURL().toString());
            client = RestWebServiceClientFactory.newClient(false);
            WebTarget target = client.target(oidcProviderMetadata.getTokenEndpointURI());
            Form form = new Form().param("client_id", this.clientId).param("client_secret", this.clientSecret).param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", currentUserAccessToken).param("scope", "openid").param("requested_subject", keycloakUserId);
            Future response = target.request(new String[]{"application/x-www-form-urlencoded"}).accept(new String[]{"application/json"}).buildPost(Entity.form((Form)form)).submit(Response.class);
            Response r = (Response)response.get(30L, TimeUnit.SECONDS);
            String respAsString = (String)r.readEntity(String.class);
            Map<String, Object> respMap = JsonUtil.getInstance().jsonStringAsMap(respAsString);
            if (Response.Status.Family.familyOf((int)r.getStatus()).equals((Object)Response.Status.Family.SUCCESSFUL)) {
                OIDCTokenResponse oidcTokenResponse = (OIDCTokenResponse)OIDCTokenResponseParser.parse((JSONObject)new JSONObject(respMap));
                UserSession userSession = this.createUserSession(oidcTokenResponse, oidcProviderMetadata);
                return userSession;
            }
            try {
                if (respMap.containsKey("error_description")) {
                    throw new Exception((String)respMap.get("error_description"));
                }
                throw new Exception((String)respMap.get("error"));
            }
            catch (IdentityManagerException ex) {
                LOGGER.error("Failed to impersonate user '{}'.", (Object)userName, (Object)ex);
                throw ex;
            }
            catch (Exception ex) {
                LOGGER.error("Failed to impersonate user '{}'.", (Object)userName, (Object)ex);
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_IMPERSONATE_USER", MapUtil.mapOf("user", userName, "error", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public void updateUserLanguage(UserSession requestingUserSession, HttpServletRequest request, String userId, String language) throws IdentityManagerException {
        try {
            String discoveryUrl = this.getDiscoveryUrlAndAddClientAccessTokenIfNecessary(requestingUserSession, request);
            KeycloakAccountApi.updateUserAttributes(discoveryUrl, requestingUserSession, userId, MapUtil.mapOf("locale", ListUtil.listOf(language)));
        }
        catch (IdentityManagerException ex) {
            LOGGER.error("Failed to update the user " + userId, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to update the user " + userId, (Throwable)ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_API_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER", ex);
        }
    }

    public String getUpdateProfileUrl(String requestUrl) throws IdentityProviderException {
        return this.getAuthorizationEndpointURI(requestUrl) + "?client_id=" + this.clientId + "&response_type=code&scope=openid+profile&kc_action=UPDATE_PROFILE";
    }

    public String getUpdatePasswordUrl(String requestUrl) throws IdentityProviderException {
        return this.getAuthorizationEndpointURI(requestUrl) + "?client_id=" + this.clientId + "&response_type=code&scope=openid+profile&kc_action=UPDATE_PASSWORD";
    }

    public String getConfigureTotpUrl(String requestUrl) throws IdentityProviderException {
        return this.getAuthorizationEndpointURI(requestUrl) + "?client_id=" + this.clientId + "&response_type=code&scope=openid+profile&kc_action=CONFIGURE_TOTP";
    }

    private void initClientAccessToken() {
        block2: {
            try {
                this.initClientAccessTokenRefreshScheduler();
                this.fetchAccessTokenForClient();
            }
            catch (IdentityProviderException e) {
                LOGGER.warn("Could not fetch access token for the client. Accessing Keycloak API with BPC-API-Key won't be possible.", (Throwable)e);
                if (this.scheduler == null || this.scheduler.isShutdown()) break block2;
                this.scheduler.shutdownNow();
            }
        }
    }

    private void initClientAccessTokenRefreshScheduler() {
        LOGGER.info("initClientAccessTokenRefreshScheduler");
        if (this.clientAccessToken == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "ClientAccessTokenRenewalThread-" + this.hashCode());
                t.setDaemon(true);
                return t;
            });
        }
    }

    private AccessToken fetchAccessTokenForClient() throws IdentityProviderException {
        long lifetimeInSeconds;
        LOGGER.info("fetchAccessTokenForClient");
        List<URI> discoveryUris = this.providerMetadata.getAllOidcDiscoveryURIs();
        for (int i = 0; i < discoveryUris.size(); ++i) {
            URI discoveryUri = discoveryUris.get(i);
            try {
                this.clientAccessToken = this._fetchAccessToken((AuthorizationGrant)new ClientCredentialsGrant(), this.providerMetadata.getOIDCProviderMetadataForDiscoveryURI(discoveryUri)).getOIDCTokens().getAccessToken();
                this.oidcDiscoveryUrlForClientAccessToken = discoveryUri.toString();
                break;
            }
            catch (IdentityProviderException e) {
                if (i != discoveryUris.size() - 1) continue;
                if (discoveryUris.size() > 1) {
                    LOGGER.error("fetchAccessTokenForClient: fetching of access token failed for all known discovery URIs. Throwing last exception.");
                } else {
                    LOGGER.error("fetchAccessTokenForClient: fetching of access token failed.");
                }
                throw e;
            }
        }
        if ((lifetimeInSeconds = this.clientAccessToken.getLifetime()) > 0L) {
            long tokenRefreshDelayInSeconds = lifetimeInSeconds - 5L;
            tokenRefreshDelayInSeconds = Math.max(5L, tokenRefreshDelayInSeconds);
            LOGGER.info("Schedule client token refresh after {} seconds", (Object)tokenRefreshDelayInSeconds);
            this.scheduler.schedule(this::fetchAccessTokenForClient, tokenRefreshDelayInSeconds, TimeUnit.SECONDS);
        }
        return this.clientAccessToken;
    }

    private String getDiscoveryUrlAndAddClientAccessTokenIfNecessary(UserSession userSession, HttpServletRequest request) throws IdentityProviderException {
        if (this.clientAccessToken != null && userSession instanceof APIKeySession) {
            Set<String> neededRoles = Set.of("bpcadmin", "IDENTITY_MANAGER_ADMIN");
            if (userSession.hasAnyRole(neededRoles)) {
                LOGGER.info("Inject client access token to enable API-Key to access Keycloak API.");
                userSession.getSensitiveCustomData().put("oidc.accessToken", this.clientAccessToken);
                return this.oidcDiscoveryUrlForClientAccessToken;
            }
            LOGGER.info("Don't inject client access token to enable API-Key. Missing one of these roles: {}", neededRoles);
        }
        return this.providerMetadata.getOidcDiscoveryUrl(request.getRequestURL().toString());
    }

    private String getAuthorizationEndpointURI(String requestUrl) throws IdentityProviderException {
        OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(requestUrl);
        return oidcProviderMetadata.getAuthorizationEndpointURI().toString();
    }

    private static class KeycloakRolesCollector {
        private final Set<Role> roles = new HashSet<Role>();

        private KeycloakRolesCollector() {
        }

        public void addFromKeycloakResponse(List<KeycloakRoleDto> keycloakRoles) {
            if (keycloakRoles != null) {
                for (KeycloakRoleDto keycloakRole : keycloakRoles) {
                    this.roles.add(this.createRole(keycloakRole));
                }
            }
        }

        private Role createRole(KeycloakRoleDto keycloakRole) {
            return RolesFactory.getRole(keycloakRole.name());
        }

        public Set<Role> asSet() {
            return this.roles;
        }
    }
}

