/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.core.auth.oidc.OidcUri;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.MapUtil;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OidcProviderMetadata {
    private static final Logger LOGGER = LogManager.getLogger(OidcProviderMetadata.class);
    private final OidcUri metadataDiscoveryUri;
    private final Map<URI, String> providerMetadataMap;

    public OidcProviderMetadata(List<Map<String, Object>> configEntries) throws URISyntaxException, IdentityProviderException {
        Objects.requireNonNull(configEntries, "configEntries cannot be null");
        this.metadataDiscoveryUri = new OidcUri(configEntries);
        this.providerMetadataMap = new HashMap<URI, String>();
        for (URI discoveryURI : this.metadataDiscoveryUri.getURIs()) {
            this.providerMetadataMap.put(discoveryURI, this.fetchOIDCProviderMetadata(discoveryURI));
        }
    }

    public String getOidcDiscoveryUrl(String requestURL) throws IdentityProviderException {
        return this.getOidcDiscoveryURI(requestURL).toString();
    }

    public URI getOidcDiscoveryURI(String requestURL) throws IdentityProviderException {
        if (this.metadataDiscoveryUri.isSingle()) {
            return this.metadataDiscoveryUri.getURIs().iterator().next();
        }
        URI discoveryURI = this.metadataDiscoveryUri.getURIforRequestUrl(requestURL);
        if (discoveryURI == null) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_OIDC_DISCOVERY_URL", MapUtil.mapOf("url", requestURL));
        }
        return discoveryURI;
    }

    public List<URI> getAllOidcDiscoveryURIs() {
        return this.metadataDiscoveryUri.getURIs().stream().toList();
    }

    public OIDCProviderMetadata getOIDCProviderMetadataForDiscoveryURI(URI discoveryURI) throws IdentityProviderException {
        LOGGER.info("getOIDCProviderMetadataForDiscoveryURI discoveryURI={}", (Object)discoveryURI);
        if (!this.providerMetadataMap.containsKey(discoveryURI)) {
            this.providerMetadataMap.put(discoveryURI, this.fetchOIDCProviderMetadata(discoveryURI));
        }
        try {
            String providerMetadataString = this.providerMetadataMap.get(discoveryURI);
            OIDCProviderMetadata providerMetadata = OIDCProviderMetadata.parse((String)providerMetadataString);
            LOGGER.info("Provider metadata: " + providerMetadata);
            return providerMetadata;
        }
        catch (Exception e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_OIDC_DISCOVER_METADATA", e);
        }
    }

    public OIDCProviderMetadata getOIDCProviderMetadataForRequestUrl(String requestUrl) throws IdentityProviderException {
        LOGGER.info("getOIDCProviderMetadataForRequestUrl requestUrl={}", (Object)requestUrl);
        URI discoveryURI = this.getOidcDiscoveryURI(requestUrl);
        return this.getOIDCProviderMetadataForDiscoveryURI(discoveryURI);
    }

    protected String fetchOIDCProviderMetadata(URI oidcDiscoveryURI) throws IdentityProviderException {
        String string;
        block14: {
            LOGGER.info("fetchOIDCProviderMetadata oidcDiscoveryURI={}", (Object)oidcDiscoveryURI);
            URLConnection conn = oidcDiscoveryURI.toURL().openConnection();
            BpcTrustStore.getInstance().setTo(conn);
            conn.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(60L));
            conn.setReadTimeout((int)TimeUnit.SECONDS.toMillis(30L));
            InputStream stream = conn.getInputStream();
            try {
                String providerMetadata;
                try (Scanner s = new Scanner(stream);){
                    providerMetadata = s.useDelimiter("\\A").hasNext() ? s.next() : "";
                }
                string = providerMetadata;
                if (stream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to fetch the OIDC provider metadata from the URL: {}", (Object)oidcDiscoveryURI, (Object)e);
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_OIDC_DISCOVER_METADATA", e);
                }
            }
            stream.close();
        }
        return string;
    }
}

