/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractBackendModuleReloadedEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.AbstractServerModeChangedEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.BackupSupport;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.backup.BackupJobImpl;
import de.virtimo.bpc.core.backup.BackupJobs;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfoDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfosDTO;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class BackupJobsManager {
    private static final Logger LOGGER = LogManager.getLogger(BackupJobsManager.class);
    private final BundleContext bundleContext;
    private CoreModule coreModule;
    private boolean initialized;
    private final BackupJobs backupJobs;
    private final BackupJobs queuedBackupJobs;
    private ScheduledExecutorService executorService;
    private final HashMap<String, ScheduledFuture<?>> backupJobHandles;
    private final EventRegistration eventRegistration;
    private static final Object MODEL_LOCK = new Object();

    public BackupJobsManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.initialized = false;
        this.backupJobs = new BackupJobs();
        this.queuedBackupJobs = new BackupJobs();
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-backups"));
        this.backupJobHandles = new HashMap();
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("_core", new CoreModuleLoadedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("_core", "backupJobs", new BackupJobsSettingUpdatedEventHandler());
        this.eventRegistration.forAnyBackendModuleLoadedEvents(new AnyBackendModuleLoadedEventHandler());
        this.eventRegistration.forAnyBackendModuleReloadedEvents(new AnyBackendModuleReloadedEventHandler());
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeChangedEventHandler(bundleContext));
        this.eventRegistration.forServerModeChangedEvents(new MasterOrSlaveModeChangedEventHandler());
    }

    public void destroy() {
        LOGGER.info("destroy");
        this.eventRegistration.unregisterAllEventHandler();
        this.stopAllBackupJobs();
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.executorService = null;
            }
            catch (InterruptedException | RuntimeException ex) {
                LOGGER.error("Failed to shutdown the backup jobs thread pool.");
            }
        }
        this.coreModule = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackupJobInfosDTO getBackupJobInfos() {
        ArrayList<BackupJobInfoDTO> jobs = new ArrayList<BackupJobInfoDTO>();
        Object object = MODEL_LOCK;
        synchronized (object) {
            Iterator<BackupJob> iterator = this.backupJobs.iterator();
            while (iterator.hasNext()) {
                BackupJob backupJob;
                ScheduledFuture<?> scheduledBackupJob = this.backupJobHandles.get((backupJob = iterator.next()).getBackupJobIdentifier());
                jobs.add(this.createBackupJobInfoDTO(backupJob, false, scheduledBackupJob != null, scheduledBackupJob == null ? -1L : scheduledBackupJob.getDelay(TimeUnit.SECONDS)));
            }
            for (BackupJob queuedBackupJob : this.queuedBackupJobs) {
                jobs.add(this.createBackupJobInfoDTO(queuedBackupJob, true, false, -1L));
            }
        }
        return new BackupJobInfosDTO(jobs);
    }

    private BackupJobInfoDTO createBackupJobInfoDTO(BackupJob backupJob, boolean queued, boolean scheduled, long nextCheckStartsInSeconds) {
        return new BackupJobInfoDTO(backupJob.getBackupJobIdentifier(), backupJob.getBackupSetting().isEnabled(), backupJob.getBackupSetting().getIntervalInSeconds(), backupJob.getBackupSetting().getIndicesToBackup(), backupJob.getTimestampOfLastestBackup(), backupJob.getTimestampOfNextBackup(), queued, scheduled, nextCheckStartsInSeconds);
    }

    private void startAllBackupJobs() {
        LOGGER.info("startAllBackupJobs");
        if (this.coreModule != null) {
            Setting backupJobsSetting = this.coreModule.getConfiguration().getSetting("backupJobs");
            this.initializeFromBackupJobsSetting(backupJobsSetting);
        } else {
            LOGGER.error("Failed to initialize and start the backup jobs due to missing CoreModule.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFromBackupJobsSetting(Setting backupJobsSetting) {
        LOGGER.info("initializeFromBackupJobsSetting backupJobsSetting={}", (Object)backupJobsSetting);
        Object object = MODEL_LOCK;
        synchronized (object) {
            this.initialized = true;
            BackupJobs backupJobsFromSetting = this.getBackupJobsFromSetting(backupJobsSetting);
            if (!backupJobsFromSetting.equals(this.backupJobs)) {
                BackupJobs backupJobsToStart = new BackupJobs(backupJobsFromSetting);
                backupJobsToStart.addAll(this.getQueuedBackupJobs(backupJobsToStart));
                backupJobsToStart.addAll(this.getMandatoryBackupJobsFromResourceFile(backupJobsToStart));
                this.stopAllBackupJobs();
                for (BackupJob backupJobToStart : backupJobsToStart) {
                    this.backupJobs.add(backupJobToStart);
                    this.scheduleBackupJob(backupJobToStart);
                }
                if (!backupJobsFromSetting.equals(backupJobsToStart)) {
                    this.saveBackupJobsBackToSetting();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackupJob getBackupJob(String backupJobIdentifier) {
        LOGGER.info("getBackupJob backupJobIdentifier={}", (Object)backupJobIdentifier);
        Object object = MODEL_LOCK;
        synchronized (object) {
            return this.backupJobs.get(backupJobIdentifier);
        }
    }

    private void saveBackupJobsBackToSetting() {
        LOGGER.info("saveBackupJobsBackToSetting");
        if (this.coreModule != null) {
            try {
                Map<String, Object> backupJobsForSettingValue = this.getBackupJobsAsSettingValue(this.backupJobs);
                Setting backupJobsSetting = this.coreModule.getConfiguration().getSetting("backupJobs");
                SimpleSettingImpl updatedBackupJobsSetting = new SimpleSettingImpl(backupJobsSetting, backupJobsForSettingValue);
                this.coreModule.getConfiguration().updateSetting(updatedBackupJobsSetting);
            }
            catch (SettingException ex) {
                LOGGER.error("Failed to save the updated backup jobs back to the core module setting 'backupJobs'.", (Throwable)ex);
            }
        }
    }

    private BackupJobs getBackupJobsFromSetting(Setting backupJobsSetting) {
        LOGGER.info("getBackupJobsFromSetting backupJobsSetting={}", (Object)backupJobsSetting);
        BackupJobs result = new BackupJobs();
        if (backupJobsSetting != null) {
            Map backupJobs = backupJobsSetting.getSettingValue().asMap(new HashMap());
            result.addAll(this.getBackupJobsFromSettingValue(backupJobs));
        }
        return result;
    }

    private BackupJobs getBackupJobsFromSettingValue(Map backupJobs) {
        LOGGER.info("getBackupJobsFromSettingValue backupJobs={}", (Object)backupJobs);
        BackupJobs result = new BackupJobs();
        if (backupJobs != null) {
            for (Object backupJobIdentifierObject : backupJobs.keySet()) {
                String backupJobIdentifier = String.valueOf(backupJobIdentifierObject);
                Map backupJob = (Map)backupJobs.get(backupJobIdentifierObject);
                BackupSetting backupJobSetting = BackupSettingFactory.createFrom(backupJob.get("settings"), (Collection)backupJob.get("indices"));
                result.add(new BackupJobImpl(this.bundleContext, backupJobIdentifier, backupJobSetting));
            }
        }
        return result;
    }

    private Map<String, Object> getBackupJobsAsSettingValue(BackupJobs backupJobs) {
        LOGGER.info("getBackupJobsAsSettingValue backupJobs=...");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (backupJobs != null) {
            for (BackupJob backupJob : backupJobs) {
                result.put(backupJob.getBackupJobIdentifier(), BackupSettingFactory.asBackupJobSettingValue(backupJob.getBackupSetting()));
            }
        }
        return result;
    }

    private BackupJobs getQueuedBackupJobs(BackupJobs backupJobsToStart) {
        LOGGER.info("getQueuedBackupJobs backupJobsToStart=...");
        BackupJobs result = this.updatedBackupJobsToStart(backupJobsToStart, this.queuedBackupJobs);
        this.queuedBackupJobs.clear();
        return result;
    }

    private BackupJobs getMandatoryBackupJobsFromResourceFile(BackupJobs backupJobsToStart) {
        LOGGER.info("getMandatoryBackupJobsFromResourceFile backupJobsToStart=...");
        Map<String, Object> backupJobsResourceFile = JsonDefaultsUtil.loadJsonFileAsMap("defaults/core/backup_jobs.json");
        BackupJobs backupJobsFromResourceFile = this.getBackupJobsFromSettingValue(backupJobsResourceFile);
        return this.updatedBackupJobsToStart(backupJobsToStart, backupJobsFromResourceFile);
    }

    private BackupJobs updatedBackupJobsToStart(BackupJobs backupJobsToStart, BackupJobs otherBackupJobs) {
        LOGGER.info("updatedBackupJobsToStart backupJobsToStart=..., otherBackupJobs=...");
        BackupJobs result = new BackupJobs();
        for (BackupJob otherBackupJob : otherBackupJobs) {
            String backupJobIdentifier = otherBackupJob.getBackupJobIdentifier();
            if (!backupJobsToStart.contains(backupJobIdentifier)) {
                result.add(otherBackupJob);
                continue;
            }
            BackupJob existingBackupJob = backupJobsToStart.get(backupJobIdentifier);
            BackupSetting updatedBackupSetting = BackupSetting.copyOf(existingBackupJob.getBackupSetting()).withIndicesToBackup(otherBackupJob.getBackupSetting().getIndicesToBackup()).build();
            result.add(new BackupJobImpl(this.bundleContext, backupJobIdentifier, updatedBackupSetting));
        }
        return result;
    }

    private void scheduleBackupJob(BackupJob backupJob) {
        LOGGER.info("scheduleBackupJob backupJob={}", (Object)backupJob);
        this.stopBackupJob(backupJob.getBackupJobIdentifier());
        ScheduledFuture<?> newBackupJobHandle = this.executorService.scheduleWithFixedDelay(backupJob, 120L, 60L, TimeUnit.SECONDS);
        this.backupJobHandles.put(backupJob.getBackupJobIdentifier(), newBackupJobHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleBackupJobWithSettings(String backupJobIdentifier, BackupSetting backupJobSetting) {
        LOGGER.info("scheduleBackupJobWithSettings backupJobIdentifier={}, backupJobSetting={}", (Object)backupJobIdentifier, (Object)backupJobSetting);
        if (StringUtil.isNullOrEmpty(backupJobIdentifier)) {
            throw new IllegalArgumentException("backupJobIdentifier cannot be null or empty");
        }
        if (backupJobSetting == null) {
            throw new IllegalArgumentException("backupJobSetting cannot be null");
        }
        Object object = MODEL_LOCK;
        synchronized (object) {
            if (this.initialized) {
                BackupJobImpl backupJobToSchedule = null;
                BackupJob existingBackupJob = this.backupJobs.get(backupJobIdentifier);
                if (existingBackupJob != null) {
                    if (!existingBackupJob.getBackupSetting().getIndicesToBackup().equals(backupJobSetting.getIndicesToBackup())) {
                        BackupSetting updatedBackupSetting = BackupSetting.copyOf(existingBackupJob.getBackupSetting()).withIndicesToBackup(backupJobSetting.getIndicesToBackup()).build();
                        backupJobToSchedule = new BackupJobImpl(this.bundleContext, backupJobIdentifier, updatedBackupSetting);
                    }
                } else {
                    backupJobToSchedule = new BackupJobImpl(this.bundleContext, backupJobIdentifier, backupJobSetting);
                }
                if (backupJobToSchedule != null) {
                    this.scheduleBackupJob(backupJobToSchedule);
                    this.backupJobs.add(backupJobToSchedule);
                    this.saveBackupJobsBackToSetting();
                }
            } else {
                BackupJobImpl newBackupJob = new BackupJobImpl(this.bundleContext, backupJobIdentifier, backupJobSetting);
                this.queuedBackupJobs.add(newBackupJob);
            }
        }
    }

    private void stopAllBackupJobs() {
        LOGGER.info("stopAllBackupJobs");
        for (String backupJobIdentifier : new ArrayList<String>(this.backupJobHandles.keySet())) {
            this.stopBackupJob(backupJobIdentifier);
        }
    }

    void stopBackupJob(String backupJobIdentifier) {
        LOGGER.info("stopBackupJob backupJobIdentifier={}", (Object)backupJobIdentifier);
        if (!StringUtil.isNullOrEmpty(backupJobIdentifier)) {
            ScheduledFuture<?> existingBackupJobHandle = this.backupJobHandles.remove(backupJobIdentifier);
            if (existingBackupJobHandle != null) {
                if (existingBackupJobHandle.cancel(true)) {
                    LOGGER.info("{}: Running BackupJob cancelled", (Object)backupJobIdentifier);
                } else {
                    LOGGER.warn("{}: Could not cancel the running BackupJob", (Object)backupJobIdentifier);
                }
            } else {
                LOGGER.info("{}: There is no existing BackupJob to cancel", (Object)backupJobIdentifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteBackupJob(String backupJobIdentifier) {
        LOGGER.info("deleteBackupJob backupJobIdentifier={}", (Object)backupJobIdentifier);
        if (!StringUtil.isNullOrEmpty(backupJobIdentifier)) {
            this.stopBackupJob(backupJobIdentifier);
            Object object = MODEL_LOCK;
            synchronized (object) {
                BackupJob backupJobToDelete = this.backupJobs.get(backupJobIdentifier);
                if (backupJobToDelete != null) {
                    this.backupJobs.remove(backupJobToDelete);
                    this.saveBackupJobsBackToSetting();
                }
            }
        }
    }

    private class CoreModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            BackupJobsManager.this.coreModule = (CoreModule)module;
        }
    }

    private class BackupJobsSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private BackupJobsSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting backupJobTemplatesSetting) {
            LOGGER.info("{}.processSetting backupJobTemplatesSetting=...", (Object)this.getClass().getSimpleName());
            BackupJobsManager.this.initializeFromBackupJobsSetting(backupJobTemplatesSetting);
        }
    }

    private class AnyBackendModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private AnyBackendModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            if (module instanceof BackupSupport) {
                BackupSupport moduleWithBackupSupport = (BackupSupport)((Object)module);
                BackupJobsManager.this.scheduleBackupJobWithSettings(module.getModuleId(), moduleWithBackupSupport.getBackupSetting());
            }
        }
    }

    private class AnyBackendModuleReloadedEventHandler
    extends AbstractBackendModuleReloadedEventHandler {
        private AnyBackendModuleReloadedEventHandler() {
        }

        @Override
        public void processReloadedModule(Module module) {
            LOGGER.info("{}.processReloadedModule module=...", (Object)this.getClass().getSimpleName());
            if (module instanceof BackupSupport) {
                BackupSupport moduleWithBackupSupport = (BackupSupport)((Object)module);
                BackupJobsManager.this.scheduleBackupJobWithSettings(module.getModuleId(), moduleWithBackupSupport.getBackupSetting());
            }
        }
    }

    private class MaintenanceModeChangedEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeChangedEventHandler(BundleContext bundleContext) {
            super(bundleContext, "_core");
        }

        @Override
        public void processNewMaintenanceMode(boolean enabled) {
            LOGGER.info("{}.processNewMaintenanceMode enabled={}", (Object)this.getClass().getSimpleName(), (Object)enabled);
            try {
                if (enabled) {
                    BackupJobsManager.this.stopAllBackupJobs();
                } else if (BackupJobsManager.this.coreModule.isMasterServer()) {
                    BackupJobsManager.this.startAllBackupJobs();
                }
            }
            catch (Exception ex) {
                LOGGER.error(this.getClass().getSimpleName() + ": Failed to process the maintenance mode changed event.", (Throwable)ex);
            }
        }
    }

    private class MasterOrSlaveModeChangedEventHandler
    extends AbstractServerModeChangedEventHandler {
        private MasterOrSlaveModeChangedEventHandler() {
        }

        @Override
        public void processThisIsNowTheMasterServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowTheMasterServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            try {
                if (!BackupJobsManager.this.coreModule.isMaintenanceModeEnabled()) {
                    BackupJobsManager.this.startAllBackupJobs();
                }
            }
            catch (Exception ex) {
                LOGGER.error("{}: Failed to process the set this server as master event.", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        }

        @Override
        public void processThisIsNowASlaveServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowASlaveServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            try {
                BackupJobsManager.this.stopAllBackupJobs();
            }
            catch (Exception ex) {
                LOGGER.error("{}: Failed to process the set this server as slave event.", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        }
    }
}

