/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.db;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.db.DatabaseManager;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class DataSourceConnectionTester
implements ConnectionTester {
    private static final Logger LOGGER = LogManager.getLogger(DataSourceConnectionTester.class);
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;

    public DataSourceConnectionTester(BundleContext bundleContext) {
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canBeUsedToPerformConnectionTest(ModuleInstance moduleInstance) {
        LOGGER.info("canBeUsedToPerformConnectionTest moduleInstance=...");
        return moduleInstance != null && "backendconnection".equalsIgnoreCase(moduleInstance.getParentModule().getModuleId()) && "data_source".equalsIgnoreCase(moduleInstance.getInstanceType());
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws ConnectionTestException {
        LOGGER.info("performConnectionTest moduleInstance=..., testData=...");
        try {
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            String dataSourceName = moduleInstance.getModuleId();
            databaseManager.performConnectionTest(dataSourceName);
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }
}

