/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deeplink.monitor;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.module.AbstractModuleInstance;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorInstanceInvestigator {
    private static final Logger LOGGER = LogManager.getLogger(MonitorInstanceInvestigator.class);
    private static final String SETTING_DATA_INDEX = "data_index";
    private static final String SETTING_DATA_HISTORY_INDEX = "data_historyIndex";
    private final ModuleManager moduleManager;

    public MonitorInstanceInvestigator(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private Module getMonitorModule() throws ModuleNotFoundException {
        return this.moduleManager.getModuleById("monitor");
    }

    public Set<String> getIDsOfMonitorInstancesUsingThisOpenSearchIndex(String indexName) throws ModuleNotFoundException {
        LOGGER.debug("getIDsOfMonitorInstancesUsingThisOpenSearchIndex indexName={}", (Object)indexName);
        return this.getIDsOfMonitorInstancesUsingThisOpenSearchIndices(Set.of(indexName));
    }

    public Set<String> getIDsOfMonitorInstancesUsingThisOpenSearchIndices(Set<String> indexNames) throws ModuleNotFoundException {
        LOGGER.debug("getIDsOfMonitorInstancesUsingThisOpenSearchIndices indexNames={}", indexNames);
        Objects.requireNonNull(indexNames, "'indexNames' must not be null");
        if (indexNames.isEmpty()) {
            throw new IllegalArgumentException("No index names given");
        }
        if (indexNames.size() > 2) {
            throw new IllegalArgumentException("Too many index names given");
        }
        HashSet<String> moduleInstanceIds = new HashSet<String>();
        InstantiableModule monitorModule = (InstantiableModule)this.getMonitorModule();
        Collection<ModuleInstance> moduleInstances = monitorModule.getModuleInstances().values();
        for (ModuleInstance moduleInstance : moduleInstances) {
            if (!(moduleInstance instanceof AbstractModuleInstance)) continue;
            AbstractModuleInstance monitorModuleInstance = (AbstractModuleInstance)moduleInstance;
            ModuleConfiguration moduleInstanceConfiguration = monitorModuleInstance.getConfiguration();
            String parentIndexName = moduleInstanceConfiguration.getSettingValue(SETTING_DATA_INDEX).asString("");
            String childIndexName = moduleInstanceConfiguration.getSettingValue(SETTING_DATA_HISTORY_INDEX).asString("");
            if (indexNames.size() == 1) {
                if (!indexNames.contains(parentIndexName)) continue;
                moduleInstanceIds.add(monitorModuleInstance.getModuleId());
                continue;
            }
            if (indexNames.size() != 2 || !indexNames.contains(parentIndexName) || !indexNames.contains(childIndexName)) continue;
            moduleInstanceIds.add(monitorModuleInstance.getModuleId());
        }
        return moduleInstanceIds;
    }
}

