/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.exception;

import de.virtimo.bpc.api.WebErrorCode;
import javax.ws.rs.core.Response;

public enum CoreErrorCode implements WebErrorCode
{
    UNEXPECTED(1, Response.Status.INTERNAL_SERVER_ERROR),
    UNSUPPORTED_OPERATION(3, Response.Status.SERVICE_UNAVAILABLE),
    RS_WS_CLIENT_INIT_FAILED(4, Response.Status.INTERNAL_SERVER_ERROR),
    SERVER_NOT_FOUND(9, Response.Status.NOT_FOUND),
    LICENSE_UNSUFFICIENT(10, Response.Status.FORBIDDEN),
    LICENSE_EXPIRED(11, Response.Status.INTERNAL_SERVER_ERROR),
    LICENSE_CHECK_FAILED(12, Response.Status.INTERNAL_SERVER_ERROR),
    LICENSE_MODULE_INSTANCE_LIMIT_REACHED(13, Response.Status.INTERNAL_SERVER_ERROR),
    LICENSE_MODULE_INSTANCE_NOT_ALLOWED_TO_CREATE(14, Response.Status.INTERNAL_SERVER_ERROR),
    MODULE_SETTING_INVALID(26, Response.Status.INTERNAL_SERVER_ERROR),
    MODULE_SETTING_NO_ACCESS_RIGHT(27, Response.Status.FORBIDDEN),
    MODULE_SETTINGS_SAVE_FAILED(28, Response.Status.INTERNAL_SERVER_ERROR),
    MODULE_SETTINGS_DELETE_FAILED(29, Response.Status.INTERNAL_SERVER_ERROR),
    MODULE_SETTING_NOT_FOUND(30, Response.Status.NOT_FOUND),
    MODULE_SETTINGS_MESS(31, Response.Status.INTERNAL_SERVER_ERROR),
    AUTHENTICATION_UNEXPECTED_STATUS_CODE(500, Response.Status.INTERNAL_SERVER_ERROR),
    AUTHENTICATION_SESSION_CHECK_FAILED(510, Response.Status.INTERNAL_SERVER_ERROR),
    AUTHENTICATION_LOGIN_FAILED(520, Response.Status.INTERNAL_SERVER_ERROR),
    AUTHENTICATION_FORM_BASED_LOGIN_NOT_SUPPORTED(521, Response.Status.SERVICE_UNAVAILABLE),
    AUTHENTICATION_CONCURRENT_USER_LIMIT_REACHED(522, Response.Status.FORBIDDEN),
    AUTHENTICATION_LOGOUT_FAILED(530, Response.Status.INTERNAL_SERVER_ERROR),
    AUTHENTICATION_UNAUTHORIZED(540, Response.Status.UNAUTHORIZED),
    AUTHENTICATION_CSRF_TOKEN_CHECK_FAILED(541, Response.Status.UNAUTHORIZED),
    AUTHENTICATION_IP_PINNING_CHECK_FAILED(542, Response.Status.UNAUTHORIZED),
    AUTHENTICATION_ROLE_CHECK_FAILED(550, Response.Status.FORBIDDEN),
    AUTHENTICATION_RIGHT_CHECK_FAILED(560, Response.Status.FORBIDDEN),
    AUTHENTICATION_INVALID_URL(570, Response.Status.INTERNAL_SERVER_ERROR),
    AUTHENTICATION_RESPONSE_MISSING(580, Response.Status.INTERNAL_SERVER_ERROR),
    AUTHENTICATION_RESPONSE_INVALID(590, Response.Status.INTERNAL_SERVER_ERROR),
    IDENTITY_PROVIDER_NETWORK_ERROR(1000, Response.Status.INTERNAL_SERVER_ERROR),
    IDENTITY_PROVIDER_UNSUPPORTED_OPERATION(1001, Response.Status.SERVICE_UNAVAILABLE),
    IDENTITY_PROVIDER_NOT_FOUND(1002, Response.Status.INTERNAL_SERVER_ERROR),
    IDENTITY_PROVIDER_CONFIG(1010, Response.Status.INTERNAL_SERVER_ERROR),
    IDENTITY_PROVIDER_USER_NOT_FOUND(1020, Response.Status.INTERNAL_SERVER_ERROR),
    IDENTITY_PROVIDER_AUTH_FLOW_ERROR(1030, Response.Status.INTERNAL_SERVER_ERROR),
    IDENTITY_PROVIDER_TOKEN_ERROR(1040, Response.Status.INTERNAL_SERVER_ERROR),
    IDENTITY_PROVIDER_IMPERSONATE_NOT_ALLOWED(1050, Response.Status.FORBIDDEN),
    IDENTITY_PROVIDER_VIRTIMO_TRUSTSTORE_ERROR(1060, Response.Status.INTERNAL_SERVER_ERROR),
    IDENTITY_PROVIDER_FORBIDDEN(1070, Response.Status.FORBIDDEN),
    IDENTITY_PROVIDER_API_ERROR(1080, Response.Status.INTERNAL_SERVER_ERROR),
    DATABASE_EXCEPTION(11000, Response.Status.INTERNAL_SERVER_ERROR),
    DATABASE_DATASOURCE_CONFIG_FAILURE(11011, Response.Status.INTERNAL_SERVER_ERROR),
    DATABASE_INVALID_CONNECTION(11020, Response.Status.BAD_REQUEST),
    DATABASE_TABLE_NOT_FOUND(11030, Response.Status.BAD_REQUEST),
    DATABASE_COLUMN_NOT_FOUND(11040, Response.Status.BAD_REQUEST),
    AUDITLOG_UNAUTHORIZED(19000, Response.Status.UNAUTHORIZED),
    AUDITLOG_MAINTENANCE(19001, Response.Status.SERVICE_UNAVAILABLE),
    LOG_SERVICE_UNAUTHORIZED(20000, Response.Status.UNAUTHORIZED),
    LOG_SERVICE_MAINTENANCE(20001, Response.Status.SERVICE_UNAVAILABLE),
    LOG_SERVICE_MISSING_SERVICE(20002, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_DB_LOGGING_FAILED(20100, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_DB_DELETE_FAILED(20101, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_DB_WRONG_TABLE_NAME(20102, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_DB_TABLE_MISSING(20103, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_DB_COLUMN_MISSING(20104, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_DB_GET_METADATA_FAILED(20105, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_DB_NOT_SUPPORTED(20106, Response.Status.SERVICE_UNAVAILABLE),
    LOG_SERVICE_ES_FAILURE(20201, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_ES_FIELD_MISSING(20202, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_ES_LOGGING_FAILED(20203, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_ES_DELETE_FAILED(20204, Response.Status.INTERNAL_SERVER_ERROR),
    LOG_SERVICE_ES_QUERY_RANGE_LIMIT(20205, Response.Status.REQUESTED_RANGE_NOT_SATISFIABLE),
    DEEPLINK_CREATION_FAILED(20299, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_MODULE_NOT_FOUND(21010, Response.Status.BAD_REQUEST),
    DEPLOYMENT_MODULE_INSTANCE_NOT_FOUND(21020, Response.Status.BAD_REQUEST),
    DEPLOYMENT_MODULE_NOT_INSTANTIABLE(21030, Response.Status.NOT_ACCEPTABLE),
    DEPLOYMENT_DELETE_MODULE_SETTING_FAILED(21040, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_DELETE_MODULE_INSTANCE_SETTING_FAILED(21050, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_DATA_MISSING(21060, Response.Status.BAD_REQUEST),
    DEPLOYMENT_DELETE_STORE_ITEM_FAILED(21070, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR(21500, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR(21510, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_SYSTEM_UNEXPECTED_STATUS_CODE(21520, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_SYSTEM_RESPONSE_MISSING(21530, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_BUNDLE_NOT_FOUND(21540, Response.Status.NOT_FOUND),
    DEPLOYMENT_BUNDLE_NOT_DOWNLOADABLE(21541, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_FILE_NOT_UPLOADABLE(21542, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_INDEX_COPY_TO_SAME_SYSTEM_ERROR(21550, Response.Status.INTERNAL_SERVER_ERROR),
    DEPLOYMENT_INDEX_ALIAS_ERROR(21551, Response.Status.INTERNAL_SERVER_ERROR),
    PERFORMANCE_MEASUREMENT_FAILED(21700, Response.Status.INTERNAL_SERVER_ERROR),
    FRONTEND_LOGGING_FAILED(21800, Response.Status.INTERNAL_SERVER_ERROR),
    INTERNATIONALIZATION_LANGUAGE_NOT_FOUND(22000, Response.Status.NOT_FOUND),
    REPLICATION_SETTING_MISSING(23000, Response.Status.INTERNAL_SERVER_ERROR),
    REPLICATION_SETTING_INVALID(23010, Response.Status.INTERNAL_SERVER_ERROR),
    REPLICATION_DISABLED(23015, Response.Status.SERVICE_UNAVAILABLE),
    REPLICATION_JOB_NOT_FOUND(23020, Response.Status.NOT_FOUND),
    REPLICATION_JOB_ALREADY_RUNNING(23021, Response.Status.CONFLICT),
    REPLICATION_JOB_DISABLED(23022, Response.Status.CONFLICT),
    REPLICATION_JOB_SHADOW_COPY_RUNNING(23023, Response.Status.CONFLICT),
    REPLICATION_JOB_ALREADY_STARTED(23024, Response.Status.CONFLICT),
    REPLICATION_JOB_INDEX_PREPARATION_FAILED(23030, Response.Status.INTERNAL_SERVER_ERROR),
    REPLICATION_JOB_ENDLESS_LOOP_DETECTED(23040, Response.Status.INTERNAL_SERVER_ERROR),
    HTTPPROXY_ILLEGAL_ACCESS(24000, Response.Status.FORBIDDEN),
    HTTPPROXY_MALFORMED_URL(24010, Response.Status.BAD_REQUEST),
    HTTPPROXY_CONNECTION_TIMEOUT(24020, Response.Status.GATEWAY_TIMEOUT),
    HTTPPROXY_CONNECTION_REFUSED(24030, Response.Status.SERVICE_UNAVAILABLE),
    BACKUP_ACTIVATION_FAILED(25020, Response.Status.CONFLICT),
    BACKUP_RESTORE_FAILED(25030, Response.Status.CONFLICT),
    BACKUP_DOWNLOAD_FAILED(25040, Response.Status.CONFLICT),
    BACKUP_DELETE_FAILED(25070, Response.Status.INTERNAL_SERVER_ERROR),
    DATA_LOCK_ITEM_NOT_FOUND(25510, Response.Status.NOT_FOUND),
    LOCAL_SETTING_NOT_FOUND(27000, Response.Status.NOT_FOUND),
    LOCAL_SETTING_UPDATE_ALREADY_IN_PROGRESS(27005, Response.Status.CONFLICT),
    LOCAL_SETTING_INVALID_INPUT(27010, Response.Status.NOT_ACCEPTABLE),
    LOOKUP_JOIN_SETTING_INVALID(28000, Response.Status.INTERNAL_SERVER_ERROR),
    LOOKUP_JOIN_REPLICATION_JOB_NOT_FOUND(28010, Response.Status.NOT_FOUND),
    LOOKUP_JOIN_OPENSEARCH_LOGGING_DISABLED(28020, Response.Status.INTERNAL_SERVER_ERROR),
    INDEX_MIGRATION_UNEXPECTED_ERROR(29000, Response.Status.INTERNAL_SERVER_ERROR),
    INDEX_MIGRATION_ALIAS_WITH_MULTIPLE_INDICES(29010, Response.Status.INTERNAL_SERVER_ERROR),
    INDEX_MIGRATION_INDEX_EXISTS_ALREADY(29020, Response.Status.INTERNAL_SERVER_ERROR),
    INDEX_MIGRATION_NOT_ALLOWED_VERSION(29030, Response.Status.INTERNAL_SERVER_ERROR),
    AUDIT_LOGGER_LOGGING_FAILED(30000, Response.Status.INTERNAL_SERVER_ERROR),
    REINDEX_ACTION_GENERAL_ERROR(31000, Response.Status.INTERNAL_SERVER_ERROR),
    REINDEX_ACTION_ALREADY_STARTED(31001, Response.Status.CONFLICT),
    REINDEX_ACTION_ALIAS_MISUSAGE(31010, Response.Status.CONFLICT),
    REINDEX_ACTION_INDEX_NOT_FOUND(31020, Response.Status.NOT_FOUND),
    REINDEX_ACTION_INDEX_EXISTS_ALREADY(31030, Response.Status.CONFLICT),
    REINDEX_ACTION_INDEX_CREATION_FAILED(31040, Response.Status.INTERNAL_SERVER_ERROR),
    REINDEX_ACTION_REINDEX_FAILED(31050, Response.Status.INTERNAL_SERVER_ERROR),
    REINDEX_ACTION_ALIAS_SWITCHING_FAILED(31060, Response.Status.INTERNAL_SERVER_ERROR),
    REINDEX_ACTION_UPDATE_INDEX_SETTINGS_FAILED(31070, Response.Status.INTERNAL_SERVER_ERROR),
    REINDEX_ACTION_MIGRATION_NECESSARY(31080, Response.Status.CONFLICT),
    IM_EXCEPTION(33000, Response.Status.INTERNAL_SERVER_ERROR),
    IM_USER_NOT_FOUND(33010, Response.Status.INTERNAL_SERVER_ERROR),
    IM_NOT_FOUND(33020, Response.Status.INTERNAL_SERVER_ERROR),
    REPLICATION_JOBS_LOGGING_FAILED(34000, Response.Status.INTERNAL_SERVER_ERROR),
    NOTIFICATION_FAILED(35000, Response.Status.INTERNAL_SERVER_ERROR),
    NOTIFICATION_NOT_FOUND(35001, Response.Status.NOT_FOUND),
    BOM_MISSING_INPUT(35200, Response.Status.INTERNAL_SERVER_ERROR),
    BOM_NOT_FOUND(35201, Response.Status.NOT_FOUND);

    private final int number;
    private final Response.Status responseStatus;

    private CoreErrorCode(int number, Response.Status responseStatus) {
        this.number = number;
        this.responseStatus = responseStatus;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public Response.Status getResponseStatus() {
        return this.responseStatus;
    }
}

