/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.frontendlogging.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.frontendlogging.FrontendLoggingManager;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="/frontendLogging")
@Tag(name="Frontend Logging API", description="The aim of the Frontend Log Service is to make client-side logging (e.g. JavaScript console outputs) accessible within the backend.\nThis API provides an endpoint to post these logs.\n")
public class FrontendLoggingEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(FrontendLoggingEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<FrontendLoggingManager> loggingManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public FrontendLoggingEndpoint(BundleContext bundleContext) {
        LOGGER.info("FrontendLoggingEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.loggingManagerTracker = new BpcServicesTracker<FrontendLoggingManager>(this.bundleContext, FrontendLoggingManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @POST
    @Path(value="/{sessionId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Saves the logs provided in the body to the OpenSearch index `bpc-frontend-logging`.", description="Saves the logs provided in the body to the OpenSearch index `bpc-frontend-logging`.")
    public Response saveFrontendLogData(@Parameter(description="the id of the session") @PathParam(value="sessionId") String sessionId, @HeaderParam(value="user-agent") String userAgent, List<Map<String, String>> measurements) {
        try {
            this.loggingManagerTracker.getService().saveFrontendLogData(sessionId, userAgent, measurements);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to save frontend log", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

