/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.httpproxy.HttpProxyCallConfig;
import de.virtimo.bpc.core.httpproxy.HttpProxyServiceImpl;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpProxyCall {
    private static final Logger LOGGER = LogManager.getLogger(HttpProxyServiceImpl.class);
    private final HttpProxyCallConfig config;

    public HttpProxyCall(HttpProxyCallConfig config) {
        this.config = config;
    }

    public void doConnectionTest(Map<String, Object> testData) throws ConnectionTestException {
        LOGGER.info("doConnectionTest testData=...");
        try {
            UserSession userSession = (UserSession)testData.get("___userSession___");
            HttpHeaders headers = (HttpHeaders)testData.get("___httpHeaders___");
            UriInfo uriInfo = (UriInfo)testData.get("___uriInfo___");
            String targetPath = (String)testData.get("targetPath");
            String targetUrl = (String)testData.get("targetUrl");
            String url = this.prepareUrl(targetPath, targetUrl, uriInfo);
            Response response = this.getWebClient(url, userSession, headers).get();
            Response.StatusType statusType = response.getStatusInfo();
            if (statusType.getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw new ConnectionTestException("Connection test failed with HTTP status code '${statusCode}': ${statusReason}", MapUtil.mapOf("url", url, "statusCode", statusType.getStatusCode(), "statusReason", statusType.getReasonPhrase()));
            }
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }

    public Response doGet(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession) throws HttpProxyException {
        LOGGER.info("doGet targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=...", (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.doHttpRequest(targetPath, targetUrl, uriInfo, headers, userSession, WebClient::get);
    }

    public Response doPost(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body) throws HttpProxyException {
        LOGGER.info("doPost targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=..., body=...", (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.doHttpRequest(targetPath, targetUrl, uriInfo, headers, userSession, webClient -> {
            MediaType mediaType = headers.getMediaType();
            if (mediaType != null) {
                return webClient.type(mediaType).post((Object)Entity.entity((Object)body, (MediaType)mediaType));
            }
            return webClient.post((Object)Entity.entity((Object)body, (String)""));
        });
    }

    public Response doPut(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body) throws HttpProxyException {
        LOGGER.info("doPut targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=..., body=...", (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.doHttpRequest(targetPath, targetUrl, uriInfo, headers, userSession, webClient -> webClient.type(headers.getMediaType()).put((Object)body));
    }

    public Response doDelete(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession) throws HttpProxyException {
        LOGGER.info("doDelete targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=...", (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.doHttpRequest(targetPath, targetUrl, uriInfo, headers, userSession, WebClient::delete);
    }

    public Response doOptions(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession) throws HttpProxyException {
        LOGGER.info("doOptions targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=...", (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.doHttpRequest(targetPath, targetUrl, uriInfo, headers, userSession, WebClient::options);
    }

    public Response doPatch(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body) throws HttpProxyException {
        LOGGER.info("doPatch targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=..., body=...", (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.doHttpRequest(targetPath, targetUrl, uriInfo, headers, userSession, webClient -> webClient.type(headers.getMediaType()).invoke("PATCH", (Object)body));
    }

    private Response doHttpRequest(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, Function<WebClient, Response> httpInvokeFunc) throws HttpProxyException {
        String url = this.prepareUrl(targetPath, targetUrl, uriInfo);
        LOGGER.info("forward to: {}", (Object)url);
        try {
            WebClient webClient = this.getWebClient(url, userSession, headers);
            Response response = httpInvokeFunc.apply(webClient);
            return this.prepareResponse(response);
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_TIMEOUT, "Connection to backend system '${url}' timed out.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            if (e.getCause() instanceof ConnectException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_REFUSED, "Connection to backend system '${url}' refused.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
    }

    private Response prepareResponse(Response response) {
        LOGGER.info("prepareResponse response=...");
        LOGGER.info("Prepare response to client");
        MultivaluedMap<String, Object> newHeaders = this.prepareResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
        LOGGER.info("Old Headers: {}", (Object)response.getHeaders());
        LOGGER.info("New Headers: {}", newHeaders);
        Response newResponse = Response.fromResponse((Response)response).replaceAll(newHeaders).build();
        LOGGER.info("Response Status: {} Mediatype: {}", (Object)newResponse.getStatus(), (Object)newResponse.getMediaType());
        return newResponse;
    }

    private String convertStreamToString(InputStream is) {
        LOGGER.debug("convertStreamToString is=...");
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private String prepareUrlParams(UriInfo uriInfo) {
        LOGGER.debug("prepareUrlParams uriInfo={}", (Object)uriInfo);
        if (uriInfo == null) {
            return "";
        }
        MultivaluedMap queryParams = uriInfo.getQueryParameters(false);
        if (queryParams == null || queryParams.isEmpty()) {
            return "";
        }
        Object paramString = "?";
        for (String theKey : queryParams.keySet()) {
            for (String theValue : (List)queryParams.get((Object)theKey)) {
                if (!((String)paramString).equals("?")) {
                    paramString = (String)paramString + "&";
                }
                paramString = (String)paramString + theKey + "=" + theValue;
                LOGGER.debug("Found query param: {} = {}", (Object)theKey, (Object)theValue);
            }
        }
        return paramString;
    }

    private MultivaluedMap<String, String> prepareHeaders(HttpHeaders headers, List<String> cookieFilters) {
        LOGGER.debug("prepareHeaders headers=..., cookieFilters=...");
        return this.prepareHeaders((MultivaluedMap<String, String>)headers.getRequestHeaders(), cookieFilters);
    }

    private MultivaluedMap<String, Object> prepareResponseHeaders(MultivaluedMap<String, Object> headers) {
        LOGGER.debug("prepareResponseHeaders headers=...");
        MultivaluedHashMap newMap = new MultivaluedHashMap();
        for (String key : headers.keySet()) {
            List strings = ((List)headers.get((Object)key)).stream().map(Object::toString).collect(Collectors.toList());
            newMap.put((Object)key, strings);
        }
        MultivaluedMap<String, String> preparedMap = this.prepareHeaders((MultivaluedMap<String, String>)newMap, null);
        MultivaluedHashMap resultMap = new MultivaluedHashMap();
        for (String key : preparedMap.keySet()) {
            ArrayList objects = new ArrayList((Collection)preparedMap.get((Object)key));
            resultMap.put((Object)key, objects);
        }
        return resultMap;
    }

    private List<String> getHeaderValues(MultivaluedMap<String, String> headers, String caseInsensitiveKey) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                if (!key.equalsIgnoreCase(caseInsensitiveKey)) continue;
                return (List)headers.get((Object)key);
            }
        }
        return null;
    }

    private Set<String> getHttpHeaderFilterValuesInLowerCase() {
        HashSet<String> result = new HashSet<String>();
        List httpHeaderFilters = this.config.getHttpHeaderFilters();
        if (httpHeaderFilters != null) {
            for (Object httpHeaderFilter : httpHeaderFilters) {
                if (httpHeaderFilter instanceof String) {
                    result.add(((String)httpHeaderFilter).toLowerCase());
                    continue;
                }
                if (httpHeaderFilter == null) continue;
                result.add(String.valueOf(httpHeaderFilter).toLowerCase());
            }
        }
        return result;
    }

    MultivaluedMap<String, String> prepareHeaders(MultivaluedMap<String, String> oldHeaders, List<String> cookieFilters) {
        LOGGER.debug("prepareHeaders oldHeaders={}, cookieFilters={}", oldHeaders, cookieFilters);
        MultivaluedHashMap newHeaders = new MultivaluedHashMap();
        Set<String> headerIgnoreListEntriesInLowerCase = this.getHttpHeaderFilterValuesInLowerCase();
        headerIgnoreListEntriesInLowerCase.add("X-APIKey".toLowerCase());
        if (cookieFilters == null) {
            cookieFilters = new ArrayList<String>();
        }
        cookieFilters.add("(?i);[^;.]*path[^;,$]*");
        for (String key : oldHeaders.keySet()) {
            if (key.equalsIgnoreCase("cookie") || key.equalsIgnoreCase("set-cookie")) {
                ArrayList<String> newCookieList = new ArrayList<String>();
                for (String cookie : (List)oldHeaders.get((Object)key)) {
                    LOGGER.debug("OLD Cookie: {}", (Object)cookie);
                    String newCookie = cookie;
                    for (String filter : cookieFilters) {
                        newCookie = newCookie.replaceAll(filter, "");
                    }
                    newCookieList.add(newCookie);
                    LOGGER.debug("NEW Cookie: {}", (Object)newCookie);
                }
                newHeaders.put((Object)key, newCookieList);
                continue;
            }
            if (key.equalsIgnoreCase("host")) {
                List oldHostValues = (List)oldHeaders.get((Object)key);
                if (oldHostValues == null) continue;
                ArrayList<String> newForwardedHosts = new ArrayList<String>();
                List<String> oldForwardedHosts = this.getHeaderValues(oldHeaders, "X-Forwarded-Host");
                if (oldForwardedHosts != null) {
                    newForwardedHosts.addAll(oldForwardedHosts);
                }
                newForwardedHosts.addAll(oldHostValues);
                LOGGER.debug("Header X-Forwarded-Host = {}", newForwardedHosts);
                newHeaders.put((Object)"X-Forwarded-Host", newForwardedHosts);
                continue;
            }
            if (key.toLowerCase().startsWith(":")) {
                LOGGER.debug("Remove HTTP/2 pseudo header: {}", (Object)key);
                continue;
            }
            if (!headerIgnoreListEntriesInLowerCase.contains(key.toLowerCase())) {
                List values = (List)oldHeaders.get((Object)key);
                if (values.isEmpty() || values.size() == 1 && values.get(0) == null) {
                    LOGGER.debug("SKIP empty or null Header {} - {}", (Object)key, (Object)values);
                    continue;
                }
                LOGGER.debug("Header {} - {}", (Object)key, (Object)values);
                newHeaders.put((Object)key, new ArrayList(values));
                continue;
            }
            LOGGER.debug("Remove header: {}", (Object)key);
        }
        LOGGER.info("newHeaders: {}", (Object)newHeaders);
        return newHeaders;
    }

    String prepareUrl(String targetPath, String targetUrl, UriInfo uriInfo) throws HttpProxyException {
        LOGGER.debug("prepareUrl targetPath={}, targetUrl={}, uriInfo={}", (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        Object baseUrl = this.config.getBaseUrl();
        if (baseUrl == null) {
            baseUrl = "";
        }
        if (targetUrl == null) {
            LOGGER.info("targetUrl missing");
            targetUrl = "";
        }
        if (targetPath == null) {
            LOGGER.info("targetPath missing");
            targetPath = "";
        }
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        if (targetPath.startsWith("/")) {
            targetPath = targetPath.substring(1);
        }
        if (targetPath.endsWith("/") && targetUrl.startsWith("/")) {
            targetPath = targetPath.substring(0, targetPath.length() - 1);
        }
        try {
            URL url = new URL((String)baseUrl + targetPath + targetUrl + this.prepareUrlParams(uriInfo));
            LOGGER.info("Target url: {}", (Object)url);
            if (Arrays.asList("LOCALHOST", "127.0.0.1").contains(url.getHost().toUpperCase())) {
                try {
                    String realHost = InetAddress.getLocalHost().getHostName();
                    url = url.getRef() != null ? new URL(url.getProtocol(), realHost, url.getPort(), url.getFile() + "#" + url.getRef()) : new URL(url.getProtocol(), realHost, url.getPort(), url.getFile());
                }
                catch (UnknownHostException ex) {
                    throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_ILLEGAL_ACCESS, "No URLs to local interface allowed: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
                }
            }
            LOGGER.info("Final target url: {}", (Object)url);
            return url.toExternalForm();
        }
        catch (MalformedURLException ex) {
            throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_MALFORMED_URL, "Malformed URL: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    private WebClient getWebClient(String url, UserSession userSession, HttpHeaders headers) throws KeyStoreException, NoSuchAlgorithmException {
        WebClient client;
        LOGGER.debug("getWebClient url={}, userSession=..., headers={}", (Object)url, (Object)headers);
        if (this.config.isBasicAuthEnabled()) {
            client = WebClient.create((String)url, (String)this.config.getBasicAuthUsername(), (String)this.config.getBasicAuthPassword(), null);
            LOGGER.info("Using BasicAuth");
        } else {
            client = WebClient.create((String)url);
            LOGGER.info("Not using BasicAuth");
        }
        HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
        HTTPClientPolicy policy = conduit.getClient();
        long timeout = this.config.getTimeout();
        if (timeout > 0L) {
            LOGGER.info("Set timeout to {}", (Object)timeout);
            policy.setReceiveTimeout(timeout * 1000L);
            policy.setConnectionTimeout(timeout * 1000L);
        }
        String proxyServer = this.config.getProxyServer();
        Integer proxyServerPort = this.config.getProxyServerPort();
        if (proxyServer != null && !proxyServer.trim().isEmpty()) {
            LOGGER.debug("Use proxy server {}:{}", (Object)proxyServer, (Object)proxyServerPort);
            policy.setProxyServer(proxyServer);
            policy.setProxyServerPort(proxyServerPort);
        }
        BpcTrustStore.getInstance().setTo(client, this.config.isAllowUntrustedConnectionsEnabled());
        if (this.config.isInjectSessionJwtEnabled()) {
            LOGGER.debug("inject userSession as JWT");
            JWTClaimsSet claimsSet = null;
            try {
                claimsSet = new JWTClaimsSet.Builder().subject("bpc").expirationTime(new Date(new Date().getTime() + 60000L)).claim("bpcUserSession", (Object)JsonUtil.getInstance().convertPojoToJsonString(userSession)).build();
                PlainJWT sessionJwt = new PlainJWT(claimsSet);
                MultivaluedHashMap jwtHeader = new MultivaluedHashMap();
                String bpcUserSessionJwt = sessionJwt.serialize();
                jwtHeader.putSingle((Object)"X-Bpc-Session", (Object)bpcUserSessionJwt);
                LOGGER.debug("JWT: {}", (Object)bpcUserSessionJwt);
                client = client.headers((MultivaluedMap)jwtHeader);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("failed to inject userSession as JWT", (Throwable)e);
            }
        }
        ArrayList<String> cookieFilter = new ArrayList<String>();
        if (this.config.isFilterSessionCookieEnabled()) {
            cookieFilter.add(userSession.getSessionId());
        }
        MultivaluedMap<String, String> newHeaders = this.prepareHeaders(headers, cookieFilter);
        Map<String, String> additionalHttpHeadersToSet = this.config.getAdditionalHttpHeaders();
        for (String httpHeaderName : additionalHttpHeadersToSet.keySet()) {
            String httpHeaderValue = additionalHttpHeadersToSet.get(httpHeaderName);
            newHeaders.add((Object)httpHeaderName, (Object)httpHeaderValue);
        }
        client = client.headers(newHeaders);
        if (!newHeaders.containsKey((Object)"Accept") || ((List)newHeaders.get((Object)"Accept")).isEmpty()) {
            client.accept(new String[]{"*/*"});
        }
        return client;
    }
}

