/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.core.httpproxy.HttpProxyCallConfig;
import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpProxyCallConfigFromBackendConnection
implements HttpProxyCallConfig {
    private final ModuleInstance httpProxyInstance;
    private final Map<String, String> additionalHttpHeaders;

    public HttpProxyCallConfigFromBackendConnection(ModuleInstance httpProxyInstance) {
        this.httpProxyInstance = httpProxyInstance;
        this.additionalHttpHeaders = new HashMap<String, String>();
    }

    @Override
    public String getBaseUrl() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("connectionBaseUrl").asString();
    }

    @Override
    public boolean isBasicAuthEnabled() {
        return !StringUtil.isNullOrEmpty(this.getBasicAuthUsername()) && !StringUtil.isNullOrEmpty(this.getBasicAuthPassword());
    }

    @Override
    public String getBasicAuthUsername() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("connectionUsername").asString();
    }

    @Override
    public String getBasicAuthPassword() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("connectionPassword").asString();
    }

    @Override
    public long getTimeout() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("connectionTimeout").asLong(-1L);
    }

    @Override
    public String getProxyServer() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("proxyServer").asString();
    }

    @Override
    public Integer getProxyServerPort() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("proxyServerPort").asInt(80);
    }

    @Override
    public boolean isAllowUntrustedConnectionsEnabled() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("allowUntrustedConnections").asBoolean(false);
    }

    @Override
    public boolean isInjectSessionJwtEnabled() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("injectSessionJwt").asBoolean(false);
    }

    @Override
    public boolean isFilterSessionCookieEnabled() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("filterSessionCookie").asBoolean(false);
    }

    @Override
    public List getHttpHeaderFilters() {
        return this.httpProxyInstance.getConfiguration().getSettingValue("httpHeaderFilter").asList(null);
    }

    @Override
    public Map<String, String> getAdditionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    @Override
    public void addAdditionalHttpHeader(String httpHeaderName, String httpHeaderValue) {
        this.additionalHttpHeaders.put(httpHeaderName, httpHeaderValue);
    }
}

