/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.internationalization;

import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.util.SetUtil;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class TranslationsOfBundles {
    private static final Logger LOGGER = LogManager.getLogger(TranslationsOfBundles.class);
    private static final Set<String> BUNDLE_FOLDERS_TO_LOOK_FOR_TRANSLATION_FILES = SetUtil.setOf("resources/languages", "languages");
    private final BundleContext bundleContext;
    private final Set<String> isoLanguages;
    private Map<String, Map<String, Map<String, Object>>> translations;

    TranslationsOfBundles(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.isoLanguages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
        this.translations = null;
    }

    boolean isInitialized() {
        return this.translations != null;
    }

    void forceTranslationsReload() {
        LOGGER.info("forceTranslationsReload");
        this.translations = null;
    }

    boolean existsLanguage(String lowerCaseLangKey) {
        return this.translations != null && this.translations.containsKey(lowerCaseLangKey);
    }

    Set<String> getLanguages() {
        LOGGER.info("getLanguages");
        if (!this.isInitialized()) {
            this.loadTranslationsFromAllBundles();
        }
        return this.translations != null ? new HashSet<String>(this.translations.keySet()) : new HashSet();
    }

    Map<String, Object> getTranslationsForLanguage(String lowerCaseLangKey) {
        LOGGER.info("getTranslationsForLanguage lowerCaseLangKey={}", (Object)lowerCaseLangKey);
        if (!this.isInitialized()) {
            this.loadTranslationsFromAllBundles();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.existsLanguage(lowerCaseLangKey)) {
            HashMap<String, Map<String, Object>> entriesOfLang = new HashMap<String, Map<String, Object>>(this.translations.get(lowerCaseLangKey));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-be-core", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-fe-core", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-be-dashboard", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-fe-dashboard", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-be-monitor", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-fe-monitor", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-be-globalsearch", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-fe-globalsearch", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-be-analysis", entriesOfLang));
            result.putAll(this.getAndRemoveTranslationsOfBundle("de.virtimo.bpc.bpc-fe-analysis", entriesOfLang));
            for (String symbolicBundleName : new HashSet(entriesOfLang.keySet())) {
                result.putAll(this.getAndRemoveTranslationsOfBundle(symbolicBundleName, entriesOfLang));
            }
        }
        return result;
    }

    private Map<String, Object> getAndRemoveTranslationsOfBundle(String symbolicBundleName, Map<String, Map<String, Object>> fromEntriesOfLang) {
        Map<Object, Object> result = null;
        if (fromEntriesOfLang != null && fromEntriesOfLang.containsKey(symbolicBundleName)) {
            result = fromEntriesOfLang.remove(symbolicBundleName);
        }
        return result == null ? new HashMap() : result;
    }

    private void addTranslationsOfBundle(String lang, String symbolicBundleName, Map<String, Object> trans) {
        Map<String, Object> entriesOfBundle;
        Map<String, Map<String, Object>> entriesOfLang;
        LOGGER.info("addTranslationsOfBundle lang={}, symbolicBundleName={}, trans=...", (Object)lang, (Object)symbolicBundleName);
        if (this.translations == null) {
            this.translations = new HashMap<String, Map<String, Map<String, Object>>>();
        }
        if ((entriesOfLang = this.translations.get(lang.toLowerCase())) == null) {
            entriesOfLang = new HashMap<String, Map<String, Object>>();
            this.translations.put(lang.toLowerCase(), entriesOfLang);
        }
        if ((entriesOfBundle = entriesOfLang.get(symbolicBundleName)) == null) {
            entriesOfBundle = new HashMap<String, Object>();
            entriesOfLang.put(symbolicBundleName, entriesOfBundle);
        }
        entriesOfBundle.putAll(trans);
    }

    void removeTranslationsOfBundle(Bundle bundle) {
        LOGGER.info("removeTranslationsOfBundle bundle={}", (Object)bundle);
        if (this.translations == null) {
            return;
        }
        if (bundle == null) {
            return;
        }
        String symbolicBundleName = bundle.getSymbolicName();
        for (String lang : this.translations.keySet()) {
            Map<String, Map<String, Object>> entriesOfLang = this.translations.get(lang);
            entriesOfLang.remove(symbolicBundleName.toLowerCase());
        }
    }

    void loadTranslationsFromBundle(Bundle bundle) {
        LOGGER.info("loadTranslationsFromBundle bundle={}", (Object)bundle);
        String symbolicBundleName = bundle.getSymbolicName();
        if (!BpcBundleUtil.isBpcBundle(bundle)) {
            LOGGER.info("The bundle '" + symbolicBundleName + "' is not a BPC bundle and can be safely ignored.");
            return;
        }
        Set<URL> urlsToJsonFilesInBundle = BpcBundleUtil.getFilesInBundleAtSpecificFolders(bundle, BUNDLE_FOLDERS_TO_LOOK_FOR_TRANSLATION_FILES, "*.json");
        if (urlsToJsonFilesInBundle.isEmpty()) {
            LOGGER.info("The bundle '{}' does not have embedded translation files", (Object)symbolicBundleName);
            return;
        }
        for (URL jsonFileUrl : urlsToJsonFilesInBundle) {
            Map<String, Object> trans;
            String filePath = jsonFileUrl.getFile();
            String fileNameWithoutExtension = this.extractFilenameWithoutExtensionFromPath(filePath);
            if (!this.isoLanguages.contains(fileNameWithoutExtension.toLowerCase()) || (trans = JsonDefaultsUtil.loadJsonFileAsMap(bundle, filePath)) == null) continue;
            this.addTranslationsOfBundle(fileNameWithoutExtension.toLowerCase(), symbolicBundleName, trans);
        }
    }

    private String extractFilenameWithoutExtensionFromPath(String filePath) {
        File file = new File(filePath);
        String fileNameWithExtension = file.getName();
        return fileNameWithExtension.substring(0, fileNameWithExtension.lastIndexOf("."));
    }

    private void loadTranslationsFromAllBundles() {
        LOGGER.info("loadTranslationsFromAllBundles");
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.loadTranslationsFromBundle(bundle);
        }
    }
}

