/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationException;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.core.notification.NotificationNotFoundException;
import de.virtimo.bpc.core.notification.NotificationPersistenceHandler;
import de.virtimo.bpc.core.notification.Notifications;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class NotificationManagerImpl
implements NotificationManager,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(NotificationManagerImpl.class);
    private static final Object NOTIFICATION_INDEX_LOCK = new Object();
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<CoreBundleService> coreBundleServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;

    public NotificationManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.coreBundleServiceTracker = new BpcServicesTracker<CoreBundleService>(bundleContext, CoreBundleService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification addNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("addNotification notification={}", (Object)notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification createdNotification = persistenceHandler.saveNotification(notification);
            this.fireNotificationAddedEvent(createdNotification);
            return createdNotification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification updateNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("updateNotification notification={}", (Object)notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification existingNotification = persistenceHandler.loadNotification(notification.getId());
            Notification updatedNotification = persistenceHandler.saveNotification(notification);
            this.fireNotificationUpdatedEvent(existingNotification, updatedNotification);
            return updatedNotification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification deleteNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("deleteNotification notification={}", (Object)notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            persistenceHandler.deleteNotification(notification.getId());
            this.fireNotificationDeletedEvent(notification);
            return notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification deleteNotificationById(String notificationId) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("deleteNotificationById notificationId={}", (Object)notificationId);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification notification = persistenceHandler.loadNotification(notificationId);
            persistenceHandler.deleteNotification(notification.getId());
            this.fireNotificationDeletedEvent(notification);
            return notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification getNotification(String notificationId) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("getNotification notificationId={}", (Object)notificationId);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            return persistenceHandler.loadNotification(notificationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notifications getNotifications(UserSession userSession, Integer start, Integer limit) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("getNotifications userSession=..., start={}, limit={}", (Object)start, (Object)limit);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            return persistenceHandler.loadNotifications(start, limit, userSession.getLoginName(), userSession.getRoles(), userSession.getOrganisations());
        }
    }

    private void fireNotificationAddedEvent(Notification notification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationAdded", "notification", notification);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.warn("Failed to send the notification added event.", (Throwable)ex);
        }
    }

    private void fireNotificationUpdatedEvent(Notification oldNotification, Notification newNotification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationUpdated", "notification", newNotification);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.warn("Failed to send the notification updated event.", (Throwable)ex);
        }
    }

    private void fireNotificationDeletedEvent(Notification notification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationDeleted", "notification", notification);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.warn("Failed to send the notification deleted event.", (Throwable)ex);
        }
    }
}

