/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.BpcIndexStateException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.service.event.Event;

public class BpcIndexStateImpl
implements BpcIndexState {
    private static final Logger LOGGER = LogManager.getLogger(BpcIndexStateImpl.class);
    private static final String INDEX_DOES_NOT_EXIST = "@@@index_does_not_exist@@@";
    private static final Object INDEX_LOCK = new Object();
    private OpenSearchService oss;
    private String alias;
    private String indexName;
    private final EventRegistration eventRegistration;

    public BpcIndexStateImpl(OpenSearchService oss, String alias) {
        LOGGER.info("{}: BpcIndexState()", (Object)alias);
        this.oss = oss;
        this.alias = alias;
        this.indexName = null;
        this.eventRegistration = new EventRegistration(oss.getBundleContext());
        this.eventRegistration.forOpenSearchPluginEvents(new IndexDeletedEventHandler());
    }

    @Override
    public void destroy() {
        LOGGER.info("{}: destroy", (Object)this.alias);
        this.eventRegistration.unregisterAllEventHandler();
        this.oss = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepareUsing(BpcIndexCreateCallable indexCreateCallable) throws BpcIndexStateException, OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
        LOGGER.debug("{}: prepareUsing indexCreateCallable=... (indexName={})", (Object)this.alias, (Object)this.indexName);
        Object object = INDEX_LOCK;
        synchronized (object) {
            if (this.indexName == null) {
                if (this.oss.existsIndex(this.alias)) {
                    Set<String> indexNames = this.oss.getIndexNamesWithAlias(this.alias);
                    if (indexNames == null || indexNames.size() == 0) {
                        throw new BpcIndexStateException("The OpenSearch alias '" + this.alias + "' is an index and not just an alias for an index. Please fix this.");
                    }
                    if (indexNames.size() != 1) throw new BpcIndexStateException("The OpenSearch alias '" + this.alias + "' has multiple indices assigned. Please fix this.");
                    this.indexName = indexNames.iterator().next();
                } else if (indexCreateCallable != null) {
                    this.indexName = indexCreateCallable.createIndex(this.oss);
                    LOGGER.info("{}: The OpenSearch index '{} has been created", (Object)this.alias, (Object)this.indexName);
                } else {
                    this.indexName = INDEX_DOES_NOT_EXIST;
                }
            } else if (this.indexName.equals(INDEX_DOES_NOT_EXIST)) {
                if (indexCreateCallable != null) {
                    try {
                        this.indexName = indexCreateCallable.createIndex(this.oss);
                        LOGGER.info("{}: The OpenSearch index '{} has been created", (Object)this.alias, (Object)this.indexName);
                    }
                    catch (OpenSearchRelatedException ex) {
                        LOGGER.error("{}: Something failed while creating the index for the alias.", (Object)this.alias, (Object)ex);
                        this.indexName = null;
                        throw ex;
                    }
                } else {
                    this.indexName = INDEX_DOES_NOT_EXIST;
                }
            }
            if (this.indexName == null || this.indexName.equals(INDEX_DOES_NOT_EXIST)) {
                throw new BpcIndexStateException("The index with the alias '" + this.alias + "' is somehow not pre-parable.");
            }
            LOGGER.debug("The index '{}' for alias '{}' is prepared and can be used.", (Object)this.indexName, (Object)this.alias);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Object object = INDEX_LOCK;
        synchronized (object) {
            return this.indexName != null && !this.indexName.equals(INDEX_DOES_NOT_EXIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlias() {
        Object object = INDEX_LOCK;
        synchronized (object) {
            return this.alias;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIndexName() {
        Object object = INDEX_LOCK;
        synchronized (object) {
            return this.indexName == null ? null : (this.indexName.equals(INDEX_DOES_NOT_EXIST) ? null : this.indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        LOGGER.debug("{}: reset", (Object)this.alias);
        Object object = INDEX_LOCK;
        synchronized (object) {
            this.indexName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDeletedIndex(String nameOfDeletedIndex) {
        LOGGER.debug("{}: handleDeletedIndex nameOfDeletedIndex={}", (Object)this.alias, (Object)nameOfDeletedIndex);
        Object object = INDEX_LOCK;
        synchronized (object) {
            block15: {
                if (this.indexName != null && this.indexName.equals(nameOfDeletedIndex)) {
                    LOGGER.info("{}: The OpenSearch index '{}' has been deleted. Checking for other indices with this alias to use instead...", (Object)this.alias, (Object)nameOfDeletedIndex);
                    try {
                        if (this.oss.existsIndex(this.alias)) {
                            Set<String> indexNames = this.oss.getIndexNamesWithAlias(this.alias);
                            if (indexNames.size() == 1) {
                                String existingIndexName = indexNames.iterator().next();
                                if (this.indexName.equals(existingIndexName)) {
                                    LOGGER.warn("{}: Strange, the alias '{}' still belongs to the just deleted index '{}'. Checking again for max. 1 second.", (Object)this.alias, (Object)this.alias, (Object)this.indexName);
                                    if (this.hasIndexReallyBeenDeleted(this.alias, nameOfDeletedIndex, 1000L)) {
                                        LOGGER.info("{}: Great, the alias has no longer the just deleted index '{}' assigned.", (Object)this.alias, (Object)this.indexName);
                                        this.indexName = INDEX_DOES_NOT_EXIST;
                                    } else {
                                        LOGGER.error("{}: This alias has still the just deleted index '{}' assigned. Please fix this or report it to OpenSearch.", (Object)this.alias, (Object)this.indexName);
                                        this.indexName = null;
                                    }
                                } else {
                                    this.indexName = existingIndexName;
                                    LOGGER.info("{}: There is already an index '{}' with this alias and I'm going to use this instead of the just deleted one.", (Object)this.alias, (Object)this.indexName);
                                }
                            } else {
                                LOGGER.error("{}: This alias has multiple indices assigned. Please fix this.", (Object)this.alias);
                                this.indexName = null;
                            }
                            break block15;
                        }
                        LOGGER.info("{}: There is no other index with this alias. It gets created on next usage.", (Object)this.alias);
                        this.indexName = INDEX_DOES_NOT_EXIST;
                    }
                    catch (OpenSearchRelatedException ex) {
                        LOGGER.error("{}: Failed to check for already existing indices.", (Object)this.alias, (Object)ex);
                        this.indexName = null;
                    }
                } else if (this.indexName != null && !this.indexName.equals(INDEX_DOES_NOT_EXIST) && this.alias.equals(nameOfDeletedIndex)) {
                    LOGGER.info("{}: The OpenSearch index '{}' (same name as the alias) has been deleted. That was obviously an incorrectly created index.", (Object)this.alias, (Object)nameOfDeletedIndex);
                    this.indexName = INDEX_DOES_NOT_EXIST;
                }
            }
        }
    }

    private boolean hasIndexReallyBeenDeleted(String aliasOfDeletedIndex, String nameOfDeletedIndex, long maxMilliseconds) throws OpenSearchRelatedException {
        LOGGER.debug("{}: hasIndexReallyBeenDeleted aliasOfDeletedIndex={}, nameOfDeletedIndex={}, maxMilliseconds={})", (Object)this.alias, (Object)aliasOfDeletedIndex, (Object)nameOfDeletedIndex, (Object)maxMilliseconds);
        long startTime = System.currentTimeMillis();
        boolean deleted = false;
        while (!deleted) {
            boolean timeout;
            deleted = this.checkIfIndexHasReallyBeenDeleted(aliasOfDeletedIndex, nameOfDeletedIndex);
            if (deleted) continue;
            boolean bl = timeout = startTime + maxMilliseconds < System.currentTimeMillis();
            if (timeout) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return deleted;
    }

    private boolean checkIfIndexHasReallyBeenDeleted(String aliasOfDeletedIndex, String nameOfDeletedIndex) throws OpenSearchRelatedException {
        LOGGER.debug("{}: checkIfIndexHasReallyBeenDeleted aliasOfDeletedIndex={}, nameOfDeletedIndex={}", (Object)this.alias, (Object)aliasOfDeletedIndex, (Object)nameOfDeletedIndex);
        if (this.oss.existsIndex(aliasOfDeletedIndex)) {
            Set<String> existingIndexNames = this.oss.getIndexNamesWithAlias(aliasOfDeletedIndex);
            for (String existingIndexName : existingIndexNames) {
                if (!nameOfDeletedIndex.equals(existingIndexName)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "BpcIndexState{alias='" + this.alias + "', indexName='" + this.indexName + "'}";
    }

    private class IndexDeletedEventHandler
    extends AbstractEventHandler {
        private IndexDeletedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("IndexDeleted");
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}: {}.processEvent event=...", (Object)BpcIndexStateImpl.this.alias, (Object)this.getClass().getSimpleName());
            Map msg = (Map)event.getProperty("IndexDeleted");
            String nameOfDeletedIndex = (String)msg.get("index");
            if (!StringUtil.isNullOrEmpty(nameOfDeletedIndex)) {
                BpcIndexStateImpl.this.handleDeletedIndex(nameOfDeletedIndex);
            } else {
                LOGGER.error("Please inform the BPC developers. There is something wrong with the received deleted index event: " + msg);
            }
        }
    }
}

