/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.opensearch.Broadcast;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.util.MapUtil;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BroadcastImpl
implements Broadcast {
    private static final Logger LOGGER = LogManager.getLogger(BroadcastImpl.class);
    private final EventManager eventManager;
    private final String serverUUID;

    public BroadcastImpl(EventManager eventManager, String serverUUID) {
        this.eventManager = eventManager;
        this.serverUUID = serverUUID;
    }

    private void broadcastConfigChangeMessage(BroadcastType bpcConfigurationType, Map<String, Object> data) {
        LOGGER.info("broadcastConfigChangeMessage bpcConfigurationType={}, data=...", (Object)bpcConfigurationType);
        BroadcastWebsocketMessage broadcastWebsocketMessage = new BroadcastWebsocketMessage(this.serverUUID, LocalDateTime.now(), bpcConfigurationType.name(), data);
        this.eventManager.fireEvent("de/virtimo/os-bpc-plugin-send-broadcast-message", "msg", broadcastWebsocketMessage);
    }

    @Override
    public void moduleInstanceCreated(String moduleId, String instanceId, String instanceType) {
        LOGGER.info("moduleInstanceCreated moduleId={}, instanceId={}, instanceType={}", (Object)moduleId, (Object)instanceId, (Object)instanceType);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceCreated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void moduleUpdated(String moduleId) {
        LOGGER.info("moduleUpdated moduleId={}", (Object)moduleId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleUpdated, MapUtil.mapOf("moduleId", moduleId));
    }

    @Override
    public void moduleInstanceUpdated(String moduleId, String instanceId, String instanceType) {
        LOGGER.info("moduleInstanceUpdated moduleId={}, instanceId={}, instanceType={}", (Object)moduleId, (Object)instanceId, (Object)instanceType);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceUpdated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void moduleInstanceDeleted(String moduleId, String instanceId) {
        LOGGER.info("moduleInstanceDeleted moduleId={}, instanceId={}", (Object)moduleId, (Object)instanceId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceDeleted, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId));
    }

    @Override
    public void moduleSettingDeleted(String moduleId, String settingName) {
        LOGGER.info("moduleSettingDeleted moduleId={}, settingName={}", (Object)moduleId, (Object)settingName);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleUpdated, MapUtil.mapOf("moduleId", moduleId));
    }

    @Override
    public void moduleInstanceSettingDeleted(String moduleId, String instanceId, String instanceType, String settingName) {
        LOGGER.info("moduleInstanceSettingDeleted moduleId={}, instanceId={}, instanceType={}, settingName={}", (Object)moduleId, (Object)instanceId, (Object)instanceType, (Object)settingName);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceUpdated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void clientEvent(Map<String, Object> clientEvent) {
        LOGGER.info("clientEvent clientEvent={}", clientEvent);
        this.broadcastConfigChangeMessage(BroadcastType.ClientEvent, clientEvent);
    }

    @Override
    public void moduleRelatedStoreItemDeleted(String moduleId, String storeId, String storeItemId) {
        LOGGER.info("moduleRelatedStoreItemDeleted moduleId={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)storeId, (Object)storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleRelatedStoreItemDeleted, MapUtil.mapOf("moduleId", moduleId, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleRelatedStoreItemCreated(String moduleId, String storeId, String storeItemId) {
        LOGGER.info("moduleRelatedStoreItemCreated moduleId={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)storeId, (Object)storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleRelatedStoreItemCreated, MapUtil.mapOf("moduleId", moduleId, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleRelatedStoreItemUpdated(String moduleId, String storeId, String storeItemId) {
        LOGGER.info("moduleRelatedStoreItemUpdated moduleId={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)storeId, (Object)storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleRelatedStoreItemUpdated, MapUtil.mapOf("moduleId", moduleId, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleInstanceRelatedStoreItemDeleted(String moduleId, String instanceId, String instanceType, String storeId, String storeItemId) {
        LOGGER.info("moduleInstanceRelatedStoreItemDeleted moduleId={}, instanceId={}, instanceType={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)instanceId, (Object)instanceType, (Object)storeId, (Object)storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceRelatedStoreItemDeleted, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleInstanceRelatedStoreItemCreated(String moduleId, String instanceId, String instanceType, String storeId, String storeItemId) {
        LOGGER.info("moduleInstanceRelatedStoreItemCreated moduleId={}, instanceId={}, instanceType={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)instanceId, (Object)instanceType, (Object)storeId, (Object)storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceRelatedStoreItemCreated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType, "storeId", storeId, "storeItemId", storeItemId));
    }

    @Override
    public void moduleInstanceRelatedStoreItemUpdated(String moduleId, String instanceId, String instanceType, String storeId, String storeItemId) {
        LOGGER.info("moduleInstanceRelatedStoreItemUpdated moduleId={}, instanceId={}, instanceType={}, storeId={}, storeItemId={}", (Object)moduleId, (Object)instanceId, (Object)instanceType, (Object)storeId, (Object)storeItemId);
        this.broadcastConfigChangeMessage(BroadcastType.ModuleInstanceRelatedStoreItemUpdated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType, "storeId", storeId, "storeItemId", storeItemId));
    }

    public static enum BroadcastType {
        ModuleInstanceDeleted,
        ModuleInstanceUpdated,
        ModuleInstanceCreated,
        ModuleUpdated,
        ClientEvent,
        ModuleRelatedStoreItemDeleted,
        ModuleRelatedStoreItemCreated,
        ModuleRelatedStoreItemUpdated,
        ModuleInstanceRelatedStoreItemDeleted,
        ModuleInstanceRelatedStoreItemCreated,
        ModuleInstanceRelatedStoreItemUpdated;

    }
}

