/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.SettingValue;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.SettingsValuesAccessor;
import de.virtimo.bpc.core.SettingsImpl;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceCallback;
import de.virtimo.bpc.module.DefaultModuleConfigurations;
import de.virtimo.bpc.module.simple.CustomFieldsImpl;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.module.simple.SimpleSettingValueImpl;
import de.virtimo.bpc.module.simple.SimpleSettingsValuesAccessorImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleConfigurationImpl
implements ModuleConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(ModuleConfigurationImpl.class);
    private String moduleId;
    private String instanceId;
    private String instanceType;
    private final Map<String, Setting> settings;
    private final Map<String, Setting> defaultSettings;
    private ModuleConfigurationPersistenceCallback persistenceCallback;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ModuleConfigurationImpl(InstantiableModule instantiableModule, String instanceId, String instanceType, Map<String, Setting> settings, ModuleConfigurationPersistenceCallback persistenceCallback) throws SettingException {
        LOGGER.debug("ModuleConfigurationImpl instantiableModule={}, instanceId={}, instanceType={}, settings=..., persistenceCallback={}", (Object)instantiableModule, (Object)instanceId, (Object)instanceType, (Object)persistenceCallback);
        ModuleConfiguration defaultConfiguration = DefaultModuleConfigurations.getInstance().getForModuleInstance(instantiableModule, instanceType);
        this.moduleId = instantiableModule.getModuleId();
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.settings = settings;
        this.defaultSettings = this.clonedSettingsOfModuleConfiguration(defaultConfiguration);
        this.persistenceCallback = persistenceCallback;
        this.setOwner(this.settings, this.moduleId, instanceId, instanceType);
        this.setOwner(this.defaultSettings, this.moduleId, instanceId, instanceType);
        DefaultModuleConfigurations.getInstance().merge(this, defaultConfiguration);
    }

    public ModuleConfigurationImpl(Module module, Map<String, Setting> settings, ModuleConfigurationPersistenceCallback persistenceCallback) throws SettingException {
        ModuleConfiguration defaultConfiguration;
        LOGGER.debug("ModuleConfigurationImpl module={}, settings=..., persistenceCallback={}", (Object)module, (Object)persistenceCallback);
        if (module instanceof ModuleInstance) {
            ModuleInstance moduleInstance = (ModuleInstance)module;
            this.moduleId = moduleInstance.getParentModule().getModuleId();
            this.instanceId = moduleInstance.getModuleId();
            this.instanceType = moduleInstance.getInstanceType();
            defaultConfiguration = DefaultModuleConfigurations.getInstance().getForModuleInstance(moduleInstance.getParentModule(), moduleInstance.getInstanceType());
        } else {
            this.moduleId = module.getModuleId();
            this.instanceId = "noinstance";
            this.instanceType = "none";
            defaultConfiguration = DefaultModuleConfigurations.getInstance().getForModule(module);
        }
        this.settings = settings;
        this.defaultSettings = this.clonedSettingsOfModuleConfiguration(defaultConfiguration);
        this.persistenceCallback = persistenceCallback;
        this.setOwner(this.settings, this.moduleId, this.instanceId, this.instanceType);
        this.setOwner(this.defaultSettings, this.moduleId, this.instanceId, this.instanceType);
        DefaultModuleConfigurations.getInstance().merge(this, defaultConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        LOGGER.debug("destroy");
        try {
            for (PropertyChangeListener propertyChangeListener : this.propertyChangeSupport.getPropertyChangeListeners()) {
                this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to remove the property change listeners.", (Throwable)ex);
        }
        finally {
            this.propertyChangeSupport = null;
        }
        this.persistenceCallback = null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.removePropertyChangeListener(pcl);
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    @Override
    public Map<String, Setting> getSettings() {
        return this.settings;
    }

    public Map<String, Setting> getDefaultSettings() {
        return this.defaultSettings == null ? Collections.emptyMap() : this.defaultSettings;
    }

    private Map<String, Setting> clonedSettingsOfModuleConfiguration(ModuleConfiguration defaultConfiguration) {
        Map<String, Setting> settings;
        if (defaultConfiguration != null && (settings = defaultConfiguration.getSettings()) != null) {
            HashMap<String, Setting> clonedSettings = new HashMap<String, Setting>();
            for (String settingName : settings.keySet()) {
                Setting setting = settings.get(settingName);
                clonedSettings.put(settingName, new SimpleSettingImpl(setting));
            }
            return clonedSettings;
        }
        return null;
    }

    @Override
    public void setOwnerModule(Module configurationOwner) {
        String instanceType;
        String instanceId;
        String moduleId;
        if (configurationOwner instanceof ModuleInstance) {
            moduleId = ((ModuleInstance)configurationOwner).getParentModule().getModuleId();
            instanceId = configurationOwner.getModuleId();
            instanceType = ((ModuleInstance)configurationOwner).getInstanceType();
        } else {
            moduleId = configurationOwner.getModuleId();
            instanceId = "noinstance";
            instanceType = "none";
        }
        this.moduleId = moduleId;
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.setOwner(this.settings, moduleId, instanceId, instanceType);
        this.setOwner(this.defaultSettings, moduleId, instanceId, instanceType);
    }

    private void setOwner(Map<String, Setting> targetSettings, String moduleId, String instanceId, String instanceType) {
        if (targetSettings != null) {
            for (Setting setting : targetSettings.values()) {
                this.setOwner(setting, moduleId, instanceId, instanceType);
            }
        }
    }

    private void setOwner(Setting targetSetting, String moduleId, String instanceId, String instanceType) {
        if (targetSetting != null) {
            targetSetting.setModuleId(moduleId);
            targetSetting.setInstanceId(instanceId);
            targetSetting.setInstanceType(instanceType);
        }
    }

    @Override
    public Setting addSetting(Setting newSetting, boolean silent) throws SettingException {
        LOGGER.info("addSetting newSetting={}, silent={}", (Object)newSetting, (Object)silent);
        Setting oldSetting = this.settings.get(newSetting.getName());
        this.setOwner(newSetting, this.moduleId, this.instanceId, this.instanceType);
        if (oldSetting != null) {
            newSetting.getCustomFields().overwriteProtectedFieldsWith(oldSetting.getCustomFields());
        }
        if (this.persistenceCallback != null) {
            this.persistenceCallback.onSettingAddedOrUpdated(newSetting, this);
        }
        this.settings.put(newSetting.getName(), newSetting);
        if (!silent) {
            this.propertyChangeSupport.firePropertyChange(newSetting.getName(), oldSetting, newSetting);
        }
        return newSetting;
    }

    @Override
    public Setting addSetting(Setting newSetting) throws SettingException {
        return this.addSetting(newSetting, false);
    }

    @Override
    public void removeSetting(Setting settingToRemove, boolean silent) throws SettingException {
        Setting defaultSetting;
        LOGGER.info("removeSetting settingToRemove={}, silent={}", (Object)settingToRemove, (Object)silent);
        this.settings.remove(settingToRemove.getName());
        if (this.persistenceCallback != null) {
            this.persistenceCallback.onSettingRemoved(settingToRemove, this);
        }
        if (!silent) {
            this.propertyChangeSupport.firePropertyChange(settingToRemove.getName(), settingToRemove, null);
        }
        if (this.defaultSettings != null && (defaultSetting = this.defaultSettings.get(settingToRemove.getName())) != null) {
            SimpleSettingImpl clonedDefaultSetting = new SimpleSettingImpl(defaultSetting.getValue(), defaultSetting.getName(), defaultSetting.getType(), this.moduleId, this.instanceId, this.instanceType, new CustomFieldsImpl(defaultSetting.getCustomFields()));
            this.addSetting(clonedDefaultSetting, silent);
        }
    }

    @Override
    public void removeSetting(Setting settingToRemove) throws SettingException {
        this.removeSetting(settingToRemove, false);
    }

    @Override
    public Setting updateSetting(Setting newSetting, boolean silent) throws SettingException {
        LOGGER.info("updateSetting newSetting:{}, silent={}", (Object)newSetting, (Object)silent);
        return this.addSetting(newSetting, silent);
    }

    @Override
    public Setting updateSetting(Setting newSetting) throws SettingException {
        return this.updateSetting(newSetting, false);
    }

    @Override
    public SettingValue getSettingValue(String settingName) {
        return new SimpleSettingValueImpl(this.settings.get(settingName));
    }

    @Override
    public boolean hasSetting(String settingName) {
        return this.settings.containsKey(settingName);
    }

    @Override
    public Setting getSetting(String settingName) {
        return this.settings.get(settingName);
    }

    @Override
    public Settings getSettingsByName(Set<String> settingNames) {
        return new SettingsImpl(this.settings.values()).getSettingsByNames(settingNames);
    }

    @Override
    public SettingsValuesAccessor settingsValues() {
        return new SimpleSettingsValuesAccessorImpl(this);
    }

    public String toString() {
        return "ModuleConfigurationImpl{moduleId=" + this.moduleId + ", instanceId='" + this.instanceId + "', instanceType='" + this.instanceType + "', settings=...}";
    }
}

