/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.core.opensearch.PasswordEncryptorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.osgi.framework.BundleContext;

public class PasswordEncryptorServiceImpl
implements PasswordEncryptorService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(PasswordEncryptorServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private StandardPBEStringEncryptor encryptor;
    private static final Object ENCRYPTOR_LOCK = new Object();

    public PasswordEncryptorServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    private String getEncryptionKey() {
        LOGGER.debug("getEncryptionKey");
        try {
            return this.coreBundleConfigurationTracker.getService().getSystemPropertyValueAsString("de.virtimo.bpc.core.encryption.key", "virtimo_berlin");
        }
        catch (Throwable ex) {
            LOGGER.error("Could not get the core configuration to read the encryption key (de.virtimo.bpc.core.encryption.key).", ex);
            return "virtimo_berlin";
        }
    }

    private StandardPBEStringEncryptor getEncryptor() {
        LOGGER.debug("getEncryptor");
        if (this.encryptor == null) {
            StandardPBEStringEncryptor newEncryptor = new StandardPBEStringEncryptor();
            newEncryptor.setPassword(this.getEncryptionKey());
            newEncryptor.setAlgorithm("PBEWithHMACSHA512AndAES_256");
            newEncryptor.setIvGenerator((IvGenerator)new RandomIvGenerator());
            this.encryptor = newEncryptor;
        }
        return this.encryptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encrypt(String password) {
        LOGGER.debug("encrypt password=...");
        Object object = ENCRYPTOR_LOCK;
        synchronized (object) {
            return this.getEncryptor().encrypt(password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decrypt(String encryptedPassword) {
        LOGGER.debug("decrypt encryptedPassword=...");
        Object object = ENCRYPTOR_LOCK;
        synchronized (object) {
            String decryptedPassword;
            try {
                decryptedPassword = this.getEncryptor().decrypt(encryptedPassword);
            }
            catch (EncryptionOperationNotPossibleException ex) {
                decryptedPassword = encryptedPassword;
            }
            return decryptedPassword;
        }
    }
}

