/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class BpcConfigurationIndexMigrationFromModelVersion10To11
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion10To11.class);
    private static final boolean testRun = false;
    private final Map<String, String> convertedInstanceIDsCache = new HashMap<String, String>();

    public BpcConfigurationIndexMigrationFromModelVersion10To11(OpenSearchService oss) {
        super(oss, 11);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        String newDataSourceInstanceId;
        SearchHit oldDataSourceNameSettingSearchHit;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        if ("replication".equals(sourceValues.get("moduleId")) && "rdmsDataSourceName".equals(sourceValues.get("name"))) {
            try {
                String newDataSourceInstanceId2;
                SearchHit oldDataSourceNameSettingSearchHit2;
                String oldDataSourceNameOfReplicationJob = (String)sourceValues.get("value");
                if (!StringUtil.isNullOrEmpty(oldDataSourceNameOfReplicationJob) && (oldDataSourceNameSettingSearchHit2 = this.getOldDataSourceNameSetting(osClient, oldIndex, oldDataSourceNameOfReplicationJob)) != null && !oldDataSourceNameOfReplicationJob.equals(newDataSourceInstanceId2 = this.getNewUniqueInstanceIdGeneratedFromDataSourceName(osClient, oldIndex, oldDataSourceNameSettingSearchHit2.getSourceAsMap()))) {
                    HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                    updatedSourceValues.put("value", newDataSourceInstanceId2);
                    return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, (MediaType)XContentType.JSON));
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to update the replication job instance setting named 'rdmsDataSourceName'.", (Throwable)ex);
            }
        }
        if ("logservice".equals(sourceValues.get("moduleId")) && "rdms".equals(sourceValues.get("name"))) {
            try {
                String oldDataSourceNameOfLogService;
                Object rdmsDataSourceNameObject;
                Map rdms;
                Object rdmsObject = sourceValues.get("value");
                if (rdmsObject instanceof Map && (rdms = (Map)rdmsObject).containsKey("rdmsDataSourceName") && (rdmsDataSourceNameObject = rdms.get("rdmsDataSourceName")) instanceof String && !StringUtil.isNullOrEmpty(oldDataSourceNameOfLogService = (String)rdmsDataSourceNameObject) && (oldDataSourceNameSettingSearchHit = this.getOldDataSourceNameSetting(osClient, oldIndex, oldDataSourceNameOfLogService)) != null && !oldDataSourceNameOfLogService.equals(newDataSourceInstanceId = this.getNewUniqueInstanceIdGeneratedFromDataSourceName(osClient, oldIndex, oldDataSourceNameSettingSearchHit.getSourceAsMap()))) {
                    HashMap<String, String> updatedRdms = new HashMap<String, String>(rdms);
                    updatedRdms.put("rdmsDataSourceName", newDataSourceInstanceId);
                    HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                    updatedSourceValues.put("value", updatedRdms);
                    return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, (MediaType)XContentType.JSON));
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to update the log service instance setting named 'rdms'.", (Throwable)ex);
            }
        }
        if ("backendconnection".equals(sourceValues.get("moduleId")) && "identity_provider".equals(sourceValues.get("instanceType")) && "identityProvider_configuration".equals(sourceValues.get("name"))) {
            try {
                String oldDataSourceName;
                Object dataSourceNameObject;
                Map idpConfig;
                Object idpConfigObject = sourceValues.get("value");
                if (idpConfigObject instanceof Map && (idpConfig = (Map)idpConfigObject).containsKey("datasource") && (dataSourceNameObject = idpConfig.get("datasource")) instanceof String && !StringUtil.isNullOrEmpty(oldDataSourceName = (String)dataSourceNameObject) && (oldDataSourceNameSettingSearchHit = this.getOldDataSourceNameSetting(osClient, oldIndex, oldDataSourceName)) != null && !oldDataSourceName.equals(newDataSourceInstanceId = this.getNewUniqueInstanceIdGeneratedFromDataSourceName(osClient, oldIndex, oldDataSourceNameSettingSearchHit.getSourceAsMap()))) {
                    HashMap<String, String> updatedIdpConfig = new HashMap<String, String>(idpConfig);
                    updatedIdpConfig.put("datasource", newDataSourceInstanceId);
                    HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                    updatedSourceValues.put("value", updatedIdpConfig);
                    return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, (MediaType)XContentType.JSON));
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to update the JAAS JDBC identity provider setting named 'identityProvider_configuration'.", (Throwable)ex);
            }
        }
        if ("backendconnection".equals(sourceValues.get("moduleId")) && "data_source".equals(sourceValues.get("instanceType"))) {
            String settingName = (String)sourceValues.get("name");
            if ("dataSourceName".equals(settingName)) {
                return null;
            }
            try {
                Map dataSourceConfiguration;
                Object dataSourceConfigurationObject;
                String newUniqueInstanceIdGeneratedFromDataSourceName = this.getNewUniqueInstanceIdGeneratedFromDataSourceName(osClient, oldIndex, sourceValues);
                String newId = this.createSettingId("backendconnection", newUniqueInstanceIdGeneratedFromDataSourceName, settingName);
                HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                updatedSourceValues.put("id", newId);
                updatedSourceValues.put("instanceId", newUniqueInstanceIdGeneratedFromDataSourceName);
                if ("configuration".equals(settingName) && (dataSourceConfigurationObject = updatedSourceValues.get("value")) instanceof Map && (dataSourceConfiguration = (Map)dataSourceConfigurationObject).containsKey("dataSourceName")) {
                    dataSourceConfiguration.remove("dataSourceName");
                    updatedSourceValues.put("value", dataSourceConfiguration);
                }
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newId).source(updatedSourceValues, (MediaType)XContentType.JSON));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to convert a data_source related backend connection setting.", (Throwable)ex);
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private SearchHit getOldDataSourceNameSetting(RestHighLevelClient osClient, IndexToMigrate oldIndex, String dataSourceName) throws IOException {
        if (!StringUtil.isNullOrEmpty(dataSourceName)) {
            SearchRequest request = new SearchRequest().indices(oldIndex.getName()).source(new SearchSourceBuilder().size(10).query(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", "backendconnection")).must(QueryBuilders.termQuery("instanceType", "data_source")).must(QueryBuilders.termQuery("name", "dataSourceName")))).scroll(new TimeValue(60000L));
            SearchResponse response = osClient.search(request, RequestOptions.DEFAULT);
            if (response.getHits().getTotalHits().value > 0L) {
                do {
                    SearchHit[] hits;
                    for (SearchHit hit : hits = response.getHits().getHits()) {
                        Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                        String dataSourceNameFromHit = (String)sourceAsMap.get("value");
                        if (!dataSourceName.equals(dataSourceNameFromHit)) continue;
                        return hit;
                    }
                } while ((response = osClient.scroll(new SearchScrollRequest(response.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            }
        }
        return null;
    }

    private String getNewUniqueInstanceIdGeneratedFromDataSourceName(RestHighLevelClient osClient, IndexToMigrate oldIndex, Map<String, Object> sourceValues) throws OpenSearchRelatedException {
        String instanceId = (String)sourceValues.get("instanceId");
        if (this.convertedInstanceIDsCache.containsKey(instanceId)) {
            return this.convertedInstanceIDsCache.get(instanceId);
        }
        String dataSourceName = "dataSourceName".equals(sourceValues.get("name")) ? (String)sourceValues.get("value") : this.queryDataSourceNameFromOldIndexForInstanceId(osClient, oldIndex, instanceId);
        String dataSourceNameConvertedToInstanceId = BpcConfigurationIndexMigrationFromModelVersion10To11.convertToValidModuleInstanceId(dataSourceName);
        String uniqueInstanceId = this.getUniqueModuleInstanceId(dataSourceNameConvertedToInstanceId, 0);
        this.convertedInstanceIDsCache.put(instanceId, uniqueInstanceId);
        return uniqueInstanceId;
    }

    private String queryDataSourceNameFromOldIndexForInstanceId(RestHighLevelClient osClient, IndexToMigrate oldIndex, String instanceId) throws OpenSearchRelatedException {
        String oldDataSourceNameSettingId = this.createSettingId("backendconnection", instanceId, "dataSourceName");
        try {
            SearchRequest request = new SearchRequest().indices(oldIndex.getName()).source(new SearchSourceBuilder().query(QueryBuilders.termQuery("id", oldDataSourceNameSettingId)));
            SearchResponse response = osClient.search(request, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            return hits == null || hits.length == 0 ? null : (String)hits[0].getSourceAsMap().get("value");
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private String getUniqueModuleInstanceId(String dataSourceNameConvertedToInstanceId, int counter) {
        String uniqueInstanceId;
        String string = uniqueInstanceId = counter == 0 ? dataSourceNameConvertedToInstanceId : dataSourceNameConvertedToInstanceId + "-" + counter;
        if (this.convertedInstanceIDsCache.containsValue(uniqueInstanceId)) {
            return this.getUniqueModuleInstanceId(dataSourceNameConvertedToInstanceId, ++counter);
        }
        return uniqueInstanceId;
    }

    public static String convertToValidModuleInstanceId(String dataSourceName) {
        if (StringUtil.isNullOrEmpty(dataSourceName)) {
            return dataSourceName;
        }
        String result = dataSourceName;
        result = result.trim().toLowerCase();
        result = result.replaceAll("\\s+", "-");
        result = result.replaceAll("[^a-z0-9_\\-]", "_");
        result = result.replaceAll("(_)\\1+", "$1");
        result = result.replaceAll("(-)\\1+", "$1");
        result = result.replaceAll("[_\\-]+$", "");
        result = result.replaceAll("-_", "_");
        result = result.replaceAll("_-", "_");
        return result;
    }

    private String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }
}

