/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion13To14
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion13To14.class);
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion13To14(OpenSearchService oss) {
        super(oss, 14);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        String oldCronPattern;
        List<String> oldCronPatternTokens;
        Object oldValueObject;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        if ("replication".equals(sourceValues.get("moduleId")) && ("replicationTailSyncCronPattern".equals(sourceValues.get("name")) || "replicationShadowCopyCronPattern".equals(sourceValues.get("name"))) && (oldValueObject = sourceValues.get("value")) instanceof String && (oldCronPatternTokens = this.getCronPatternTokens(oldCronPattern = ((String)oldValueObject).trim())).size() == 5) {
            HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
            updatedSourceValues.put("value", this.convertCronPattern(oldCronPattern));
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, (MediaType)XContentType.JSON));
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    public String convertCronPattern(String cron4jPattern) {
        String cronPatternWithAddedSecondsToken = "0 " + cron4jPattern;
        List<String> cronPatternTokens = this.getCronPatternTokens(cronPatternWithAddedSecondsToken);
        if ("*".equals(cronPatternTokens.get(3)) && "*".equals(cronPatternTokens.get(5))) {
            cronPatternTokens.set(5, "?");
        } else if ("*".equals(cronPatternTokens.get(3))) {
            cronPatternTokens.set(3, "?");
        } else {
            cronPatternTokens.set(5, "?");
        }
        return this.getCronPattern(cronPatternTokens);
    }

    public List<String> getCronPatternTokens(String cronPattern) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(cronPattern, " \t", false);
        while (tokenizer.hasMoreElements()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    public String getCronPattern(List<String> cronPatternTokens) {
        StringBuilder result = new StringBuilder();
        for (String cronPatternToken : cronPatternTokens) {
            result.append(cronPatternToken).append(" ");
        }
        return result.toString().trim();
    }
}

