/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;

public class BpcConfigurationIndexMigrationFromModelVersion15To16
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion15To16.class);
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion15To16(OpenSearchService oss) {
        super(oss, 16);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        if ("plugin_configuration".equals(settingName) && "_core".equals(moduleId)) {
            ArrayList pluginConfiguration = (ArrayList)sourceValues.get("value");
            try {
                Map<String, Object> moduleNavigatorSetting = this.getCoreSetting(osClient, oldIndex.getName(), "moduleNavigator");
                if (moduleNavigatorSetting != null) {
                    Boolean isModuleNavigatorActive = (Boolean)moduleNavigatorSetting.get("value");
                    if (isModuleNavigatorActive.equals(true)) {
                        pluginConfiguration.add((HashMap)this.getPluginConfig("bpcModuleNavigator"));
                    }
                    sourceValues.put("value", pluginConfiguration);
                }
            }
            catch (IOException e) {
                LOGGER.info("Failed to find setting 'moduleNavigator'.", (Throwable)e);
            }
            try {
                Map<String, Object> breadcrumbSetting = this.getCoreSetting(osClient, oldIndex.getName(), "gui_breadcrumb");
                if (breadcrumbSetting != null) {
                    Boolean isBreadcrumbActive = (Boolean)breadcrumbSetting.get("value");
                    if (isBreadcrumbActive.equals(true)) {
                        pluginConfiguration.add((HashMap)this.getPluginConfig("bpcBreadcrumb"));
                    }
                    sourceValues.put("value", pluginConfiguration);
                }
            }
            catch (IOException e) {
                LOGGER.info("Failed to find setting 'gui_breadcrumb'.", (Throwable)e);
            }
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
        }
        if ("_core".equals(moduleId) && ("gui_breadcrumb".equals(settingName) || "moduleNavigator".equals(settingName))) {
            return null;
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private Map<String, Object> getCoreSetting(RestHighLevelClient osClient, String index, String settingName) throws IOException {
        SearchRequest request = new SearchRequest().indices(index).source(new SearchSourceBuilder().query(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", "_core")).must(QueryBuilders.termQuery("name", settingName))));
        SearchResponse response = osClient.search(request, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        if (hits.getHits().length > 0) {
            return hits.getAt(0).getSourceAsMap();
        }
        return null;
    }

    private Map<String, Object> getPluginConfig(String pluginName) {
        HashMap<String, Object> breadcrumbPluginConfig = new HashMap<String, Object>();
        breadcrumbPluginConfig.put("hook", "core_global_application_toolbar_left");
        breadcrumbPluginConfig.put("plugin", pluginName);
        breadcrumbPluginConfig.put("sourceModule", "_core");
        return breadcrumbPluginConfig;
    }
}

