/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion17To18
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion17To18.class);

    public BpcConfigurationIndexMigrationFromModelVersion17To18(OpenSearchService oss) {
        super(oss, 18);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        RenamedSetting renamedSetting = this.renameLogServiceInstanceSetting(sourceValues);
        if (renamedSetting != null) {
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(renamedSetting.getNewId()).source(renamedSetting.getUpdatedSourceValues(), (MediaType)XContentType.JSON));
        }
        Map<String, Object> migratedSourceValues = this.migrateLogServiceInstanceFieldsConfig(sourceValues);
        if (migratedSourceValues != null) {
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(migratedSourceValues, (MediaType)XContentType.JSON));
        }
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        if ("analysis".equals(moduleId) && "dataSets_configs".equals(settingName)) {
            ArrayList datasetConfigs = (ArrayList)sourceValues.get("value");
            for (HashMap datasetConfig : datasetConfigs) {
                String sourceType = (String)datasetConfig.get("sourceType");
                if (!"Elasticsearch".equals(sourceType)) continue;
                datasetConfig.put("sourceType", "OpenSearch");
            }
            LOGGER.info("Migrate setting dataSets_configs done");
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    RenamedSetting renameLogServiceInstanceSetting(Map<String, Object> sourceValues) {
        String oldSettingName;
        if (sourceValues == null) {
            return null;
        }
        if (!"logservice".equals(sourceValues.get("moduleId"))) {
            return null;
        }
        if ("noinstance".equals(sourceValues.get("instanceId"))) {
            return null;
        }
        Map<String, String> settingsToRename = Map.of("esLoggingEnabled", "openSearchLoggingEnabled", "es", "openSearch");
        if (!settingsToRename.containsKey(oldSettingName = (String)sourceValues.get("name"))) {
            return null;
        }
        String newSettingName = settingsToRename.get(oldSettingName);
        return new RenamedSetting(newSettingName, sourceValues);
    }

    String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }

    Map<String, Object> migrateLogServiceInstanceFieldsConfig(Map<String, Object> sourceValues) {
        if (sourceValues == null) {
            return null;
        }
        if (!"logservice".equals(sourceValues.get("moduleId"))) {
            return null;
        }
        if ("noinstance".equals(sourceValues.get("instanceId"))) {
            return null;
        }
        if (!"fields".equals(sourceValues.get("name"))) {
            return null;
        }
        Object fieldsConfig = sourceValues.get("value");
        if (fieldsConfig instanceof Map) {
            HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
            updatedSourceValues.put("value", this.renameKey((Map)fieldsConfig, "skipES", "skipOS"));
            return updatedSourceValues;
        }
        return null;
    }

    private Map renameKey(Map map, String oldKeyName, String newKeyName) {
        try {
            String jsonKeyOld = "\"" + oldKeyName + "\":";
            String jsonKeyNew = "\"" + newKeyName + "\":";
            String mapAsJsonString = JsonUtil.getInstance().convertPojoToJsonString(map);
            String updatedMapAsJsonString = mapAsJsonString.replaceAll(jsonKeyOld, jsonKeyNew);
            return JsonUtil.getInstance().jsonStringAsMap(updatedMapAsJsonString);
        }
        catch (Exception e) {
            return map;
        }
    }

    class RenamedSetting {
        private final Map<String, Object> updatedSourceValues;

        public RenamedSetting(String newSettingName, Map<String, Object> sourceValues) {
            this.updatedSourceValues = new HashMap<String, Object>(sourceValues);
            this.updatedSourceValues.put("id", BpcConfigurationIndexMigrationFromModelVersion17To18.this.createSettingId((String)sourceValues.get("moduleId"), (String)sourceValues.get("instanceId"), newSettingName));
            this.updatedSourceValues.put("name", newSettingName);
        }

        public String getNewId() {
            return (String)this.updatedSourceValues.get("id");
        }

        public Map<String, Object> getUpdatedSourceValues() {
            return this.updatedSourceValues;
        }
    }
}

