/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class BpcConfigurationIndexMigrationFromModelVersion24To25
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion24To25.class);
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion24To25(OpenSearchService oss) {
        super(oss, 25);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        String instanceId = (String)sourceValues.get("instanceId");
        String instanceType = (String)sourceValues.get("instanceType");
        if ("backendconnection".equals(moduleId) && "identity_provider".equals(instanceType)) {
            Object idpConfigObject;
            if ("identityProvider_configuration".equals(settingName) && (idpConfigObject = sourceValues.get("value")) instanceof Map) {
                Map idpConfig = (Map)idpConfigObject;
                String idp = BpcConfigurationIndexMigrationFromModelVersion24To25.queryBackendConnectionSettingValueFromIndex(osClient, oldIndex.getName(), instanceId, "identityProvider");
                if (idp != null) {
                    List<IndexRequest> indexRequests = switch (idp.toLowerCase()) {
                        case "jdbc" -> this.createIndexRequestsForJDBC(newIndex.getName(), instanceId, idpConfig);
                        case "inubit" -> this.createIndexRequestsForInubit(osClient, oldIndex.getName(), newIndex.getName(), instanceId);
                        case "oidc", "keycloak" -> this.createIndexRequestsForOIDC(osClient, oldIndex.getName(), newIndex.getName(), instanceId, idpConfig);
                        default -> null;
                    };
                    return indexRequests;
                }
                LOGGER.warn("No identity provider found for instanceId {}. Skipping migration.", (Object)instanceId);
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
            }
            if ("identityProvider.url".equals(settingName)) {
                return null;
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private List<IndexRequest> createIndexRequestsForJDBC(String indexName, String instanceId, Map idpConfig) {
        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>();
        Map<String, Object> settingValues = BpcConfigurationIndexMigrationFromModelVersion24To25.createIdpSettingMap(instanceId, "identityProvider_jdbc_dataSource", "text", MapUtil.getValueAsString(idpConfig, "datasource", ""));
        indexRequests.add(new IndexRequest(indexName).id((String)settingValues.get("id")).source(settingValues, (MediaType)XContentType.JSON));
        return indexRequests;
    }

    private List<IndexRequest> createIndexRequestsForInubit(RestHighLevelClient osClient, String oldIndexName, String newIndexName, String instanceId) {
        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>();
        String oldIdentityProviderUrlValue = BpcConfigurationIndexMigrationFromModelVersion24To25.queryBackendConnectionSettingValueFromIndex(osClient, oldIndexName, instanceId, "identityProvider.url");
        Map<String, Object> settingValues = BpcConfigurationIndexMigrationFromModelVersion24To25.createIdpSettingMap(instanceId, "identityProvider_inubit_url", "text", oldIdentityProviderUrlValue);
        indexRequests.add(new IndexRequest(newIndexName).id((String)settingValues.get("id")).source(settingValues, (MediaType)XContentType.JSON));
        return indexRequests;
    }

    private List<IndexRequest> createIndexRequestsForOIDC(RestHighLevelClient osClient, String oldIndexName, String newIndexName, String instanceId, Map idpConfig) {
        ArrayList<Map<String, Object>> settingsMaps = new ArrayList<Map<String, Object>>();
        SettingMapCreator settingMapCreator = new SettingMapCreator(osClient, oldIndexName, instanceId, idpConfig);
        settingsMaps.add(settingMapCreator.forSimpleOneToOneStringTakeover("identityProvider_oidc_clientId", "text", "client_id"));
        settingsMaps.add(settingMapCreator.forSimpleOneToOneStringTakeover("identityProvider_oidc_clientSecret", "password", "client_secret"));
        settingsMaps.add(settingMapCreator.forSimpleOneToOneStringTakeover("identityProvider_oidc_scope", "text", "scope"));
        settingsMaps.add(settingMapCreator.forSimpleOneToOneStringTakeover("identityProvider_oidc_claimNameRoles", "text", "claim_name_roles"));
        settingsMaps.add(settingMapCreator.forSimpleOneToOneStringTakeover("identityProvider_oidc_claimNameOrganisations", "text", "claim_name_organisations"));
        settingsMaps.add(settingMapCreator.forSimpleOneToOneStringTakeover("identityProvider_oidc_claimNameRights", "text", "claim_name_rights"));
        settingsMaps.add(settingMapCreator.forMetadataDiscoveryUri("identityProvider_oidc_metadataDiscoveryUri", "json"));
        settingsMaps.add(settingMapCreator.forPostAuthenticationRedirectUri("identityProvider_oidc_postAuthenticationRedirectUri", "json"));
        settingsMaps.add(settingMapCreator.forPostLogoutRedirectUri("identityProvider_oidc_postLogoutRedirectUri", "json"));
        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>();
        settingsMaps.forEach(settingsMap -> indexRequests.add(new IndexRequest(newIndexName).id((String)settingsMap.get("id")).source((Map<String, ?>)settingsMap, (MediaType)XContentType.JSON)));
        return indexRequests;
    }

    private static Map<String, Object> createIdpSettingMap(String instanceId, String settingName, String valueType, Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", BpcConfigurationIndexMigrationFromModelVersion24To25.createSettingId("backendconnection", instanceId, settingName));
        result.put("moduleId", "backendconnection");
        result.put("instanceId", instanceId);
        result.put("instanceType", "identity_provider");
        result.put("name", settingName);
        result.put("type", valueType);
        result.put("value", value);
        return result;
    }

    private static String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }

    private static String queryBackendConnectionSettingValueFromIndex(RestHighLevelClient osClient, String indexName, String instanceId, String settingName) {
        try {
            String identityProviderSettingId = BpcConfigurationIndexMigrationFromModelVersion24To25.createSettingId("backendconnection", instanceId, settingName);
            SearchRequest request = new SearchRequest().indices(indexName).source(new SearchSourceBuilder().query(QueryBuilders.termQuery("id", identityProviderSettingId)));
            SearchResponse response = osClient.search(request, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            return hits == null || hits.length == 0 ? null : (String)hits[0].getSourceAsMap().get("value");
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static class SettingMapCreator {
        private final RestHighLevelClient osClient;
        private final String oldIndexName;
        private final String instanceId;
        private final Map idpConfig;

        SettingMapCreator(RestHighLevelClient osClient, String oldIndexName, String instanceId, Map idpConfig) {
            this.osClient = osClient;
            this.oldIndexName = oldIndexName;
            this.instanceId = instanceId;
            this.idpConfig = idpConfig;
        }

        Map<String, Object> forSimpleOneToOneStringTakeover(String settingName, String settingType, String idpConfigKey) {
            return BpcConfigurationIndexMigrationFromModelVersion24To25.createIdpSettingMap(this.instanceId, settingName, settingType, MapUtil.getValueAsString(this.idpConfig, idpConfigKey, ""));
        }

        Map<String, Object> forMetadataDiscoveryUri(String settingName, String settingType) {
            String oldIdentityProviderUrlValue;
            ArrayList<Map<String, Object>> metadataDiscoveryUriList = new ArrayList<Map<String, Object>>();
            if (this.idpConfig.containsKey("metadata_discovery_uri")) {
                Object metadataDiscoveryUriObject = this.idpConfig.get("metadata_discovery_uri");
                if (metadataDiscoveryUriObject instanceof List) {
                    metadataDiscoveryUriList.addAll((List)metadataDiscoveryUriObject);
                } else {
                    LOGGER.warn("Old metadata_discovery_uri '{}' is not a list. This means it is misconfigured and gets ignored.", metadataDiscoveryUriObject);
                }
            }
            if (metadataDiscoveryUriList.isEmpty() && !StringUtil.isNullOrEmpty(oldIdentityProviderUrlValue = BpcConfigurationIndexMigrationFromModelVersion24To25.queryBackendConnectionSettingValueFromIndex(this.osClient, this.oldIndexName, this.instanceId, "identityProvider.url"))) {
                metadataDiscoveryUriList.add(MapUtil.mapOf("pattern", ".*", "uri", oldIdentityProviderUrlValue));
            }
            return BpcConfigurationIndexMigrationFromModelVersion24To25.createIdpSettingMap(this.instanceId, settingName, settingType, metadataDiscoveryUriList);
        }

        Map<String, Object> forPostAuthenticationRedirectUri(String settingName, String settingType) {
            ArrayList<Map<String, Object>> postAuthenticationRedirectUriList = new ArrayList<Map<String, Object>>();
            if (this.idpConfig.containsKey("post_authentication_redirect_uri")) {
                Object postAuthenticationRedirectUriObject = this.idpConfig.get("post_authentication_redirect_uri");
                if (postAuthenticationRedirectUriObject instanceof List) {
                    postAuthenticationRedirectUriList.addAll((List)postAuthenticationRedirectUriObject);
                } else if (postAuthenticationRedirectUriObject instanceof String) {
                    postAuthenticationRedirectUriList.add(MapUtil.mapOf("pattern", ".*", "uri", postAuthenticationRedirectUriObject));
                } else {
                    LOGGER.warn("Old post_authentication_redirect_uri '{}' is not a list nor string. This means it is misconfigured and gets ignored.", postAuthenticationRedirectUriObject);
                }
            }
            return BpcConfigurationIndexMigrationFromModelVersion24To25.createIdpSettingMap(this.instanceId, settingName, settingType, postAuthenticationRedirectUriList);
        }

        Map<String, Object> forPostLogoutRedirectUri(String settingName, String settingType) {
            ArrayList<Map<String, Object>> postLogoutRedirectUriList = new ArrayList<Map<String, Object>>();
            if (this.idpConfig.containsKey("post_logout_redirect_uri")) {
                Object postLogoutRedirectUriObject = this.idpConfig.get("post_logout_redirect_uri");
                if (postLogoutRedirectUriObject instanceof List) {
                    postLogoutRedirectUriList.addAll((List)postLogoutRedirectUriObject);
                } else if (postLogoutRedirectUriObject instanceof String) {
                    postLogoutRedirectUriList.add(MapUtil.mapOf("pattern", ".*", "uri", postLogoutRedirectUriObject));
                } else {
                    LOGGER.warn("Old post_logout_redirect_uri '{}' is not a list nor string. This means it is misconfigured and gets ignored.", postLogoutRedirectUriObject);
                }
            }
            return BpcConfigurationIndexMigrationFromModelVersion24To25.createIdpSettingMap(this.instanceId, "identityProvider_oidc_postLogoutRedirectUri", "json", postLogoutRedirectUriList);
        }
    }
}

