/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion9To10
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion9To10.class);

    public BpcConfigurationIndexMigrationFromModelVersion9To10(OpenSearchService oss) {
        super(oss, 10);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Object currentValue;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        if ("httpproxy".equals(sourceValues.get("moduleId"))) {
            String newId = this.createSettingId("backendconnection", (String)sourceValues.get("instanceId"), (String)sourceValues.get("name"));
            HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
            updatedSourceValues.put("id", newId);
            updatedSourceValues.put("moduleId", "backendconnection");
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newId).source(updatedSourceValues, (MediaType)XContentType.JSON));
        }
        if ("monitor".equals(sourceValues.get("moduleId")) && "function_changeStateConfig".equals(sourceValues.get("name")) && (currentValue = sourceValues.get("value")) instanceof Map) {
            try {
                HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                updatedSourceValues.put("value", this.convertChangeStateConfig((Map)currentValue));
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, (MediaType)XContentType.JSON));
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to convert the monitor instance setting 'function_changeStateConfig': " + currentValue, (Throwable)ex);
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }

    List<Map<String, Object>> convertChangeStateConfig(Map oldChangeStateConfig) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (oldChangeStateConfig != null && !oldChangeStateConfig.isEmpty()) {
            for (Object dataIndexNameObject : oldChangeStateConfig.keySet()) {
                String dataIndexName = (String)dataIndexNameObject;
                Map oldConfig = (Map)oldChangeStateConfig.get(dataIndexName);
                HashMap<String, String> newConfig = new HashMap<String, String>(oldConfig);
                newConfig.put("dataIndex", dataIndexName);
                result.add(newConfig);
            }
        }
        return result;
    }
}

