/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.performance.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.performance.PerformanceMeasurementManager;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="/performance")
@Tag(name="Performance Measurement API", description="The BPC performs performance monitoring to record runtimes in the BPC frontend.\nMeasurements can be transmitted using this endpoint.\n")
public class PerformanceMeasurementEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(PerformanceMeasurementEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<PerformanceMeasurementManager> performanceMeasurementManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public PerformanceMeasurementEndpoint(BundleContext bundleContext) {
        LOGGER.info("PerformanceMeasurementEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.performanceMeasurementManagerTracker = new BpcServicesTracker<PerformanceMeasurementManager>(this.bundleContext, PerformanceMeasurementManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @POST
    @Path(value="/{sessionId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No content")})
    @OperationDescription(summary="Saves measurements to OpenSearch.", description="Saves the measurements provided in the body to the OpenSearch index `bpc-performance`.")
    public Response savePerformanceData(@Parameter(description="the id of the session") @PathParam(value="sessionId") String sessionId, @HeaderParam(value="user-agent") String userAgent, List<Map<String, Object>> measurements) {
        LOGGER.debug("savePerformanceData");
        try {
            this.performanceMeasurementManagerTracker.getService().savePerformanceData(sessionId, userAgent, measurements);
            return Response.noContent().build();
        }
        catch (MaintenanceModeEnabledException ex) {
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to save measurement", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

