/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRuntimeStatsDTO;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class ReplicationMetricsCollector
extends Collector {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationMetricsCollector.class);
    private static final int METRICS_CACHE_TIME_IN_SECONDS = 10;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private ReplicationMetrics replicationMetrics;
    private long replicationMetricsCreatedTimestamp;

    public ReplicationMetricsCollector(BundleContext bundleContext) {
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.replicationMetrics = null;
        this.replicationMetricsCreatedTimestamp = -1L;
    }

    public void unregister() {
        LOGGER.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            ReplicationModule replicationModule = this.moduleManagerTracker.getService().getModuleByClass(ReplicationModule.class);
            if (this.replicationMetrics == null || this.replicationMetricsCreatedTimestamp == -1L || System.currentTimeMillis() - this.replicationMetricsCreatedTimestamp > 10000L) {
                List<ReplicationJobRuntimeStatsDTO> replicationJobsWithRuntimeStatsFromAllServers = replicationModule.getReplicationJobsWithRuntimeStatsFromAllServers();
                ReplicationMetrics replicationMetrics = new ReplicationMetrics();
                for (ReplicationJobRuntimeStatsDTO replicationJobRuntimeStats : replicationJobsWithRuntimeStatsFromAllServers) {
                    replicationMetrics.update(replicationJobRuntimeStats);
                }
                this.replicationMetrics = replicationMetrics;
                this.replicationMetricsCreatedTimestamp = System.currentTimeMillis();
            }
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_number_of_jobs", "Number of replication jobs", (double)this.replicationMetrics.getNumberOfReplicationJobs()));
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_number_of_enabled_jobs", "Number of enabled replication jobs", (double)this.replicationMetrics.getNumberOfEnabledReplicationJobs()));
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_number_of_disabled_jobs", "Number of disabled replication jobs", (double)this.replicationMetrics.getNumberOfDisabledReplicationJobs()));
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_number_of_jobs_with_errors", "Number of replication jobs with errors", (double)this.replicationMetrics.getNumberOfReplicationJobsWithErrors()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }

    private static class ReplicationMetrics {
        private long numberOfReplicationJobs = 0L;
        private long numberOfEnabledReplicationJobs = 0L;
        private long numberOfDisabledReplicationJobs = 0L;
        private long numberOfReplicationJobsWithErrors = 0L;

        ReplicationMetrics() {
        }

        void update(ReplicationJobRuntimeStatsDTO replicationJobRuntimeStats) {
            if (replicationJobRuntimeStats != null && replicationJobRuntimeStats.getReplication() != null) {
                ++this.numberOfReplicationJobs;
                if (replicationJobRuntimeStats.getReplication().isEnabled()) {
                    ++this.numberOfEnabledReplicationJobs;
                } else {
                    ++this.numberOfDisabledReplicationJobs;
                }
                if (replicationJobRuntimeStats.getReplication().getCurrentErrorMessage() != null) {
                    ++this.numberOfReplicationJobsWithErrors;
                }
            }
        }

        public long getNumberOfReplicationJobs() {
            return this.numberOfReplicationJobs;
        }

        public long getNumberOfEnabledReplicationJobs() {
            return this.numberOfEnabledReplicationJobs;
        }

        public long getNumberOfDisabledReplicationJobs() {
            return this.numberOfDisabledReplicationJobs;
        }

        public long getNumberOfReplicationJobsWithErrors() {
            return this.numberOfReplicationJobsWithErrors;
        }
    }
}

