/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.module.AbstractModuleInstance;
import java.beans.PropertyChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ReplicationModuleInstance
extends AbstractModuleInstance {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationModuleInstance.class);
    public static final String SETTING_LOOKUP_JOINS = "join";
    private LookupJoins lookupJoins = null;

    public ReplicationModuleInstance(InstantiableModule pm, ModuleConfiguration mc, String instanceId) {
        super(pm, mc, instanceId);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource() instanceof ModuleConfiguration && SETTING_LOOKUP_JOINS.equalsIgnoreCase(evt.getPropertyName())) {
            LOGGER.info(this.getModuleId() + ": 'join' setting changed: resetting the lookup joins");
            this.lookupJoins = null;
        }
    }

    public LookupJoins getLookupJoins() {
        LOGGER.debug("getLookupJoins");
        if (this.lookupJoins == null) {
            this.lookupJoins = new LookupJoins(this.getConfiguration().getSetting(SETTING_LOOKUP_JOINS));
        }
        return this.lookupJoins;
    }

    @NotNull
    public ReplicationJob getReplicationJob() {
        LOGGER.debug("getReplicationJob");
        return new ReplicationJob(this.getModuleId(), this.getConfiguration());
    }
}

