/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.DbColumnNamesToOpenSearchFieldNamesConverter;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.core.CountRequest;
import org.opensearch.client.core.CountResponse;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

class ConsistencyCheckOpenSearchHandler {
    private static final Logger LOGGER = LogManager.getLogger(ConsistencyCheckOpenSearchHandler.class);
    private final OpenSearchService oss;
    private final String index;
    private final String lastUpdateTimestampColumn;
    private final String lastUpdateTimestampFieldInOpenSearch;
    private final String loggingPrefix;
    private final int maxNumberOfDocumentsToEvaluateTheUpperTargetDateFrom;

    ConsistencyCheckOpenSearchHandler(OpenSearchService oss, String index, String lastUpdateTimestampColumn, DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter, String loggingPrefix) {
        this.oss = oss;
        this.index = index;
        this.lastUpdateTimestampColumn = lastUpdateTimestampColumn;
        this.lastUpdateTimestampFieldInOpenSearch = dbColumnNamesToOpenSearchFieldNamesConverter.convert(lastUpdateTimestampColumn);
        this.loggingPrefix = loggingPrefix;
        this.maxNumberOfDocumentsToEvaluateTheUpperTargetDateFrom = 25;
    }

    Instant getUpperTargetDate() throws OpenSearchRelatedException {
        LOGGER.info("{}: getUpperTargetDate", (Object)this.loggingPrefix);
        long start = System.currentTimeMillis();
        try {
            SearchRequest searchReq = new SearchRequest().indices(this.index).source(new SearchSourceBuilder().size(this.maxNumberOfDocumentsToEvaluateTheUpperTargetDateFrom).query(QueryBuilders.matchAllQuery()).sort(this.lastUpdateTimestampFieldInOpenSearch, SortOrder.DESC));
            SearchResponse maxLastupdateDateResponse = this.oss.getClient().search(searchReq, RequestOptions.DEFAULT);
            if (maxLastupdateDateResponse.getHits().getTotalHits().value == 0L) {
                LOGGER.info("{}: No documents found to get the upper target date", (Object)this.loggingPrefix);
                Instant instant = null;
                return instant;
            }
            Instant maxDate = null;
            for (SearchHit hit : maxLastupdateDateResponse.getHits().getHits()) {
                String lastUpdateTimestampString;
                Instant lastUpdateTimestampInstant;
                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                Object lastUpdateTimestamp = sourceAsMap.get(this.lastUpdateTimestampFieldInOpenSearch);
                if (!(lastUpdateTimestamp instanceof String) || (lastUpdateTimestampInstant = TimestampUtil.parseAsInstant((String)(lastUpdateTimestampString = (String)lastUpdateTimestamp))) == null || maxDate != null && !maxDate.isBefore(lastUpdateTimestampInstant)) continue;
                maxDate = lastUpdateTimestampInstant;
            }
            LOGGER.debug("{}: maxDate = {}", (Object)this.loggingPrefix, maxDate);
            SearchHit[] searchHitArray = maxDate;
            return searchHitArray;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        finally {
            LOGGER.debug("{}: getUpperTargetDate time: {} ms", (Object)this.loggingPrefix, (Object)(System.currentTimeMillis() - start));
        }
    }

    long countDocuments(Instant lowerDateLimit, Instant upperDateLimit) throws OpenSearchRelatedException {
        LOGGER.info("{}: countDocuments lowerDateLimit={}, upperDateLimit={}", (Object)this.loggingPrefix, (Object)lowerDateLimit, (Object)upperDateLimit);
        long start = System.currentTimeMillis();
        try {
            QueryBuilder query = new BpcQueryBuilder().addQueryBuilder(QueryBuilders.rangeQuery(this.lastUpdateTimestampFieldInOpenSearch).gte(lowerDateLimit.toEpochMilli()).lte(upperDateLimit.toEpochMilli())).addSkipPercolatorDocumentsQuery().buildAsBoolMustQuery();
            CountRequest countRequest = new CountRequest().indices(this.index).query(query);
            CountResponse countResponse = this.oss.getClient().count(countRequest, RequestOptions.DEFAULT);
            long l = countResponse.getCount();
            return l;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        finally {
            LOGGER.debug("{}: countDocuments time: {} ms", (Object)this.loggingPrefix, (Object)(System.currentTimeMillis() - start));
        }
    }
}

