/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.logger;

import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobStats;
import de.virtimo.bpc.util.MapUtil;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationJobLogData {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationJobLogData.class);
    private final String jobId;
    private final String dataSource;
    private final String sourceTable;
    private final String targetIndex;
    private Date startDate;
    private Date endDate;
    private long durationInMilliseconds;
    private long numberOfReplicatedRecords;
    private Date queryFromDate;
    private Date queryToDate;
    private final long usedIntervalInSeconds;
    private final long usedDayRange;
    private final long usedBlockSize;
    private Map<String, Object> error;

    public ReplicationJobLogData(ReplicationJob replicationJob) {
        this.jobId = replicationJob.getId();
        this.dataSource = replicationJob.getSource().getDataSourceName();
        this.sourceTable = replicationJob.getSource().getTable();
        this.targetIndex = replicationJob.getTarget().getIndex();
        this.startDate = null;
        this.endDate = null;
        this.durationInMilliseconds = -1L;
        this.numberOfReplicatedRecords = -1L;
        this.queryToDate = null;
        this.queryFromDate = null;
        this.usedIntervalInSeconds = replicationJob.getSettings().getReplicationInterval();
        this.usedBlockSize = replicationJob.getSettings().getBlockSize();
        this.usedDayRange = replicationJob.getSettings().getBlockDayRange();
        this.error = null;
    }

    public void setValues(ReplicationJobStats stats) {
        this.startDate = stats.getLastRunStartDate();
        this.endDate = stats.getLastRunEndDate();
        this.durationInMilliseconds = this.startDate != null && this.endDate != null ? this.endDate.getTime() - this.startDate.getTime() : -1L;
        this.numberOfReplicatedRecords = stats.getLastRunReplicatedRecords();
        Throwable t = stats.getLastOccurredException();
        if (t != null) {
            try {
                Map responseEntityMap;
                Exception ex = t instanceof Exception ? (Exception)t : new Exception(t);
                Response response = ErrorResponse.language("en").forException(ex).build();
                Object responseEntityObject = response.getEntity();
                Map<String, Object> errorContent = null;
                if (responseEntityObject instanceof Map && (responseEntityMap = (Map)responseEntityObject).containsKey("error") && responseEntityMap.get("error") instanceof Map) {
                    errorContent = (Map<String, Object>)responseEntityMap.get("error");
                }
                if (errorContent == null) {
                    LOGGER.error("Hey BPC devs, someone changed the exception response format. Please fix this.", t);
                    errorContent = MapUtil.mapOf("code", CoreErrorCode.UNEXPECTED.getNumber(), "name", CoreErrorCode.UNEXPECTED, "message", t.getMessage());
                }
                this.error = errorContent;
            }
            catch (Exception ex) {
                LOGGER.error("Failed to set a replication exception to the replication log data.", (Throwable)ex);
                this.error = MapUtil.mapOf("code", CoreErrorCode.UNEXPECTED.getNumber(), "name", CoreErrorCode.UNEXPECTED, "message", t.getMessage());
            }
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public long getDurationInMilliseconds() {
        return this.durationInMilliseconds;
    }

    public long getNumberOfReplicatedRecords() {
        return this.numberOfReplicatedRecords;
    }

    public void setQueryFromDate(Date queryFromDate) {
        this.queryFromDate = queryFromDate;
    }

    public Date getQueryFromDate() {
        return this.queryFromDate;
    }

    public void setQueryToDate(Date queryToDate) {
        this.queryToDate = queryToDate;
    }

    public Date getQueryToDate() {
        return this.queryToDate;
    }

    public long getUsedIntervalInSeconds() {
        return this.usedIntervalInSeconds;
    }

    public long getUsedDayRange() {
        return this.usedDayRange;
    }

    public long getUsedBlockSize() {
        return this.usedBlockSize;
    }

    public Map<String, Object> getError() {
        return this.error;
    }
}

