/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.shadowcopy;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobSettings;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopy;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopyException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.tasks.CancelTasksRequest;
import org.opensearch.client.tasks.CancelTasksResponse;
import org.opensearch.client.tasks.TaskId;
import org.opensearch.client.tasks.TaskSubmissionResponse;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.reindex.ReindexRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class ShadowCopyTask
implements InterruptableJob {
    private static final Logger LOGGER = LogManager.getLogger(ShadowCopyTask.class);
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private String replicationJobId;
    private TaskId reindexTaskId;
    private boolean cancelled = false;

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void interrupt() throws UnableToInterruptJobException {
        LOGGER.info("{}: interrupt", (Object)this.replicationJobId);
        if (!this.cancelled) {
            this.cancelled = true;
            if (this.reindexTaskId != null) {
                try {
                    this.cancelTask(this.reindexTaskId);
                }
                catch (ServiceNotFoundException ex) {
                    LOGGER.warn("{}: Failed to cancel a running reindex task due to missing OpenSearch service.", (Object)this.replicationJobId, (Object)ex);
                }
                catch (OpenSearchRelatedException ex) {
                    LOGGER.error("{}: Failed to cancel a running reindex task due to an OpenSearch problem.", (Object)this.replicationJobId, (Object)ex);
                }
            }
        }
    }

    private boolean cancelTask(TaskId taskId) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("{}: cancelTask taskId={}", (Object)this.replicationJobId, (Object)taskId);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            CancelTasksRequest cancelTasksRequest = new CancelTasksRequest.Builder().withTaskId(taskId).build();
            CancelTasksResponse response = oss.getClient().tasks().cancel(cancelTasksRequest, RequestOptions.DEFAULT);
            if (response == null) {
                return false;
            }
            if (response.getNodeFailures() != null && !response.getNodeFailures().isEmpty()) {
                return false;
            }
            return response.getTaskFailures() == null || response.getTaskFailures().isEmpty();
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        ReplicationJob replicationJob = (ReplicationJob)jobDataMap.get((Object)"replicationJob");
        this.replicationJobId = replicationJob.getId();
        this.reindexTaskId = null;
        LOGGER.info("{}: execute context={}", (Object)this.replicationJobId, (Object)context);
        BundleContext bundleContext = FrameworkUtil.getBundle(ShadowCopyTask.class).getBundleContext();
        ShadowCopy shadowCopy = replicationJob.getShadowCopy();
        if (shadowCopy.isRunning()) {
            LOGGER.warn("{}: Skipping the shadow copy task execution. There is already a running task for the source index/alias: {}", (Object)this.replicationJobId, (Object)replicationJob.getTarget().getIndex());
            return;
        }
        if (!replicationJob.isEnabled()) {
            LOGGER.warn("{}: Skipping the shadow copy task execution. The related replication job is disabled.", (Object)this.replicationJobId);
            return;
        }
        if (!shadowCopy.isEnabled()) {
            LOGGER.warn("{}: Skipping the shadow copy task execution. It is disabled.", (Object)this.replicationJobId);
            return;
        }
        try {
            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            this.performShadowCopy(oss, shadowCopy, replicationJob.getSettings(), replicationJob.getSource(), replicationJob.getTarget());
        }
        catch (ServiceNotFoundException ex) {
            throw new ShadowCopyException("Failed to get the OpenSearch service: " + ex.getMessage());
        }
        finally {
            BpcServicesTracker.stopAll(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performShadowCopy(OpenSearchService oss, ShadowCopy shadowCopy, ReplicationJobSettings replicationJobSettings, ReplicationSource replicationSource, ReplicationTarget replicationTarget) {
        String targetIndexName;
        boolean targetIndexMustBeDeletedOnProblems;
        block96: {
            block97: {
                block94: {
                    block95: {
                        block92: {
                            block93: {
                                block90: {
                                    block91: {
                                        block88: {
                                            block89: {
                                                block86: {
                                                    block87: {
                                                        block84: {
                                                            block85: {
                                                                block82: {
                                                                    block83: {
                                                                        LOGGER.info("{}: performShadowCopy oss=..., shadowCopy=..., replicationJobSettings=..., replicationSource=..., replicationTarget=...", (Object)this.replicationJobId);
                                                                        shadowCopy.setRunning(true);
                                                                        shadowCopy.setLastRunStart(new Date());
                                                                        shadowCopy.setLastRunEnd(null);
                                                                        targetIndexMustBeDeletedOnProblems = false;
                                                                        targetIndexName = null;
                                                                        try {
                                                                            String sourceAliasName = replicationTarget.getIndex();
                                                                            LOGGER.info("{}: Source alias name to create a shadow copy from: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                            if (this.isCancelled()) {
                                                                                LOGGER.warn("{}: Forced stop/termination of shadow copy task: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                return;
                                                                            }
                                                                            if (!oss.existsIndex(sourceAliasName)) {
                                                                                LOGGER.error("{}: Source index/alias does not exist: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                throw new ShadowCopyException("Source index/alias does not exist: " + sourceAliasName);
                                                                            }
                                                                            Set<String> sourceIndices = oss.getIndexNamesWithAlias(sourceAliasName);
                                                                            if (sourceIndices.size() != 1) {
                                                                                LOGGER.error("{}: Source alias '{}' with multiple physical indices '{}' is not supported.", (Object)this.replicationJobId, (Object)sourceAliasName, sourceIndices);
                                                                                throw new ShadowCopyException("Source alias '" + sourceAliasName + "' with multiple physical indices '" + sourceIndices + "' is not supported.");
                                                                            }
                                                                            String sourceIndexName = sourceIndices.iterator().next();
                                                                            LOGGER.info("{}: Source index name to create a shadow copy from: {}", (Object)this.replicationJobId, (Object)sourceIndexName);
                                                                            this.deleteNoLongerUsedSourceIndices(oss, sourceAliasName, sourceIndexName, shadowCopy.getKeepCopiesCount() + 1);
                                                                            targetIndexName = oss.newIndexNameForAlias(sourceAliasName);
                                                                            LOGGER.info("{}: Target index name: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                                                                            if (oss.existsIndex(targetIndexName)) {
                                                                                throw new ShadowCopyException("The target index '" + targetIndexName + "' exists already.");
                                                                            }
                                                                            if (this.isCancelled()) {
                                                                                LOGGER.warn("{}: Forced stop/termination of shadow copy task: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems || targetIndexName == null) break block82;
                                                                                break block83;
                                                                            }
                                                                            try {
                                                                                Map<String, Object> defaultIndexCreationSettings = oss.getDefaultIndexCreationSettings();
                                                                                oss.createIndex(targetIndexName, defaultIndexCreationSettings);
                                                                            }
                                                                            catch (Exception ex) {
                                                                                throw new ShadowCopyException("Failed to create the target index '" + targetIndexName + "'.", ex);
                                                                            }
                                                                            targetIndexMustBeDeletedOnProblems = true;
                                                                            if (this.isCancelled()) {
                                                                                LOGGER.warn("{}: Forced stop of shadow copy task: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block84;
                                                                                break block85;
                                                                            }
                                                                            try {
                                                                                oss.copyIndexMapping(sourceIndexName, targetIndexName);
                                                                            }
                                                                            catch (OpenSearchRelatedException ex) {
                                                                                throw new ShadowCopyException("Failed to set the source index mapping to the target index: " + targetIndexName);
                                                                            }
                                                                            if (this.isCancelled()) {
                                                                                LOGGER.warn("{}: Forced stop/termination of shadow copy task: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block86;
                                                                                break block87;
                                                                            }
                                                                            Map<String, Object> sourceIndexTypeMetaData = oss.getMetaDataValues(sourceIndexName);
                                                                            if (sourceIndexTypeMetaData != null) {
                                                                                try {
                                                                                    oss.setMetaDataValues(targetIndexName, sourceIndexTypeMetaData);
                                                                                }
                                                                                catch (Exception ex) {
                                                                                    throw new ShadowCopyException("Failed to set the meta data values of the source index '" + sourceIndexName + "' to the target index '" + targetIndexName + "'.", ex);
                                                                                }
                                                                            }
                                                                            if (this.isCancelled()) {
                                                                                LOGGER.warn("{}: Forced stop/termination of shadow copy task: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block88;
                                                                                break block89;
                                                                            }
                                                                            oss.flushIndices(sourceIndexName);
                                                                            LOGGER.info("{}: Reindex in progress ...", (Object)this.replicationJobId);
                                                                            String lastUpdateFieldInOpenSearch = replicationTarget.getDbColumnNamesToOpenSearchFieldNamesConverter().convert(replicationSource.getLastUpdateColumn());
                                                                            LOGGER.info("{}: Last update field name: {}", (Object)this.replicationJobId, (Object)lastUpdateFieldInOpenSearch);
                                                                            Date replicationStartDate = replicationJobSettings.getReplicationStartDateAsDate();
                                                                            LOGGER.info("{}: Replication start date: {} = {}", (Object)this.replicationJobId, (Object)replicationStartDate, (Object)replicationStartDate.getTime());
                                                                            RangeQueryBuilder filterQuery = QueryBuilders.rangeQuery(lastUpdateFieldInOpenSearch).gte(replicationStartDate.getTime());
                                                                            LOGGER.info("{}: Filter query: {}", (Object)this.replicationJobId, (Object)filterQuery);
                                                                            ReindexRequest reindexRequest = new ReindexRequest();
                                                                            reindexRequest.setSourceIndices(sourceIndexName);
                                                                            reindexRequest.setDestIndex(targetIndexName);
                                                                            reindexRequest.setSourceQuery(filterQuery);
                                                                            reindexRequest.setRefresh(true);
                                                                            TaskSubmissionResponse reindexTaskResponse = oss.getClient().submitReindexTask(reindexRequest, RequestOptions.DEFAULT);
                                                                            LOGGER.debug("{}: Reindex task response = {}", (Object)this.replicationJobId, (Object)reindexTaskResponse);
                                                                            this.reindexTaskId = new TaskId(reindexTaskResponse.getTask());
                                                                            if (this.isCancelled()) {
                                                                                LOGGER.warn("{}: Forced stop/termination of shadow copy task: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block90;
                                                                                break block91;
                                                                            }
                                                                            long reindexTaskStartTime = System.currentTimeMillis();
                                                                            try {
                                                                                oss.waitForTaskCompletionByPollingStatus(this.reindexTaskId, 3000L);
                                                                            }
                                                                            catch (OpenSearchRelatedException ex) {
                                                                                throw new ShadowCopyException("Reindex failed due to not completed reindex task. Source index:" + sourceIndexName + ", target index:" + targetIndexName, ex);
                                                                            }
                                                                            LOGGER.info("{}: Waited for reindex task completion: {} ms", (Object)this.replicationJobId, (Object)(System.currentTimeMillis() - reindexTaskStartTime));
                                                                            this.reindexTaskId = null;
                                                                            if (this.isCancelled()) {
                                                                                LOGGER.warn("{}: Forced stop/termination of shadow copy task: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block92;
                                                                                break block93;
                                                                            }
                                                                            LOGGER.info("{}: Alias switching from source to target index.", (Object)this.replicationJobId);
                                                                            try {
                                                                                oss.moveAlias(sourceIndexName, targetIndexName);
                                                                            }
                                                                            catch (Exception ex) {
                                                                                throw new ShadowCopyException("Alias modifications failed. Source index:" + sourceIndexName + ", target index:" + targetIndexName, ex);
                                                                            }
                                                                            targetIndexMustBeDeletedOnProblems = false;
                                                                            oss.closeIndex(sourceIndexName);
                                                                            if (this.isCancelled()) {
                                                                                LOGGER.warn("{}: Forced stop/termination of shadow copy task: {}", (Object)this.replicationJobId, (Object)sourceAliasName);
                                                                                if (!targetIndexMustBeDeletedOnProblems) break block94;
                                                                                break block95;
                                                                            }
                                                                            this.deleteNoLongerUsedSourceIndices(oss, sourceAliasName, targetIndexName, shadowCopy.getKeepCopiesCount());
                                                                            if (!targetIndexMustBeDeletedOnProblems) break block96;
                                                                            break block97;
                                                                        }
                                                                        catch (ShadowCopyException ex) {
                                                                            LOGGER.error("{}: Failed to perform the shadow copy task.", (Object)this.replicationJobId, (Object)ex);
                                                                            throw ex;
                                                                        }
                                                                        catch (CancellationException ex) {
                                                                            LOGGER.info("{}: Shadow copy task terminated.", (Object)this.replicationJobId);
                                                                            return;
                                                                        }
                                                                        catch (IllegalStateException ex) {
                                                                            if (ex.getCause() instanceof InterruptedException) {
                                                                                LOGGER.info("{}: Shadow copy task interrupted.", (Object)this.replicationJobId);
                                                                                return;
                                                                            }
                                                                            LOGGER.error("{}: Unexpectactly failed to perform the shadow copy task.", (Object)this.replicationJobId, (Object)ex);
                                                                            throw new ShadowCopyException("Failed to perform the shadow copy task: " + ex.getMessage());
                                                                        }
                                                                        catch (Throwable ex) {
                                                                            LOGGER.error("{}: Unexpectactly failed to perform the shadow copy task.", (Object)this.replicationJobId, (Object)ex);
                                                                            throw new ShadowCopyException("Failed to perform the shadow copy task: " + ex.getMessage());
                                                                        }
                                                                    }
                                                                    LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                                                                    try {
                                                                        if (oss != null) {
                                                                            oss.deleteIndex(targetIndexName);
                                                                        }
                                                                    }
                                                                    catch (Throwable ex) {
                                                                        LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName, (Object)ex);
                                                                    }
                                                                }
                                                                shadowCopy.setRunning(false);
                                                                shadowCopy.setLastRunEnd(new Date());
                                                                return;
                                                            }
                                                            if (targetIndexName != null) {
                                                                LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                                                                try {
                                                                    if (oss != null) {
                                                                        oss.deleteIndex(targetIndexName);
                                                                    }
                                                                }
                                                                catch (Throwable ex) {
                                                                    LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName, (Object)ex);
                                                                }
                                                            }
                                                        }
                                                        shadowCopy.setRunning(false);
                                                        shadowCopy.setLastRunEnd(new Date());
                                                        return;
                                                    }
                                                    if (targetIndexName != null) {
                                                        LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                                                        try {
                                                            if (oss != null) {
                                                                oss.deleteIndex(targetIndexName);
                                                            }
                                                        }
                                                        catch (Throwable ex) {
                                                            LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName, (Object)ex);
                                                        }
                                                    }
                                                }
                                                shadowCopy.setRunning(false);
                                                shadowCopy.setLastRunEnd(new Date());
                                                return;
                                            }
                                            if (targetIndexName != null) {
                                                LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                                                try {
                                                    if (oss != null) {
                                                        oss.deleteIndex(targetIndexName);
                                                    }
                                                }
                                                catch (Throwable ex) {
                                                    LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName, (Object)ex);
                                                }
                                            }
                                        }
                                        shadowCopy.setRunning(false);
                                        shadowCopy.setLastRunEnd(new Date());
                                        return;
                                    }
                                    if (targetIndexName != null) {
                                        LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                                        try {
                                            if (oss != null) {
                                                oss.deleteIndex(targetIndexName);
                                            }
                                        }
                                        catch (Throwable ex) {
                                            LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName, (Object)ex);
                                        }
                                    }
                                }
                                shadowCopy.setRunning(false);
                                shadowCopy.setLastRunEnd(new Date());
                                return;
                            }
                            if (targetIndexName != null) {
                                LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                                try {
                                    if (oss != null) {
                                        oss.deleteIndex(targetIndexName);
                                    }
                                }
                                catch (Throwable ex) {
                                    LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName, (Object)ex);
                                }
                            }
                        }
                        shadowCopy.setRunning(false);
                        shadowCopy.setLastRunEnd(new Date());
                        return;
                    }
                    if (targetIndexName != null) {
                        LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                        try {
                            if (oss != null) {
                                oss.deleteIndex(targetIndexName);
                            }
                        }
                        catch (Throwable ex) {
                            LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName, (Object)ex);
                        }
                    }
                }
                shadowCopy.setRunning(false);
                shadowCopy.setLastRunEnd(new Date());
                return;
            }
            if (targetIndexName != null) {
                LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName);
                try {
                    if (oss != null) {
                        oss.deleteIndex(targetIndexName);
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, (Object)targetIndexName, (Object)ex);
                }
            }
        }
        shadowCopy.setRunning(false);
        shadowCopy.setLastRunEnd(new Date());
        return;
        finally {
            if (targetIndexMustBeDeletedOnProblems && targetIndexName != null) {
                LOGGER.info("{}: Problem occurred ... deleting the temporary target index: {}", (Object)this.replicationJobId, targetIndexName);
                try {
                    if (oss != null) {
                        oss.deleteIndex(targetIndexName);
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("{}: Failed to delete the temporary target index: {}", (Object)this.replicationJobId, targetIndexName, (Object)ex);
                }
            }
            shadowCopy.setRunning(false);
            shadowCopy.setLastRunEnd(new Date());
        }
    }

    private void deleteNoLongerUsedSourceIndices(OpenSearchService oss, String sourceAliasName, String indexToIgnore, int numberOfInstancesToKeep) throws OpenSearchRelatedException {
        LOGGER.info("{}: deleteNoLongerUsedSourceIndices oss=..., sourceAliasName={}, indexToIgnore={}, numberOfInstancesToKeep={}", (Object)this.replicationJobId, (Object)sourceAliasName, (Object)indexToIgnore, (Object)numberOfInstancesToKeep);
        List<String> allIndices = oss.getAllBpcIndexNamesWithAlias(sourceAliasName);
        LOGGER.info("{}: All indices with prefix '{}': {}", (Object)this.replicationJobId, (Object)sourceAliasName, allIndices);
        allIndices.remove(indexToIgnore);
        LOGGER.info("{}: Updated all indices with prefix '{}': {}", (Object)this.replicationJobId, (Object)sourceAliasName, allIndices);
        List<String> indicesToDelete = ShadowCopyTask.getOpenSearchIndiceNamesToDelete(allIndices, numberOfInstancesToKeep);
        LOGGER.info("{}: Indices to delete: {}", (Object)this.replicationJobId, indicesToDelete);
        if (indicesToDelete.isEmpty()) {
            LOGGER.info("{}: No source indices to delete.", (Object)this.replicationJobId);
        } else {
            for (String indiceToDelete : indicesToDelete) {
                try {
                    oss.deleteIndex(indiceToDelete);
                    LOGGER.info("{}: No longer used source index '{}' deleted.", (Object)this.replicationJobId, (Object)indiceToDelete);
                }
                catch (Exception ex) {
                    LOGGER.error("{}: Could not delete the source index: '{}'.", (Object)this.replicationJobId, (Object)indiceToDelete);
                    throw new ShadowCopyException("Could not delete the source index: '" + indiceToDelete + "'.", ex);
                }
            }
        }
    }

    public static List<String> getOpenSearchIndiceNamesToDelete(List<String> indiceNames, int numberOfInstancesToKeep) {
        ArrayList<String> result = new ArrayList<String>();
        if (numberOfInstancesToKeep == 0) {
            result.addAll(indiceNames);
        } else if (numberOfInstancesToKeep < indiceNames.size()) {
            Collections.sort(indiceNames);
            Collections.reverse(indiceNames);
            for (int i = numberOfInstancesToKeep; i < indiceNames.size(); ++i) {
                result.add(indiceNames.get(i));
            }
        }
        return result;
    }
}

