/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupRestoredInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="configuration")
@Tag(name="Backups API", description="These endpoints allow to create, delete, restore and retrieve BPC backups.\n")
public class ConfigurationBackupsEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationBackupsEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<BackupManager> backupManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public ConfigurationBackupsEndpoint(BundleContext bundleContext) {
        LOGGER.info("ConfigurationBackupsEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(this.bundleContext, BackupManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/backups")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_VIEW", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get a list of all backups/snapshots as JSON.", description="Get a list of all backups/snapshots as JSON.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getBackups(@Context HttpHeaders hh) {
        LOGGER.info("getBackups");
        try {
            BackupManager backupManager = this.backupManagerTracker.getService();
            List<BackupSnapshotInfo> snapshotInfos = backupManager.getAllBackups();
            backupManager.sortSnapshotInfosByStartTime(snapshotInfos, false);
            return Response.ok(snapshotInfos).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the list of backups: {}", (Object)ex.getMessage(), (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @POST
    @Path(value="/backups/create")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_CREATE", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Creates a backup/snapshot of the BPC configuration index `bpc-configuration`.", description="Creates a backup/snapshot of the BPC configuration index `bpc-configuration`.")
    @ReturnDescription(value="The backup/snapshot info as JSON.")
    public Response createBackup(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("createBackup");
        return this.createBackupUsingBackupJob("core:bpc-configuration", userSession, hh);
    }

    @Produces(value={"application/json"})
    @POST
    @Path(value="/backups/create/{backupJobIdentifier}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_CREATE", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Backup job not found")})
    @OperationDescription(summary="Creates a backup/snapshot of the indices related to a backup job.", description="Creates a backup/snapshot of the indices related to a backup job.")
    @ReturnDescription(value="The backup/snapshot info as JSON.")
    public Response createBackupUsingBackupJob(@Parameter(description="the identifier of the backup job") @PathParam(value="backupJobIdentifier") String backupJobIdentifier, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("createBackupUsingBackupJob backupJobIdentifier={}", (Object)backupJobIdentifier);
        try {
            BackupSnapshotInfo snapshotInfo = this.backupManagerTracker.getService().startBackupJob(backupJobIdentifier);
            UserAuditLog.info(userSession, "BackupCreated", "Backup of the backup job '" + backupJobIdentifier + "' with the snapshot name '" + snapshotInfo.getSnapshotName() + "' created.");
            return Response.ok((Object)snapshotInfo).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create the index snapshot/backup of the backup job '{}'.", (Object)backupJobIdentifier, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/backups/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_VIEW", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the data of a specific backup/snapshot.", description="Get the data of a specific backup/snapshot.")
    @ReturnDescription(value="The requested backup/snapshot data as JSON.")
    public Response getBackup(@Parameter(description="the name of the backup/snapshot to get the infos for") @PathParam(value="snapshotName") String snapshotName, @Context HttpHeaders hh) {
        LOGGER.info("getBackup snapshotName={}", (Object)snapshotName);
        try {
            BackupSnapshotInfo snapshotInfo = this.backupManagerTracker.getService().getBackupInfo(snapshotName);
            return Response.ok((Object)snapshotInfo).build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not get the data of the snapshot '{}'.", (Object)snapshotName, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @DELETE
    @Path(value="/backups/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_DELETE", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Delete a specific backup/snapshot.", description="Delete a specific backup/snapshot.")
    @ReturnDescription(value="The info of the deleted backup/snapshot as JSON.")
    public Response deleteBackup(@Parameter(description="the name of the backup/snapshot to delete") @PathParam(value="snapshotName") String snapshotName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("deleteBackup snapshotName={}", (Object)snapshotName);
        try {
            BackupSnapshotInfo snapshotInfo = this.backupManagerTracker.getService().deleteBackup(snapshotName);
            if (snapshotInfo != null) {
                UserAuditLog.info(userSession, "BackupDeleted", "Backup with the snapshot name '" + snapshotInfo.getSnapshotName() + "' deleted");
            }
            return Response.ok((Object)snapshotInfo).build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not delete the snapshot '{}'.", (Object)snapshotName, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @PUT
    @Path(value="/backups/activate/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_ACTIVATE", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Restores and activates a specific backup/snapshot.", description="Restores and activates a specific backup/snapshot.")
    @ReturnDescription(value="Some infos about the restored and activated backup/snapshot as JSON.")
    public Response activateBackup(@Parameter(description="the name of the backup/snapshot to restore and activate") @PathParam(value="snapshotName") String snapshotName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("activateBackup snapshotName={}", (Object)snapshotName);
        try {
            BackupActivatedInfo backupActivatedInfo = this.backupManagerTracker.getService().activateBackup(snapshotName);
            UserAuditLog.info(userSession, "BackupRestored", "Backup with the snapshot name '" + snapshotName + "' restored");
            return Response.ok((Object)backupActivatedInfo).build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not activate the snapshot '{}'.", (Object)snapshotName, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @PUT
    @Path(value="/backups/restore/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_RESTORE", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Restores but does not activate a specific backup/snapshot.", description="Restores but does not activate a specific backup/snapshot.")
    @ReturnDescription(value="Some infos about the restored backup/snapshot as JSON.")
    public Response restoreBackup(@Parameter(description="the name of the snapshot to restore") @PathParam(value="snapshotName") String snapshotName, @Parameter(description="to give the OpenSearch index a new name (Optional; works only when the backup contains exactly one index)") @QueryParam(value="index-name") String givenIndexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("restoreBackup snapshotName={}", (Object)snapshotName);
        try {
            BackupRestoredInfo backupRestoredInfo = this.backupManagerTracker.getService().restoreBackup(snapshotName, givenIndexName);
            UserAuditLog.info(userSession, "BackupRestored", "Backup with the snapshot name '" + snapshotName + "' restored to the index '" + givenIndexName + "'.");
            return Response.ok((Object)backupRestoredInfo).build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not restore the snapshot '{}'.", (Object)snapshotName, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/backups/download/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_DOWNLOAD", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Download the content of a backup/snapshot.", description="Download the content of a backup/snapshot.")
    @ReturnDescription(value="The requested data as JSON. Uses the `snapshotName` parameter value as the filename.")
    public Response downloadBackup(@Parameter(description="the name of the backup/snapshot to download") @PathParam(value="snapshotName") String snapshotName, @Context HttpHeaders hh) {
        LOGGER.info("downloadBackup snapshotName={}", (Object)snapshotName);
        try {
            StreamingOutput stream = this.backupManagerTracker.getService().downloadSnapshotContent(snapshotName);
            return Response.ok((Object)stream, (String)"application/json").header("Content-Disposition", (Object)("attachment; filename=\"" + snapshotName + ".json\"")).build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not download the content of the snapshot '{}'.", (Object)snapshotName, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/backups/export/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_EXPORT", message="Not allowed to manage backups")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Export the content of a `bpc-configuration` index backup/snapshot as GlobalConfig object.", description="Export the content of a `bpc-configuration` index backup/snapshot as GlobalConfig object.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response exportBpcConfiguration(@Parameter(description="the name of the backup/snapshot") @PathParam(value="snapshotName") String snapshotName, @Context HttpHeaders hh) {
        LOGGER.info("exportBpcConfiguration snapshotName={}", (Object)snapshotName);
        try {
            GlobalConfig bpcConfig = this.backupManagerTracker.getService().exportBpcConfiguration(snapshotName);
            return Response.ok((Object)bpcConfig).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to export the bpc-configuration of the snapshot '{}'.", (Object)snapshotName, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

