/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.logservice.LogServiceModule;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="configuration")
@Tag(name="Lookup Joins API", description="Lookup joins are used in the replication process to replicate data from Databases, where the replicated data lies in multiple tables.\n")
public class ConfigurationLookupJoinsEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationLookupJoinsEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;

    public ConfigurationLookupJoinsEndpoint(BundleContext bundleContext) {
        LOGGER.info("ConfigurationLookupJoinsEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private ReplicationModule getReplicationModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return this.moduleManagerTracker.getService().getModuleByClass(ReplicationModule.class);
    }

    private LogServiceModule getLogServiceModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
    }

    @POST
    @Path(value="/lookupjoins/refresh")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOOKUP_JOINS_ADMIN", right="LOOKUP_JOINS_REFRESH_ALL", message="Not allowed to refresh all lookup joins")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Refresh the lookup joins data of all replication jobs and log services related indices.", description="Refresh the lookup joins data of all replication jobs and log services related indices.")
    public Response refreshAllLookupJoins(@Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("refreshAllLookupJoins");
        try {
            this.getReplicationModule().sendRefreshLookupJoinsOfAllReplicationJobsActionToPlugin(userSession);
            this.getLogServiceModule().refreshAllLookupJoins();
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not refresh the lookup joins of all replication jobs.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/lookupjoins/refresh/replicationjob/{replicationJobId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOOKUP_JOINS_ADMIN", right="LOOKUP_JOINS_REFRESH", message="Not allowed to refresh lookup joins")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Refresh the lookup joins data of a replication job related index.", description="Refresh the lookup joins data of a replication job related index.")
    public Response refreshLookupJoinsOfReplicationJob(@Parameter(description="the ID of the replication job") @PathParam(value="replicationJobId") String replicationJobId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("refreshLookupJoinsOfReplicationJob replicationJobId={}", (Object)replicationJobId);
        try {
            this.getReplicationModule().sendRefreshLookupJoinsOfReplicationJobActionToPlugin(replicationJobId, userSession);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not refresh the lookup joins of the replication job with the id: {}", (Object)replicationJobId, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/lookupjoins/refresh/logservice/{logServiceId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOOKUP_JOINS_ADMIN", right="LOOKUP_JOINS_REFRESH", message="Not allowed to refresh lookup joins")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Refresh the lookup joins data of a log service related index.", description="Refresh the lookup joins data of a log service related index.")
    public Response refreshLookupJoinsOfLogService(@Parameter(description="the ID of the log service") @PathParam(value="logServiceId") String logServiceId) {
        LOGGER.info("refreshLookupJoinsOfLogService logServiceId={}", (Object)logServiceId);
        try {
            this.getLogServiceModule().refreshLookupJoins(logServiceId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not refresh the lookup joins of the log service with the id: {}", (Object)logServiceId, (Object)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/lookupjoins/clearcaches")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOOKUP_JOINS_ADMIN", right="LOOKUP_JOINS_CLEAR_CACHE", message="Not allowed to clear the lookup join caches")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Clears the internally used lookup joins caches.", description="Clears the internally used lookup joins caches.")
    public Response clearLookupJoinsCache(@Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("clearLookupJoinsCache");
        try {
            this.getReplicationModule().sendClearLookupJoinCachesActionToPlugin(userSession);
            this.getLogServiceModule().clearLookupJoinCaches();
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Could not clear the lookup join caches.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

