/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaskPasswords {
    private static final Logger LOGGER = LogManager.getLogger(MaskPasswords.class);
    private static final AtomicLong ID_COUNTER = new AtomicLong(System.nanoTime());
    public static final String DO_NOT_DELETE_ID = "doNotDeleteId";
    private static final String PASSWORD_MASK = "******";
    private static final String CLEARED_PASSWORD_VALUE = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Setting> maskPasswords(Collection<Setting> settings) {
        LOGGER.debug("maskPasswords");
        long startTimestamp = System.currentTimeMillis();
        try {
            ArrayList<Setting> result = new ArrayList<Setting>();
            for (Setting setting : settings) {
                Setting updatedSetting = null;
                String settingType = setting.getType();
                if (!StringUtil.isNullOrEmpty(settingType)) {
                    switch (settingType.toLowerCase()) {
                        case "text": {
                            Setting setting2 = this.processTextSetting(setting);
                            break;
                        }
                        case "password": {
                            Setting setting2 = this.processPasswordSetting(setting);
                            break;
                        }
                        case "json": {
                            Setting setting2 = this.processJsonSetting(setting);
                            break;
                        }
                        default: {
                            Setting setting2 = updatedSetting = null;
                        }
                    }
                }
                if (updatedSetting != null) {
                    result.add(updatedSetting);
                    continue;
                }
                result.add(setting);
            }
            ArrayList<Setting> arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            LOGGER.error("Could not mask the passwords of the given settings. Using the unmasked settings.", (Throwable)ex);
        }
        finally {
            LOGGER.debug("maskPasswords time: {} ms", (Object)(System.currentTimeMillis() - startTimestamp));
        }
        return new ArrayList<Setting>(settings);
    }

    private Setting processTextSetting(Setting setting) {
        LOGGER.debug("processTextSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!this.isPasswordField(setting.getName())) {
            return null;
        }
        if (!this.isPasswordSet(setting.getValue())) {
            return null;
        }
        return new SimpleSettingImpl(setting, PASSWORD_MASK);
    }

    private Setting processPasswordSetting(Setting setting) {
        LOGGER.debug("processPasswordSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!this.isPasswordSet(setting.getValue())) {
            return null;
        }
        return new SimpleSettingImpl(setting, PASSWORD_MASK);
    }

    private Setting processJsonSetting(Setting setting) {
        LOGGER.debug("processJsonSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return setting;
        }
        SimpleSettingImpl settingImpl = (SimpleSettingImpl)setting;
        Object enrichedSettingValue = this.recursiveProcessJsonValueObject(setting.getValue(), false, false, true);
        settingImpl.setValue(enrichedSettingValue);
        Object maskedSettingValue = this.recursiveProcessJsonValueObject(enrichedSettingValue, true, false, false);
        return new SimpleSettingImpl(setting, maskedSettingValue);
    }

    private boolean isPasswordField(String value) {
        return value != null && value.toLowerCase().contains("password");
    }

    private boolean isPasswordSet(Object valueObject) {
        if (valueObject == null) {
            return false;
        }
        return !(valueObject instanceof String) || !StringUtil.isNullOrEmpty((String)valueObject);
    }

    private Object recursiveProcessJsonValueObject(Object object, boolean maskPasswords, boolean deleteMaskedPasswords, boolean addUniqueId) {
        if (object instanceof List) {
            ArrayList updatedList = new ArrayList();
            for (Object listEntry : (List)object) {
                Object updatedObject = listEntry instanceof List || listEntry instanceof Map ? this.recursiveProcessJsonValueObject(listEntry, maskPasswords, deleteMaskedPasswords, addUniqueId) : listEntry;
                updatedList.add(updatedObject);
            }
            return updatedList;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            LinkedHashMap<String, Object> updatedMap = new LinkedHashMap<String, Object>();
            for (Object mapKey : map.keySet()) {
                Object updatedObject;
                Object mapValue = map.get(mapKey);
                if (mapValue instanceof List || mapValue instanceof Map) {
                    updatedObject = this.recursiveProcessJsonValueObject(mapValue, maskPasswords, deleteMaskedPasswords, addUniqueId);
                } else if (mapKey instanceof String && this.isPasswordField((String)mapKey)) {
                    updatedObject = maskPasswords ? (this.isPasswordSet(mapValue) ? PASSWORD_MASK : mapValue) : mapValue;
                    if (deleteMaskedPasswords && PASSWORD_MASK.equals(updatedObject)) {
                        updatedObject = CLEARED_PASSWORD_VALUE;
                    }
                    if (addUniqueId && updatedMap.get(DO_NOT_DELETE_ID) == null) {
                        updatedMap.put(DO_NOT_DELETE_ID, CLEARED_PASSWORD_VALUE + ID_COUNTER.getAndIncrement());
                    }
                } else {
                    updatedObject = mapValue;
                }
                updatedMap.put((String)mapKey, updatedObject);
            }
            return updatedMap;
        }
        return object;
    }

    public void unmaskPasswords(Collection<Setting> existingSettings, Collection<Setting> updatedSettings) {
        LOGGER.debug("unmaskPasswords existingSettings=..., updatedSettings=...");
        if (existingSettings == null || updatedSettings == null) {
            return;
        }
        for (Setting updatedSetting : updatedSettings) {
            Setting existingSetting = this.getSettingByName(updatedSetting.getName(), existingSettings);
            if (existingSetting == null) continue;
            switch (updatedSetting.getType().toLowerCase()) {
                case "text": {
                    this.processUpdatedTextSetting(updatedSetting, existingSetting);
                    break;
                }
                case "password": {
                    this.processUpdatedPasswordSetting(updatedSetting, existingSetting);
                    break;
                }
                case "json": {
                    this.processUpdatedJsonSetting(updatedSetting, existingSetting);
                }
            }
        }
    }

    private Setting getSettingByName(String name, Collection<Setting> settings) {
        LOGGER.debug("getSettingByName '{}'", (Object)name);
        if (name == null || settings == null) {
            return null;
        }
        for (Setting setting : settings) {
            if (!name.equals(setting.getName())) continue;
            return setting;
        }
        return null;
    }

    private void processUpdatedTextSetting(Setting updatedSetting, Setting existingSetting) {
        LOGGER.debug("processUpdatedTextSetting");
        if (!this.isPasswordField(updatedSetting.getName())) {
            return;
        }
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl updatedSettingImpl = (SimpleSettingImpl)updatedSetting;
        Object valueObject = updatedSetting.getValue();
        if (!(valueObject instanceof String)) {
            return;
        }
        if (!valueObject.equals(PASSWORD_MASK)) {
            return;
        }
        updatedSettingImpl.setValue(existingSetting.getValue());
    }

    private void processUpdatedPasswordSetting(Setting updatedSetting, Setting existingSetting) {
        LOGGER.debug("processUpdatedPasswordSetting updatedSetting=..., existingSetting=...");
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl updatedSettingImpl = (SimpleSettingImpl)updatedSetting;
        Object valueObject = updatedSetting.getValue();
        if (!(valueObject instanceof String)) {
            return;
        }
        if (!valueObject.equals(PASSWORD_MASK)) {
            return;
        }
        updatedSettingImpl.setValue(existingSetting.getValue());
    }

    private void processUpdatedJsonSetting(Setting updatedSetting, Setting existingSetting) {
        LOGGER.debug("processUpdatedJsonSetting");
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl updatedSettingImpl = (SimpleSettingImpl)updatedSetting;
        Object updatedValue = this.recursiveUnmaskPasswords(updatedSetting.getValue(), existingSetting.getValue());
        updatedSettingImpl.setValue(updatedValue);
    }

    private Object recursiveUnmaskPasswords(Object object, Object existingObject) {
        if (object instanceof List) {
            List currentList = (List)object;
            ArrayList updatedList = new ArrayList();
            for (Object currentListEntry : currentList) {
                Object updatedObject = currentListEntry instanceof List || currentListEntry instanceof Map ? this.recursiveUnmaskPasswords(currentListEntry, existingObject) : currentListEntry;
                updatedList.add(updatedObject);
            }
            return updatedList;
        }
        if (object instanceof Map) {
            Map currentMap = (Map)object;
            LinkedHashMap updatedMap = new LinkedHashMap();
            for (Object mapKey : currentMap.keySet()) {
                Object updatedObject;
                Object mapValue = currentMap.get(mapKey);
                if (mapValue instanceof List || mapValue instanceof Map) {
                    updatedObject = this.recursiveUnmaskPasswords(mapValue, existingObject);
                } else {
                    Object realPassword;
                    String doNotDeleteId;
                    Map relatedExistingMap;
                    Object doNotDeleteIdObject;
                    updatedObject = mapValue;
                    if (mapKey instanceof String && this.isPasswordField((String)mapKey) && PASSWORD_MASK.equals(mapValue) && (doNotDeleteIdObject = currentMap.get(DO_NOT_DELETE_ID)) instanceof String && (relatedExistingMap = this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId = (String)doNotDeleteIdObject, existingObject)) != null && (realPassword = relatedExistingMap.get(mapKey)) instanceof String) {
                        updatedObject = realPassword;
                    }
                }
                updatedMap.put(mapKey, updatedObject);
            }
            return updatedMap;
        }
        return object;
    }

    private Map recursiveFindMapWithDoNotDeleteId(String doNotDeleteId, Object object) {
        if (object instanceof List) {
            Object listEntry;
            List currentList = (List)object;
            Map foundMap = null;
            Iterator iterator = currentList.iterator();
            while (iterator.hasNext() && (foundMap = (listEntry = iterator.next()) instanceof List || listEntry instanceof Map ? this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId, listEntry) : null) == null) {
            }
            return foundMap;
        }
        if (object instanceof Map) {
            Map currentMap = (Map)object;
            Map foundMap = null;
            for (Object mapKey : currentMap.keySet()) {
                Object mapValue = currentMap.get(mapKey);
                if (mapValue instanceof List || mapValue instanceof Map) {
                    foundMap = this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId, mapValue);
                } else {
                    if (mapKey.equals(DO_NOT_DELETE_ID) && doNotDeleteId.equals(mapValue)) {
                        foundMap = currentMap;
                        break;
                    }
                    foundMap = null;
                }
                if (foundMap == null) continue;
                break;
            }
            return foundMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskedPasswords(Collection<Setting> settings) {
        LOGGER.debug("clearMaskedPasswords settings=...");
        long startTimestamp = System.currentTimeMillis();
        try {
            for (Setting setting : settings) {
                String settingType = setting.getType();
                if (StringUtil.isNullOrEmpty(settingType)) continue;
                switch (settingType.toLowerCase()) {
                    case "text": {
                        this.clearMaskedPasswordFromTextSetting(setting);
                        break;
                    }
                    case "password": {
                        this.clearMaskedPasswordFromPasswordSetting(setting);
                        break;
                    }
                    case "json": {
                        this.clearMaskedPasswordsFromJsonSetting(setting);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to clear masked passwords of the given settings. Using the masked settings.", (Throwable)ex);
        }
        finally {
            LOGGER.debug("clearMaskedPasswords time: {} ms", (Object)(System.currentTimeMillis() - startTimestamp));
        }
    }

    private void clearMaskedPasswordFromTextSetting(Setting setting) {
        LOGGER.debug("clearMaskedPasswordFromTextSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl settingImpl = (SimpleSettingImpl)setting;
        if (!this.isPasswordField(setting.getName())) {
            return;
        }
        if (!PASSWORD_MASK.equals(setting.getValue())) {
            return;
        }
        settingImpl.setValue(CLEARED_PASSWORD_VALUE);
    }

    private void clearMaskedPasswordFromPasswordSetting(Setting setting) {
        LOGGER.debug("clearMaskedPasswordFromPasswordSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl settingImpl = (SimpleSettingImpl)setting;
        if (!PASSWORD_MASK.equals(setting.getValue())) {
            return;
        }
        settingImpl.setValue(CLEARED_PASSWORD_VALUE);
    }

    private void clearMaskedPasswordsFromJsonSetting(Setting setting) {
        LOGGER.debug("clearMaskedPasswordsFromJsonSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl settingImpl = (SimpleSettingImpl)setting;
        Object enrichedSettingValue = this.recursiveProcessJsonValueObject(setting.getValue(), false, false, true);
        settingImpl.setValue(enrichedSettingValue);
        Object maskedSettingValue = this.recursiveProcessJsonValueObject(enrichedSettingValue, false, true, false);
        settingImpl.setValue(maskedSettingValue);
    }
}

