/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingValueFilter {
    private static final Logger LOGGER = LogManager.getLogger(SettingValueFilter.class);
    private final UserSession userSession;

    public SettingValueFilter(UserSession userSession) {
        this.userSession = userSession;
    }

    private boolean canBeFiltered(Setting setting) {
        if (setting != null && setting instanceof SimpleSettingImpl && setting.getCustomFields().getBooleanValue("_valueMustBeFiltered") && "json".equalsIgnoreCase(setting.getType())) {
            return setting.getValue() != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Setting> filter(Collection<Setting> settings) {
        LOGGER.debug("filter");
        long startTimestamp = System.currentTimeMillis();
        try {
            ArrayList<Setting> result = new ArrayList<Setting>();
            for (Setting setting : settings) {
                Setting updatedSetting = null;
                if (this.canBeFiltered(setting)) {
                    updatedSetting = this.processJsonSetting(setting);
                }
                if (updatedSetting != null) {
                    result.add(updatedSetting);
                    continue;
                }
                result.add(setting);
            }
            ArrayList<Setting> arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            LOGGER.error("Could not filter the values of the given settings. Using the settings as they are.", (Throwable)ex);
        }
        finally {
            LOGGER.debug("filter time: {} ms", (Object)(System.currentTimeMillis() - startTimestamp));
        }
        return new ArrayList<Setting>(settings);
    }

    private Setting processJsonSetting(Setting setting) {
        LOGGER.debug("processJsonSetting setting=...");
        Object filteredSettingValue = this.recursiveProcessJsonValueObject(setting.getValue());
        SimpleSettingImpl updatedSetting = new SimpleSettingImpl(setting);
        updatedSetting.setValue(filteredSettingValue);
        return updatedSetting;
    }

    private Object recursiveProcessJsonValueObject(Object object) {
        if (object instanceof List) {
            ArrayList<Object> updatedList = new ArrayList<Object>();
            for (Object listEntry : (List)object) {
                Object updatedObject = listEntry instanceof List ? this.recursiveProcessJsonValueObject(listEntry) : (listEntry instanceof Map ? this.recursiveProcessJsonValueObject(listEntry) : listEntry);
                if (updatedObject == null) continue;
                updatedList.add(updatedObject);
            }
            return updatedList;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.isUserAllowedToSee(map)) {
                HashMap updatedMap = new HashMap();
                for (Object mapKey : map.keySet()) {
                    Object mapValue = map.get(mapKey);
                    Object updatedObject = mapValue instanceof List ? this.recursiveProcessJsonValueObject(mapValue) : (mapValue instanceof Map ? this.recursiveProcessJsonValueObject(mapValue) : mapValue);
                    updatedMap.put(mapKey, updatedObject);
                }
                return updatedMap;
            }
            return null;
        }
        return object;
    }

    boolean isUserAllowedToSee(Map map) {
        if (map != null) {
            if (this.userSession.hasRole("bpcadmin")) {
                return true;
            }
            Set<String> rights = this.getFieldValues(map, SetUtil.setOf("right", "rights"));
            if (rights != null && !this.userSession.hasAnyRight(rights)) {
                return false;
            }
            Set<String> roles = this.getFieldValues(map, SetUtil.setOf("role", "roles"));
            if (roles != null && !this.userSession.hasAnyRole(roles)) {
                return false;
            }
            Set<String> organisations = this.getFieldValues(map, SetUtil.setOf("organisation", "organisations"));
            if (organisations != null && !this.userSession.hasAnyOrganisation(organisations)) {
                return false;
            }
        }
        return true;
    }

    private Set<String> getFieldValues(Map map, Set<String> fieldNames) {
        HashSet<String> result = null;
        if (map != null) {
            for (String fieldName : fieldNames) {
                List fieldListEntries;
                String fieldValue;
                Object fieldObject = map.get(fieldName);
                if (fieldObject instanceof String && !StringUtil.isNullOrEmpty(fieldValue = (String)fieldObject)) {
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(fieldValue);
                }
                if (!(fieldObject instanceof List) || (fieldListEntries = (List)fieldObject).size() <= 0) continue;
                for (Object fieldListEntryObject : fieldListEntries) {
                    String fieldListEntry;
                    if (!(fieldListEntryObject instanceof String) || StringUtil.isNullOrEmpty(fieldListEntry = (String)fieldListEntryObject)) continue;
                    if (result == null) {
                        result = new HashSet();
                    }
                    result.add(fieldListEntry);
                }
            }
        }
        return result;
    }
}

