/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexInfo;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.core.resource.response.SimpleGlobalConfigImpl;
import de.virtimo.bpc.core.resource.response.UserSessionBasedModuleConfigImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserSessionBasedGlobalConfigImpl
extends SimpleGlobalConfigImpl {
    private static final Logger LOGGER = LogManager.getLogger(UserSessionBasedGlobalConfigImpl.class);
    protected UserSession userSession;
    protected BpcIndexInfo fromIndex;
    protected boolean embedMetadata;
    protected boolean embedFromIndexInfo;
    protected boolean embedDefaultConfigurations;
    protected boolean onlySettingsMandatoryForFrontend;
    protected boolean embedInstances;
    protected boolean embedInstanceIDs;
    protected boolean embedStorageServiceData;

    public UserSessionBasedGlobalConfigImpl(ModuleManager moduleManager, BpcIndexInfo fromIndex, UserSession userSession, boolean embedInstances, boolean embedInstanceIDs, boolean onlySettingsMandatoryForFrontend, boolean embedMetadata, boolean embedFromIndexInfo, boolean embedDefaultConfigurations, boolean embedStorageServiceData) {
        super(moduleManager);
        this.fromIndex = fromIndex;
        this.userSession = userSession;
        this.onlySettingsMandatoryForFrontend = onlySettingsMandatoryForFrontend;
        this.embedMetadata = embedMetadata;
        this.embedFromIndexInfo = embedFromIndexInfo;
        this.embedDefaultConfigurations = embedDefaultConfigurations;
        this.embedInstances = embedInstances;
        this.embedInstanceIDs = embedInstanceIDs;
        this.embedStorageServiceData = embedStorageServiceData;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getMetadata() throws ServiceNotFoundException {
        if (this.embedMetadata) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("modelVersion", this.moduleManager != null ? this.moduleManager.getModelVersionOfBpcConfigurationIndex() : -1);
            if (this.embedFromIndexInfo) {
                result.put("fromIndex", this.fromIndex);
            }
            return result;
        }
        return null;
    }

    @Override
    public List<ModuleConfig> getModules() {
        LOGGER.debug("getModules");
        ArrayList<ModuleConfig> result = new ArrayList<ModuleConfig>();
        for (Module module : this.moduleManager.getLoadedModules().values()) {
            if (this.userSession == null || !this.userSession.hasLoadModuleRight(module)) continue;
            result.add(new UserSessionBasedModuleConfigImpl(module, this.userSession, this.embedInstances, this.embedInstanceIDs, this.onlySettingsMandatoryForFrontend, this.embedDefaultConfigurations, this.embedStorageServiceData));
        }
        return result;
    }
}

