/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.utils;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.core.BpcActivator;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BpcBundleUtil {
    private static final Logger LOGGER = LogManager.getLogger(BpcBundleUtil.class);

    public static String getBundleFilename(Bundle bundle) {
        String bundleFileLocation;
        LOGGER.debug("getBundleFilename bundle={}", (Object)bundle);
        if (bundle != null && (bundleFileLocation = bundle.getLocation()) != null && bundleFileLocation.startsWith("file:")) {
            try {
                return Paths.get(new URI(bundleFileLocation)).getFileName().toString();
            }
            catch (URISyntaxException ex) {
                LOGGER.error("Failed to extract the bundle filename from: {}", (Object)bundleFileLocation, (Object)ex);
            }
        }
        return null;
    }

    public static Bundle getBundleByFilename(BundleContext bundleContext, String bundleFilename) {
        LOGGER.debug("getBundleByFilename bundleContext=..., bundleFilename={}", (Object)bundleFilename);
        if (bundleContext != null && bundleFilename != null) {
            for (Bundle bundle : bundleContext.getBundles()) {
                if (!bundleFilename.equals(BpcBundleUtil.getBundleFilename(bundle))) continue;
                return bundle;
            }
        }
        return null;
    }

    public static Bundle getBundleBySymbolicName(BundleContext bundleContext, String bundleSymbolicName) {
        LOGGER.debug("getBundleBySymbolicName bundleContext=..., bundleSymbolicName={}", (Object)bundleSymbolicName);
        if (bundleContext != null && bundleSymbolicName != null) {
            for (Bundle bundle : bundleContext.getBundles()) {
                if (!bundleSymbolicName.equals(bundle.getSymbolicName())) continue;
                return bundle;
            }
        }
        return null;
    }

    public static void checkIfBundleWithBadSymbolicName(Bundle bundle) {
        LOGGER.debug("checkIfBundleWithBadSymbolicName bundle={}", (Object)bundle);
        if (bundle != null) {
            List<String> exploded;
            Dictionary headers = bundle.getHeaders();
            String bundleName = (String)headers.get("Bundle-Name");
            String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
            if (!StringUtil.isNullOrEmpty(bundleSymbolicName) && (exploded = StringUtil.explode(bundleSymbolicName, ";")).size() > 1) {
                String errorMessage = "The bundle '" + bundleName + "' = " + bundle + " uses an problematic symbolic name in the META-INF/MANIFEST.MF file. Please let the developer of the module/bundle know that he should remove everything after the semicolon (including): " + bundleSymbolicName;
                System.out.println(errorMessage);
                LOGGER.error(errorMessage);
            }
        }
    }

    public static boolean isBpcBackendBundle(Bundle bundle) {
        LOGGER.debug("isBpcBackendBundle bundle={}", (Object)bundle);
        if (!BpcBundleUtil.isBpcBundle(bundle)) {
            return false;
        }
        String bundleActivatorClassName = BpcBundleUtil.getBundleActivatorClassName(bundle);
        return bundleActivatorClassName != null;
    }

    public static boolean isBpcBackendCoreBundle(Bundle bundle) {
        LOGGER.debug("isBpcBackendCoreBundle bundle={}", (Object)bundle);
        if (!BpcBundleUtil.isBpcBundle(bundle)) {
            return false;
        }
        String bundleActivatorClassName = BpcBundleUtil.getBundleActivatorClassName(bundle);
        return bundleActivatorClassName != null && bundleActivatorClassName.equals(BpcActivator.class.getName());
    }

    public static boolean isBpcBundle(Bundle bundle) {
        LOGGER.debug("isBpcBundle bundle={}", (Object)bundle);
        if (bundle == null) {
            return false;
        }
        Dictionary headers = bundle.getHeaders();
        LOGGER.debug("Bundle: {} - Bundle-Name: {} - BPC-Bundle: {}", (Object)bundle.getBundleId(), headers.get("Bundle-Name"), headers.get("BPC-Bundle"));
        return headers.get("BPC-Bundle") != null;
    }

    public static String getBundleActivatorClassName(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return (String)bundle.getHeaders().get("Bundle-Activator");
    }

    private static String getKarafSpecificCombinedBundleState(BundleContext bundleContext, Bundle bundle) {
        String result = null;
        try (BpcServicesTracker<BundleService> bundleServiceTracker = new BpcServicesTracker<BundleService>(bundleContext, BundleService.class);){
            BundleService bundleService = bundleServiceTracker.getService();
            result = bundleService.getInfo(bundle).getState().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getBundleState(BundleContext bundleContext, Bundle bundle) {
        String karafSpecificCombinedBundleState = BpcBundleUtil.getKarafSpecificCombinedBundleState(bundleContext, bundle);
        if (karafSpecificCombinedBundleState != null) {
            return karafSpecificCombinedBundleState.toUpperCase();
        }
        return switch (bundle.getState()) {
            case 1 -> "UNINSTALLED";
            case 2 -> "INSTALLED";
            case 4 -> "RESOLVED";
            case 8 -> "STARTING";
            case 16 -> "STOPPING";
            case 32 -> "ACTIVE";
            default -> "UNKNOWN";
        };
    }

    public static boolean isBundleInSomeKindOfErrorState(BundleContext bundleContext, Bundle bundle) {
        String state = BpcBundleUtil.getBundleState(bundleContext, bundle);
        return SetUtil.setOf("RESOLVED", "FAILURE").contains(state.toUpperCase());
    }

    public static boolean areAllBpcBundlesInWorkingState(BundleContext bundleContext) {
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!BpcBundleUtil.isBpcBundle(bundle) || !BpcBundleUtil.isBundleInSomeKindOfErrorState(bundleContext, bundle)) continue;
            return false;
        }
        return true;
    }

    public static URL getFileInBundleAtSpecificFolder(Bundle bundle, String folderToLookForFile, String fileName) {
        LOGGER.info("getFileInBundleAtSpecificFolder bundle={}, folderToLookForFile={}, fileName={}", (Object)bundle, (Object)folderToLookForFile, (Object)fileName);
        Set<URL> entries = BpcBundleUtil.getFilesInBundleAtSpecificFolders(bundle, SetUtil.setOf(folderToLookForFile), fileName);
        return entries.isEmpty() ? null : entries.iterator().next();
    }

    public static Set<URL> getFilesInBundleAtSpecificFolders(Bundle bundle, Set<String> foldersToLookForFiles, String filePattern) {
        LOGGER.info("getFilesInBundleAtSpecificFolders bundle={}, foldersToLookForFiles={}, filePattern={}", (Object)bundle, foldersToLookForFiles, (Object)filePattern);
        HashSet<URL> result = new HashSet<URL>();
        if (foldersToLookForFiles != null && !foldersToLookForFiles.isEmpty()) {
            for (String folderToLookForFiles : foldersToLookForFiles) {
                result.addAll(BpcBundleUtil.findEntries(bundle, folderToLookForFiles, filePattern, false));
            }
        }
        return result;
    }

    public static Set<URL> getFilesInBundle(Bundle bundle, String filePattern) {
        LOGGER.info("getFilesInBundle bundle={}, filePattern={}", (Object)bundle, (Object)filePattern);
        HashSet<URL> result = new HashSet<URL>();
        if (!StringUtil.isNullOrEmpty(filePattern)) {
            result.addAll(BpcBundleUtil.findEntries(bundle, "/", filePattern, true));
        }
        return result;
    }

    private static Set<URL> findEntries(Bundle bundle, String path, String filePattern, boolean recurse) {
        Enumeration entries;
        LOGGER.debug("findEntries bundle={}, path={}, filePattern={}, recurse={}", (Object)bundle, (Object)path, (Object)filePattern, (Object)recurse);
        HashSet<URL> result = new HashSet<URL>();
        if (bundle != null && (entries = bundle.findEntries(path, filePattern, recurse)) != null) {
            while (entries.hasMoreElements()) {
                URL fileUrl = (URL)entries.nextElement();
                result.add(fileUrl);
            }
        }
        return result;
    }
}

