/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.auth.ClientSessionImpl;
import de.virtimo.bpc.module.simple.SimpleSettingSerializer;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.service.event.Event;

public class EventUtil {
    private static final Logger LOGGER = LogManager.getLogger(EventUtil.class);

    public static String eventAsJsonString(Event event) throws JsonProcessingException {
        LOGGER.info("eventAsJsonString event={}", (Object)event);
        return EventUtil.eventAsJsonString(event, null, null);
    }

    public static String eventAsJsonString(Event event, UserSession userSession, ModuleManager moduleManager) throws JsonProcessingException {
        LOGGER.info("eventAsJsonString event={}, userSession=..., moduleManager={}", (Object)event, (Object)moduleManager);
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propertyName : event.getPropertyNames()) {
            Object propertyValue = event.getProperty(propertyName);
            if (propertyValue instanceof Module) {
                props.put(propertyName, propertyValue.toString());
                continue;
            }
            if (propertyValue instanceof ClientSessionImpl) {
                ClientSessionImpl clientSession = (ClientSessionImpl)propertyValue;
                props.put(propertyName, clientSession.getSessionId());
                continue;
            }
            props.put(propertyName, propertyValue);
        }
        props.remove("event.topics");
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        eventProps.put("topic", event.getTopic());
        eventProps.put("properties", props);
        ObjectMapper mapper = ObjectMapperPool.createCustomizedObjectMapper();
        if (userSession != null && moduleManager != null) {
            mapper.setConfig(SimpleSettingSerializer.getSerializationConfig(mapper, userSession, moduleManager));
        }
        return mapper.writeValueAsString(eventProps);
    }
}

