/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.flow;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.core.httpproxy.HttpProxyCall;
import de.virtimo.bpc.flow.FlowModuleInstance;
import de.virtimo.bpc.flow.HttpProxyCallConfigFromFlowInstance;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class FlowConnectionTester
implements ConnectionTester {
    private static final Logger LOGGER = LogManager.getLogger(FlowConnectionTester.class);
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public FlowConnectionTester(BundleContext bundleContext) {
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canBeUsedToPerformConnectionTest(ModuleInstance moduleInstance) {
        LOGGER.info("canBeUsedToPerformConnectionTest moduleInstance=...");
        return moduleInstance != null && "flow".equalsIgnoreCase(moduleInstance.getParentModule().getModuleId());
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws ConnectionTestException {
        try {
            HttpProxyCallConfigFromFlowInstance config = new HttpProxyCallConfigFromFlowInstance((FlowModuleInstance)moduleInstance);
            config.addAdditionalHttpHeader("X-BPC-Server-UUID", this.coreBundleConfigurationTracker.getService().getServerUUID());
            HttpProxyCall httpProxyCall = new HttpProxyCall(config);
            httpProxyCall.doConnectionTest(testData);
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }
}

