/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.globalsearch;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.globalsearch.GlobalsearchModule;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;

public class SearchFunctions {
    public static final String indicesAggregationName = "indices";
    public static final String indicesAggregationField = "_index";
    public static final String typesAggregationName = "types";
    public static final String typesAggregationField = "_type";
    private final OpenSearchService openSearchService;

    public SearchFunctions(OpenSearchService openSearchService) {
        this.openSearchService = openSearchService;
    }

    public Boolean existsIndex(String indexName) throws OpenSearchRelatedException {
        return this.openSearchService.existsIndex(indexName);
    }

    public SearchResponse doSearch(String[] indicesArray, Integer start, Integer limit, String query) throws IOException {
        BoolQueryBuilder boolQuery;
        RestHighLevelClient osClient = this.openSearchService.getClient();
        SearchSourceBuilder ssb = new SearchSourceBuilder().from(start).size(limit).aggregation(this.getTermAggregation(indicesAggregationName, indicesAggregationField)).aggregation(this.getTermAggregation(typesAggregationName, typesAggregationField)).trackTotalHitsUpTo((Integer)GlobalsearchModule.getInstance().getConfiguration().getSetting("resultCountLimit").getValue());
        if (query.length() > 0 && (boolQuery = this.getCombinedStringQuery(query)) != null) {
            ssb.query(boolQuery);
        }
        SearchRequest sr = new SearchRequest();
        if (indicesArray != null && indicesArray.length > 0) {
            sr.indices(indicesArray);
        }
        sr.source(ssb);
        return osClient.search(sr, RequestOptions.DEFAULT);
    }

    public HashMap<String, Object> getResponseMapFromSearchResponse(SearchResponse searchResponse) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("total", searchResponse.getHits().getTotalHits().value);
        responseMap.put("took", searchResponse.getTook().getMillis());
        ArrayList results = new ArrayList();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", hit.getId());
            item.put("type", "_doc");
            item.put("index", hit.getIndex());
            item.put("data", hit.getSourceAsMap());
            results.add(item);
        }
        responseMap.put("items", results);
        Terms bucket = (Terms)searchResponse.getAggregations().get(indicesAggregationName);
        Terms typesBucket = (Terms)searchResponse.getAggregations().get(typesAggregationName);
        ArrayList<HashMap<String, Serializable>> aggregations = this.getDataFromTermBucket(bucket, "indexName", "docCount");
        ArrayList<HashMap<String, Serializable>> types = this.getDataFromTermBucket(typesBucket, "typeName", "docCount");
        HashMap<String, ArrayList<HashMap<String, Serializable>>> metaData = new HashMap<String, ArrayList<HashMap<String, Serializable>>>();
        metaData.put(indicesAggregationName, aggregations);
        metaData.put(typesAggregationName, types);
        responseMap.put("meta", metaData);
        return responseMap;
    }

    public String[] getParts(String query, String delimiter) {
        return query.split(delimiter);
    }

    public QueryBuilder getStringQuery(String word) {
        return QueryBuilders.queryStringQuery(word);
    }

    public BoolQueryBuilder getCombinedStringQuery(String query) {
        String[] queryParts;
        BoolQueryBuilder boolQuery = null;
        for (String s : queryParts = this.getParts(query, " ")) {
            QueryBuilder wordQuery = this.getStringQuery(s);
            boolQuery = QueryBuilders.boolQuery().must(wordQuery);
        }
        return boolQuery;
    }

    public ArrayList<HashMap<String, Serializable>> getDataFromTermBucket(Terms bucket, String key, String value) {
        ArrayList<HashMap<String, Serializable>> aggregations = new ArrayList<HashMap<String, Serializable>>();
        for (Terms.Bucket bucket2 : bucket.getBuckets()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(key, bucket2.getKeyAsString());
            map.put(value, bucket2.getDocCount());
            aggregations.add(map);
        }
        return aggregations;
    }

    public TermsAggregationBuilder getTermAggregation(String name, String field) {
        return ((TermsAggregationBuilder)AggregationBuilders.terms(name).field(field)).size(Integer.MAX_VALUE);
    }

    public HashMap<String, Object> getInstancesMap(UserSession session, String[] searchOnlyinModules) {
        String baseModules;
        Object baseModulesString;
        Map<Module, List<ModuleInstance>> modulesAndModuleInstancesForUserSession = GlobalsearchModule.getInstance().getModuleManager().getModulesAndModuleInstancesForUserSession(null, session);
        String[] enabledModules = null;
        GlobalsearchModule gsModule = GlobalsearchModule.getInstance();
        if (gsModule != null && (baseModulesString = gsModule.getConfiguration().getSetting("modules_searchInBaseModules").getValue()) != null && (baseModules = (String)baseModulesString).length() > 0) {
            enabledModules = this.getParts(baseModules, ",");
        }
        if (searchOnlyinModules != null) {
            enabledModules = searchOnlyinModules;
        }
        HashMap<String, Object> searchConfiguration = new HashMap<String, Object>();
        HashMap modules = new HashMap();
        ArrayList<String> indicesStringList = new ArrayList<String>();
        for (Map.Entry<Module, List<ModuleInstance>> entry : modulesAndModuleInstancesForUserSession.entrySet()) {
            Module module = entry.getKey();
            String moduleId = module.getModuleId();
            boolean contains = Arrays.stream(enabledModules).anyMatch(moduleId::equals);
            if (!contains) continue;
            HashMap<String, HashMap<String, Object>> instances = new HashMap<String, HashMap<String, Object>>();
            List<ModuleInstance> moduleInstances = entry.getValue();
            for (ModuleInstance m : moduleInstances) {
                String index;
                if (m == null) continue;
                HashMap<String, Object> searchInstanceConfig = this.getSearchConfigurationForInstanceAndModule(moduleId, m);
                if (searchInstanceConfig != null && searchInstanceConfig.containsKey("index") && (index = (String)searchInstanceConfig.get("index")) != null && index.length() > 0) {
                    indicesStringList.add(index);
                }
                instances.put(m.getModuleId(), searchInstanceConfig);
            }
            modules.put(moduleId, instances);
        }
        searchConfiguration.put("baseModules", modules);
        searchConfiguration.put(indicesAggregationName, indicesStringList);
        return searchConfiguration;
    }

    private HashMap<String, Object> getSearchConfigurationForInstanceAndModule(String moduleId, ModuleInstance mi) {
        String indexKey = "index";
        String idIdentifierKeySimple = "identifierInSource";
        String itemIdKey = "searchDescriptor";
        Object index = null;
        String id = null;
        if (moduleId.equals("webtsm")) {
            String moduleType = mi.getInstanceType();
            if (moduleType.equals("webtsm_module")) {
                String apidId = (String)mi.getConfiguration().getSetting("api_id").getValue();
                if (apidId != null) {
                    index = "webtsm-cache-" + apidId;
                }
            } else if (moduleType.equals("tsm_manager")) {
                String apidId;
                ModuleConfiguration instanceConfiguration;
                String clientInstance = (String)mi.getConfiguration().getSetting("client_instance").getValue();
                InstantiableModule parentModule = mi.getParentModule();
                if (parentModule != null && (instanceConfiguration = parentModule.getInstanceConfiguration(clientInstance)) != null && (apidId = (String)instanceConfiguration.getSetting("api_id").getValue()) != null) {
                    index = "webtsm-cache-" + apidId;
                }
            }
            if (index != null) {
                id = "ID";
            }
        } else if (moduleId.equals("monitor")) {
            index = (String)mi.getConfiguration().getSetting("data_index").getValue();
            id = (String)mi.getConfiguration().getSetting("column_id").getValue();
        } else if (moduleId.equals("collaboration")) {
            index = "collaboration-artefacts";
            id = "_id";
        }
        if (index != null && id != null) {
            HashMap<String, String> itemIdentification = new HashMap<String, String>();
            itemIdentification.put("identifierInSource", id);
            HashMap<String, Object> searchConfigPerInstance = new HashMap<String, Object>();
            searchConfigPerInstance.put("index", index);
            searchConfigPerInstance.put("searchDescriptor", itemIdentification);
            return searchConfigPerInstance;
        }
        return null;
    }
}

