/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.globalsearch.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.globalsearch.SearchFunctions;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.osgi.framework.BundleContext;

@Path(value="search")
@Tag(name="Global Search API", description="These are the endpoints for the global search frontend.")
public class Search {
    private static final Logger LOGGER = LogManager.getLogger(Search.class);
    private BundleContext bundleContext;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public Search(BundleContext bundleContext) {
        LOGGER.info("Search bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @Produces(value={"application/json"})
    @GET
    @BpcUserSessionRequired
    @Path(value="/{instanceId}/search")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Performs a search over multiple indices and modules.", description="Performs a search over multiple indices and modules.")
    @ReturnDescription(value="The response for the global search.")
    public Response search(@Parameter(description="the query to perform the search for") @DefaultValue(value="") @QueryParam(value="query") String query, @Parameter(description="first record to be read (optional, default = 0)") @DefaultValue(value="0") @QueryParam(value="start") Integer start, @Parameter(description="number of records to read (optional, default = 100, max. 10.000)") @DefaultValue(value="100") @QueryParam(value="limit") Integer limit, @Parameter(description="to limit the search only to those specific indices (separate multiple values with a comma)") @QueryParam(value="indices") String indices, @Parameter(description="to search only in the OpenSearch indices of these modules (separate multiple values with a comma)") @QueryParam(value="modules") String modules, @Parameter(description="the id of the related global search instance") @PathParam(value="instanceId") String instanceId, @Parameter(description="flag to perform a search on the bpc-configuration index. Get used only for users with the 'bpcadmin' role (optional, default = false)") @DefaultValue(value="false") @QueryParam(value="adminSearch") String adminSearch, @Context UserSession userSession) {
        LOGGER.info("search query={}, start={}, limit={}, indices={}, modules={}, instanceId={}, adminSearch={}", (Object)query, (Object)start, (Object)limit, (Object)indices, (Object)modules, (Object)instanceId, (Object)adminSearch);
        try {
            SearchFunctions searchFunctions = new SearchFunctions(this.openSearchServiceTracker.getService());
            start = start < 0 ? 0 : start;
            limit = limit < 0 ? 100 : limit;
            boolean searchInBpcConfiguration = false;
            String[] indicesStringArray = null;
            HashMap<String, Object> searchConfig = null;
            if (adminSearch.equals("true") && userSession.hasRole("bpcadmin")) {
                searchInBpcConfiguration = true;
                indicesStringArray = new String[]{"bpc-configuration"};
            }
            if (!searchInBpcConfiguration) {
                String[] searchOnlyInModules = null;
                if (modules != null && modules.length() > 0) {
                    searchOnlyInModules = searchFunctions.getParts(modules, ",");
                }
                searchConfig = searchFunctions.getInstancesMap(userSession, searchOnlyInModules);
                boolean limitedSearch = false;
                if (indices != null && indices.length() > 0) {
                    indicesStringArray = searchFunctions.getParts(indices, ",");
                    limitedSearch = true;
                }
                Object indicesMap = searchConfig.get("indices");
                ArrayList indicesStringList = (ArrayList)indicesMap;
                ArrayList<String> existingIndices = new ArrayList<String>();
                ArrayList<String> notExistingIndices = new ArrayList<String>();
                for (Object o : indicesStringList) {
                    String index = (String)o;
                    if (index == null) continue;
                    if (searchFunctions.existsIndex(index).booleanValue()) {
                        if (limitedSearch) {
                            boolean contains = Arrays.stream(indicesStringArray).anyMatch(index::equals);
                            if (contains) {
                                existingIndices.add(index);
                                continue;
                            }
                            LOGGER.info("{} excluded - not defined as query param", (Object)index);
                            continue;
                        }
                        existingIndices.add(index);
                        continue;
                    }
                    notExistingIndices.add(index);
                }
                searchConfig.put("indicesUsed", existingIndices);
                searchConfig.put("indicesExcluded", notExistingIndices);
                indicesStringArray = existingIndices.toArray(new String[0]);
            }
            SearchResponse searchResponse = searchFunctions.doSearch(indicesStringArray, start, limit, query);
            HashMap<String, Object> responseMap = searchFunctions.getResponseMapFromSearchResponse(searchResponse);
            responseMap.put("searchConfiguration", searchConfig);
            return Response.ok(responseMap, (String)"application/json").build();
        }
        catch (Exception ex) {
            LOGGER.error("Performing the global search failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

