/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.jaxrs;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcHardcodedBasicAuthentication;
import de.virtimo.bpc.jaxrs.BpcRightRequired;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcRoleRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.util.AsciiDocToMarkdownUtil;
import de.virtimo.bpc.util.StringUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;
import org.apache.cxf.jaxrs.openapi.OpenApiFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class BpcOpenApiCustomizer
extends OpenApiCustomizer {
    private static final Logger LOGGER = LogManager.getLogger(BpcOpenApiCustomizer.class);
    private final String jaxrsServerPrefix;
    private final String serverDescription;
    private final OpenApiFeature openApiFeature;
    private BundleContext bundleContext = null;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private HashMap<String, List<Class<?>>> tagClassMap;
    private boolean isEndpointDecorationDone = false;
    public static final String ERR_NO_BPC_AUTH_ANNOTATION = "The endpoint does not have any Bpc-Authentication annotation. Use at least @BpcEndpoint.";
    public static final String ERR_MORE_THAN_ONE_BPC_AUTH_ANNOTATION = "The endpoint uses multiple Bpc-Authentication annotations. This is not supported.";
    public static final String ERR_ENDPOINT_FOR_OPENAPI_OPERATION_NOT_FOUND = "No endpoint method found for OpenApi operation.\\nMaybe the OpenApiFeature is not configured correctly in the blueprint context.xml?";
    public static final String ERR_AMBIGUOUS_ENDPOINT_MATCH = "Multiple endpoint methods match the openapi operation";
    private static final String DESC_AUTH_TITLE_MARKDOWN = "Authentication";
    private static final String DESC_AUTH_USER_SESSION_NEEDED = "A session cookie or API key is needed.";
    private static final String DESC_AUTH_USER_SESSION_ROLE_NEEDED = "A session cookie or API key with role '%s' is needed.";
    private static final String DESC_AUTH_USER_SESSION_RIGHT_NEEDED = "A session cookie or API key with right '%s' is needed.";
    private static final String DESC_AUTH_USER_SESSION_ROLE_OR_RIGHT_NEEDED = "A session cookie or API key with role '%s' or right '%s' is needed.";

    public BpcOpenApiCustomizer(BundleContext bundleContext, OpenApiFeature openApiFeature, String jaxrsServerPrefix, String serverDescription) {
        LOGGER.info("BpcOpenApiCustomizer bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
        this.openApiFeature = openApiFeature;
        this.jaxrsServerPrefix = jaxrsServerPrefix;
        this.serverDescription = serverDescription;
        this.initTagClassMap();
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll((Object)this);
    }

    public void customize(OpenAPI oas) {
        if (!this.isEndpointDecorationDone) {
            this.customizeEndpointDecoration(oas);
            this.isEndpointDecorationDone = true;
        }
        this.customizeServerURLs(oas);
    }

    private void customizeServerURLs(OpenAPI oas) {
        String bpcBaseUrl;
        List servers = oas.getServers();
        if (servers != null && !servers.isEmpty()) {
            servers.clear();
        }
        if (StringUtil.isNullOrEmpty(bpcBaseUrl = this.getBpcBaseUrl())) {
            bpcBaseUrl = "/";
        }
        String serverUrl = StringUtil.glue(StringUtil.glue(bpcBaseUrl, "cxf", '/'), this.jaxrsServerPrefix, '/');
        Server oaServer = new Server();
        oaServer.setUrl(serverUrl);
        if (!StringUtil.isNullOrEmpty(this.serverDescription)) {
            oaServer.setDescription(this.serverDescription);
        }
        oas.addServersItem(oaServer);
    }

    private void customizeEndpointDecoration(OpenAPI oas) {
        Paths paths = oas.getPaths();
        if (paths == null) {
            return;
        }
        paths.forEach(this::updateOperationsForPathItem);
    }

    private void updateOperationsForPathItem(String path, PathItem pathItem) {
        this.updateOperationInfo(path, pathItem.getGet(), GET.class);
        this.updateOperationInfo(path, pathItem.getPost(), POST.class);
        this.updateOperationInfo(path, pathItem.getPut(), PUT.class);
        this.updateOperationInfo(path, pathItem.getDelete(), DELETE.class);
        this.updateOperationInfo(path, pathItem.getHead(), HEAD.class);
        this.updateOperationInfo(path, pathItem.getOptions(), OPTIONS.class);
        this.updateOperationInfo(path, pathItem.getPatch(), PATCH.class);
    }

    private void updateOperationInfo(String path, Operation swaggerOperation, Class<? extends Annotation> httpAnnotClass) {
        if (swaggerOperation == null) {
            return;
        }
        Method method = this.getEndpointMethod(path, swaggerOperation, httpAnnotClass);
        if (method == null) {
            LOGGER.error("No endpoint method found for OpenApi operation.\\nMaybe the OpenApiFeature is not configured correctly in the blueprint context.xml? - Path: {} {}", (Object)httpAnnotClass.getSimpleName(), (Object)path);
            return;
        }
        this.updateOperationDescription(swaggerOperation, method);
        this.decorateEndpointAuthInfo(swaggerOperation, method);
    }

    private void updateOperationDescription(Operation swaggerOperation, Method opMethod) {
        String description;
        OperationDescription descriptionAnnotation = opMethod.getAnnotation(OperationDescription.class);
        if (descriptionAnnotation == null) {
            return;
        }
        String summary = descriptionAnnotation.summary();
        if (!StringUtil.isNullOrEmpty(summary)) {
            swaggerOperation.setSummary(summary);
        }
        if (!StringUtil.isNullOrEmpty(description = descriptionAnnotation.description())) {
            String markdownDescription = AsciiDocToMarkdownUtil.convertToMarkdown(description);
            swaggerOperation.setDescription(markdownDescription);
        }
    }

    private void decorateEndpointAuthInfo(Operation swaggerOperation, Method opMethod) {
        SecurityRequirement authRequirement = new SecurityRequirement();
        authRequirement.addList("apiKey");
        int nAuthAnnotations = 0;
        if (opMethod.isAnnotationPresent(BpcUserSessionRequired.class)) {
            swaggerOperation.addSecurityItem(authRequirement);
            this.extendOperationDescription(swaggerOperation, DESC_AUTH_USER_SESSION_NEEDED, DESC_AUTH_TITLE_MARKDOWN);
            ++nAuthAnnotations;
        }
        if (opMethod.isAnnotationPresent(BpcRoleRequired.class)) {
            BpcRoleRequired roleAnnot = opMethod.getAnnotation(BpcRoleRequired.class);
            swaggerOperation.addSecurityItem(authRequirement);
            swaggerOperation.addExtension("x-bpc-auth-role-needed", (Object)roleAnnot.role());
            this.extendOperationDescription(swaggerOperation, String.format(DESC_AUTH_USER_SESSION_ROLE_NEEDED, roleAnnot.role()), DESC_AUTH_TITLE_MARKDOWN);
            ++nAuthAnnotations;
        }
        if (opMethod.isAnnotationPresent(BpcRightRequired.class)) {
            BpcRightRequired rightAnnot = opMethod.getAnnotation(BpcRightRequired.class);
            swaggerOperation.addSecurityItem(authRequirement);
            swaggerOperation.addExtension("x-bpc-auth-right-needed", (Object)rightAnnot.right());
            this.extendOperationDescription(swaggerOperation, String.format(DESC_AUTH_USER_SESSION_RIGHT_NEEDED, rightAnnot.right()), DESC_AUTH_TITLE_MARKDOWN);
            ++nAuthAnnotations;
        }
        if (opMethod.isAnnotationPresent(BpcRoleOrRightRequired.class)) {
            BpcRoleOrRightRequired roleOrRightAnnot = opMethod.getAnnotation(BpcRoleOrRightRequired.class);
            swaggerOperation.addSecurityItem(authRequirement);
            HashMap<String, String> roleRightHashMap = new HashMap<String, String>();
            roleRightHashMap.put("role", roleOrRightAnnot.role());
            roleRightHashMap.put("right", roleOrRightAnnot.right());
            swaggerOperation.addExtension("x-bpc-auth-right-or-role-needed", roleRightHashMap);
            this.extendOperationDescription(swaggerOperation, String.format(DESC_AUTH_USER_SESSION_ROLE_OR_RIGHT_NEEDED, roleOrRightAnnot.role(), roleOrRightAnnot.right()), DESC_AUTH_TITLE_MARKDOWN);
            ++nAuthAnnotations;
        }
        if (opMethod.isAnnotationPresent(BpcHardcodedBasicAuthentication.class)) {
            ++nAuthAnnotations;
        }
        if (opMethod.isAnnotationPresent(BpcEndpoint.class)) {
            ++nAuthAnnotations;
        }
        if (nAuthAnnotations == 0) {
            LOGGER.error("The endpoint does not have any Bpc-Authentication annotation. Use at least @BpcEndpoint. - Method: {}", (Object)opMethod.getName());
        } else if (nAuthAnnotations > 1) {
            LOGGER.error("The endpoint uses multiple Bpc-Authentication annotations. This is not supported. - Method: {}", (Object)opMethod.getName());
        }
    }

    private void extendOperationDescription(Operation swaggerOperation, String additionalDescription, String title) {
        Object opDescription = swaggerOperation.getDescription();
        if (StringUtil.isNullOrEmpty((String)opDescription)) {
            swaggerOperation.setDescription(additionalDescription);
            return;
        }
        Object textToAdd = StringUtil.isNullOrEmpty(title) ? additionalDescription : "**" + title.trim() + "**\n\n" + additionalDescription;
        opDescription = (String)opDescription + "\n\n" + (String)textToAdd;
        swaggerOperation.setDescription((String)opDescription);
    }

    private Method getEndpointMethod(String path, Operation swaggerOperation, Class<? extends Annotation> httpAnnotClass) {
        String tagName;
        List<Class<?>> classes;
        if (swaggerOperation == null) {
            return null;
        }
        List opTagList = swaggerOperation.getTags();
        if (opTagList == null || opTagList.isEmpty()) {
            return null;
        }
        if (opTagList.size() > 2) {
            LOGGER.warn("The operation '{}' has defined more than one tag. Only the first is considered to find the corresponding method.", (Object)swaggerOperation.getOperationId());
        }
        if ((classes = this.tagClassMap.get(tagName = (String)opTagList.get(0))) == null || classes.isEmpty()) {
            return null;
        }
        for (Class<?> clazz : classes) {
            try {
                Method[] methods;
                Path pathAnnot = clazz.getAnnotation(Path.class);
                String classPath = pathAnnot != null ? pathAnnot.value() : "/";
                Method method = this.findEndpointMethodFromClass(path, classPath, methods = clazz.getDeclaredMethods(), swaggerOperation.getOperationId(), httpAnnotClass);
                if (method == null) continue;
                return method;
            }
            catch (Exception ex) {
                LOGGER.warn("Class not found: {}", (Object)ex.getMessage());
            }
        }
        return null;
    }

    private Method findEndpointMethodFromClass(String operationPath, String classPath, Method[] methods, String methodName, Class<? extends Annotation> httpAnnotClass) throws Exception {
        String finalClassPath = StringUtil.glue("/", classPath, '/');
        String finalOperationPath = StringUtil.glue("/", operationPath, '/');
        List<Method> methodMatches = Arrays.stream(methods).filter(m -> m.getAnnotation(httpAnnotClass) != null).filter(m -> {
            Path mPath = m.getAnnotation(Path.class);
            String methodPathValue = mPath != null ? BpcOpenApiCustomizer.simplifyPathValues(mPath.value()) : "/";
            return StringUtil.glue(finalClassPath, methodPathValue, '/').equals(finalOperationPath);
        }).toList();
        if (methodMatches.size() > 1) {
            LOGGER.error("Multiple endpoint methods match the openapi operation - Path: {}", (Object)operationPath);
            throw new Exception(String.format("Ambiguous method matches for Operation %s ('%s').", operationPath, methodName));
        }
        return methodMatches.isEmpty() ? null : methodMatches.get(0);
    }

    private static String simplifyPathValues(String input) {
        Pattern pattern = Pattern.compile("\\{(\\w+): [^{}\\n\\r]*\\}");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, "{" + matcher.group(1) + "}");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private void initTagClassMap() {
        this.tagClassMap = new HashMap();
        Set classNames = this.openApiFeature.getResourceClasses();
        if (classNames == null) {
            return;
        }
        for (String className : classNames) {
            try {
                Class<?> clazz = Class.forName(className);
                for (Tag tag : (Tag[])clazz.getAnnotationsByType(Tag.class)) {
                    String tagName = tag.name();
                    if (StringUtil.isNullOrEmpty(tagName)) continue;
                    if (!this.tagClassMap.containsKey(tagName)) {
                        this.tagClassMap.put(tagName, new ArrayList());
                    }
                    this.tagClassMap.get(tagName).add(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Cannot find class {} registered in OpenAPI feature for {}", (Object)className, (Object)this.jaxrsServerPrefix);
            }
        }
    }

    private String convertToMarkdownDescription(String description) {
        return description;
    }

    private String getBpcBaseUrl() {
        try {
            CoreModule coreModule = this.getCoreModule();
            return coreModule.getBpcFrontendUrl();
        }
        catch (ModuleNotFoundException | ServiceNotFoundException e) {
            LOGGER.error("Exception while getting Core Module", (Throwable)e);
            return "";
        }
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
    }
}

