/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import de.virtimo.bpc.api.AbstractRestoreBackupDoneEventHandler;
import de.virtimo.bpc.api.AbstractRestoreBackupStartEventHandler;
import de.virtimo.bpc.api.AbstractServerModeChangedEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoinUpdaterData;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsException;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.logservice.LogDataResult;
import de.virtimo.bpc.logservice.LogService;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.db.DatabaseLogService;
import de.virtimo.bpc.logservice.opensearch.OpenSearchLogService;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.logservice.resource.LogDataEntries;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionEntryDTO;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LogServiceModule
extends AbstractInstantiableModule {
    private static final Logger LOGGER = LogManager.getLogger(LogServiceModule.class);
    public static final String MODULE_ID = "logservice";
    private static final String BACKUP_JOB_PREFIX = "core:logservice:";
    public static final String DEFAULT_LOG_SERVICE_INDICES_BACKUP_SETTING_NAME = "defaultLogServiceIndicesBackup";
    public static final String CLIENT_CERTIFICATE_AUTH_MANDATORY = "clientCertificateAuthMandatory";
    public static final String MAX_RESULT_WINDOW = "es_data_view_limit";
    public static final String MAX_DATA_COUNT = "es_data_count_limit";
    private final ExecutorService loggingExecutorService;
    private final Set<String> indicesTemporaryUnavailable;
    private static final Object INDICES_TEMPORARY_UNAVAILABLE_LOCK = new Object();
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private BpcServicesTracker<BackupManager> backupManagerTracker;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private BpcServicesTracker<LookupJoinsManager> lookupJoinsManagerTracker;
    private final EventRegistration eventRegistration;
    private Setting defaultLogServiceIndicesBackupSetting;

    public LogServiceModule(ModuleManager moduleManager, Setting defaultLogServiceIndicesBackupSetting) {
        super(moduleManager);
        this.defaultLogServiceIndicesBackupSetting = defaultLogServiceIndicesBackupSetting;
        this.loggingExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-logservice"));
        this.indicesTemporaryUnavailable = new HashSet<String>();
        this.eventRegistration = new EventRegistration(null);
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BundleContext bundleContext = moduleBundle.getBundleContext();
        BpcServicesTracker.stopAll(this);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.lookupJoinsManagerTracker = new BpcServicesTracker<LookupJoinsManager>(bundleContext, LookupJoinsManager.class);
        this.eventRegistration.setBundleContext(bundleContext);
        this.eventRegistration.forModuleUpdatedEvents("_core", DEFAULT_LOG_SERVICE_INDICES_BACKUP_SETTING_NAME, new DefaultLogServiceIndicesBackupSettingUpdatedEventHandler());
        this.eventRegistration.forRestoreBackupStartEvents(new RestoreBackupStartEventHandler());
        this.eventRegistration.forRestoreBackupDoneEvents(new RestoreBackupDoneEventHandler());
        this.eventRegistration.forServerModeChangedEvents(new MasterOrSlaveModeChangedEventHandler());
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        super.destroy();
        if (this.loggingExecutorService != null) {
            this.loggingExecutorService.shutdown();
        }
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/logservice/default_module_settings.json").build();
    }

    @Override
    public String getModuleId() {
        return MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return "Log Service";
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/logservice/default_instance_settings.json").build();
    }

    @Override
    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        return LogServiceModuleInstance.class;
    }

    public void clearLookupJoinCaches() {
        LOGGER.info("clearLookupJoinCaches");
        Map<String, ModuleInstance> logServiceModuleInstances = this.getModuleInstances();
        for (ModuleInstance moduleInstance : logServiceModuleInstances.values()) {
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
            logServiceModuleInstance.getLookupJoins().clearCaches();
        }
    }

    public void refreshLookupJoins(String logServiceId) throws InterruptedException, ModuleInstanceNotFoundException, LookupJoinsException, ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("refreshLookupJoins logServiceId={}", (Object)logServiceId);
        LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)this.getModuleInstanceById(logServiceId);
        if (!logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_OPENSEARCH_LOGGING_DISABLED, "Lookup joins refresh failed. The Log Service with the ID '${logServiceId}' does not use OpenSearch logging.", MapUtil.mapOf("logServiceId", logServiceId));
        }
        LookupJoins lookupJoins = logServiceModuleInstance.getLookupJoins();
        if (!lookupJoins.hasEntries()) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_SETTING_INVALID, "Lookup joins refresh failed. The Log Service with the ID '${logServiceId}' has no lookup joins.", MapUtil.mapOf("logServiceId", logServiceId));
        }
        LookupJoinsManager lookupJoinsManager = this.lookupJoinsManagerTracker.getService();
        try {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
            if (openSearchConfig.parent != null) {
                LookupJoinUpdaterData parentUpdaterData = new LookupJoinUpdaterData(openSearchConfig.parent.index, lookupJoins, lookupJoins.getKeyFields());
                lookupJoinsManager.refreshLookupJoins(parentUpdaterData);
            }
            if (openSearchConfig.child != null) {
                LookupJoinUpdaterData childUpdaterData = new LookupJoinUpdaterData(openSearchConfig.child.index, lookupJoins, lookupJoins.getKeyFields());
                lookupJoinsManager.refreshLookupJoins(childUpdaterData);
            }
        }
        catch (LogServiceSettingsException ex) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_SETTING_INVALID, "Lookup joins refresh failed. The OpenSearch settings of the Log Service with the ID '${instanceId}' are invalid.", MapUtil.mapOf("instanceId", logServiceId), (Throwable)ex);
        }
    }

    public void refreshAllLookupJoins() throws LookupJoinsException, ServiceNotFoundException, OpenSearchRelatedException, InterruptedException {
        LOGGER.info("refreshAllLookupJoins");
        ArrayList<LookupJoinUpdaterData> updaterDatas = new ArrayList<LookupJoinUpdaterData>();
        for (ModuleInstance moduleInstance : this.getModuleInstances().values()) {
            LookupJoins lookupJoins;
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
            if (!logServiceModuleInstance.isOpenSearchLoggingEnabled() || !(lookupJoins = logServiceModuleInstance.getLookupJoins()).hasEntries()) continue;
            try {
                LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
                boolean childProcessingEnabled = openSearchConfig.child != null;
                LookupJoinUpdaterData parentUpdaterData = new LookupJoinUpdaterData(openSearchConfig.parent.index, lookupJoins, lookupJoins.getKeyFields());
                updaterDatas.add(parentUpdaterData);
                if (!childProcessingEnabled) continue;
                LookupJoinUpdaterData childUpdaterData = new LookupJoinUpdaterData(openSearchConfig.child.index, lookupJoins, lookupJoins.getKeyFields());
                updaterDatas.add(childUpdaterData);
            }
            catch (LogServiceSettingsException ex) {
                throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_SETTING_INVALID, "Lookup joins refresh failed. The OpenSearch settings of the Log Service with the ID '${instanceId}' are invalid.", MapUtil.mapOf("instanceId", logServiceModuleInstance.getModuleId()), (Throwable)ex);
            }
        }
        if (!updaterDatas.isEmpty()) {
            LookupJoinsManager lookupJoinsManager = this.lookupJoinsManagerTracker.getService();
            for (LookupJoinUpdaterData updaterData : updaterDatas) {
                lookupJoinsManager.refreshLookupJoins(updaterData);
            }
        }
    }

    public synchronized void restartBackupJobs() {
        LOGGER.info("restartBackupJobs");
        try {
            ArrayList<BackupJobScheduleActionEntryDTO> backupJobEntries = new ArrayList<BackupJobScheduleActionEntryDTO>();
            Map<String, ModuleInstance> logServiceModuleInstances = this.getModuleInstances();
            for (ModuleInstance moduleInstance : logServiceModuleInstances.values()) {
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
                if (openSearchConfig == null) continue;
                BackupSetting backupSetting = this.createBackupSetting(openSearchConfig);
                BackupJobScheduleActionEntryDTO backupJobEntry = new BackupJobScheduleActionEntryDTO(BACKUP_JOB_PREFIX + backupSetting.getIndicesToBackupNamesAsKey(), BackupSetting.asMap(backupSetting));
                backupJobEntries.add(backupJobEntry);
            }
            if (!backupJobEntries.isEmpty()) {
                this.backupManagerTracker.getService().scheduleBackupJobs(backupJobEntries);
            }
        }
        catch (LogServiceSettingsException ex) {
            LOGGER.warn("Ignoring log service backup exception.", (Throwable)ex);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Cannot schedule a log service backup job without the BackupManager");
        }
        catch (JsonGenerationException ex) {
            LOGGER.error("Cannot schedule a log service backup jobs due to JSON generation exception.", (Throwable)ex);
        }
    }

    public synchronized void restartBackupJob(LogServiceModuleInstance logServiceModuleInstance) {
        try {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
            if (openSearchConfig != null) {
                BackupSetting backupSetting = this.createBackupSetting(openSearchConfig);
                BackupJobScheduleActionEntryDTO backupJobEntry = new BackupJobScheduleActionEntryDTO(BACKUP_JOB_PREFIX + backupSetting.getIndicesToBackupNamesAsKey(), BackupSetting.asMap(backupSetting));
                this.backupManagerTracker.getService().scheduleBackupJobs(List.of(backupJobEntry));
            }
        }
        catch (LogServiceSettingsException ex) {
            LOGGER.warn("Ignoring log service backup exception.", (Throwable)ex);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Cannot schedule a log service backup job without the BackupManager");
        }
        catch (JsonGenerationException ex) {
            LOGGER.error("Cannot schedule a log service backup job due to JSON generation exception.", (Throwable)ex);
        }
    }

    private BackupSetting createBackupSetting(LogServiceModuleInstance.OpenSearchConfig openSearchConfig) {
        boolean childProcessingEnabled;
        boolean bl = childProcessingEnabled = openSearchConfig.child != null;
        if (childProcessingEnabled) {
            return BackupSettingFactory.createFrom(this.defaultLogServiceIndicesBackupSetting, SetUtil.setOf(openSearchConfig.parent.index, openSearchConfig.child.index));
        }
        return BackupSettingFactory.createFrom(this.defaultLogServiceIndicesBackupSetting, SetUtil.setOf(openSearchConfig.parent.index));
    }

    private DatabaseLogService createDatabaseLogService(LogServiceModuleInstance moduleInstance) throws LogServiceException {
        try {
            return new DatabaseLogService(this.databaseManagerTracker.getService(), moduleInstance.getDatabaseTableDataCache());
        }
        catch (ServiceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MISSING_SERVICE, "The DatabaseManager service is missing.", ex);
        }
    }

    private OpenSearchLogService createOpenSearchLogService() throws LogServiceException {
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            Map<String, Object> defaultIndexCreationSettings = oss.getDefaultIndexCreationSettings();
            List defaultDynamicTemplates = oss.getDefaultDynamicTemplates();
            return new OpenSearchLogService(oss, this.percolatorsManagerTracker.getService(), defaultIndexCreationSettings, defaultDynamicTemplates);
        }
        catch (ServiceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MISSING_SERVICE, "Either the OpenSearch or the PercolatorsManager service is missing.", ex);
        }
    }

    public void deleteChildEntries(LogServiceModuleInstance moduleInstance, String parentId, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        OpenSearchLogService logService;
        FutureTask<Exception> informClientsFutureTask;
        LOGGER.info("deleteChildEntries moduleInstance={}, parentId={}, timeZoneId={}, childQuery={}, childFilter={}", (Object)moduleInstance, (Object)parentId, (Object)timeZoneId, (Object)childQuery, (Object)childFilter);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            // empty if block
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteChildData(moduleInstance, parentId, timeZoneId, childQuery, childFilter)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteChildEntries(LogServiceModuleInstance moduleInstance, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        OpenSearchLogService logService;
        FutureTask<Exception> informClientsFutureTask;
        LOGGER.info("deleteChildEntries moduleInstance={}, timeZoneId={}, childQuery={}, childFilter={}", (Object)moduleInstance, (Object)timeZoneId, (Object)childQuery, (Object)childFilter);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            // empty if block
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteChildData(moduleInstance, timeZoneId, childQuery, childFilter)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteEntries(LogServiceModuleInstance moduleInstance, String timeZoneId, String parentQuery, String parentFilter) throws LogServiceException {
        OpenSearchLogService logService;
        FutureTask<Exception> informClientsFutureTask;
        LOGGER.info("deleteEntries moduleInstance={}, timeZoneId={}, parentQuery={}, parentFilter={}", (Object)moduleInstance, (Object)timeZoneId, (Object)parentQuery, (Object)parentFilter);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            // empty if block
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteData(moduleInstance, timeZoneId, parentQuery, parentFilter)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteEntries(LogServiceModuleInstance moduleInstance, List<String> parentIDs) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOGGER.info("deleteEntries moduleInstance={}, parentIDs={}", (Object)moduleInstance, parentIDs);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.deleteData(moduleInstance, parentIDs);
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteData(moduleInstance, parentIDs)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteChildEntries(LogServiceModuleInstance moduleInstance, String parentId, List<String> childIDs) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOGGER.info("deleteChildEntries moduleInstance={}, parentId={}, childIDs={}", (Object)moduleInstance, (Object)parentId, childIDs);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.deleteChildData(moduleInstance, parentId, childIDs);
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteChildData(moduleInstance, parentId, childIDs)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void log(boolean async, final LogServiceModuleInstance moduleInstance, final LogData logData, final ExternalReferenceData externalReferenceData) throws LogServiceException {
        LOGGER.info("log async={}, moduleInstance={}, logData=..., externalReferenceData=...", (Object)async, (Object)moduleInstance);
        if (logData == null || logData.isEmpty()) {
            throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No data to log given");
        }
        if (async) {
            FutureTask<LogDataResult> logDataFutureTask = new FutureTask<LogDataResult>(new Callable<LogDataResult>(){

                @Override
                public LogDataResult call() {
                    try {
                        return LogServiceModule.this.logData(moduleInstance, logData, externalReferenceData);
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        return null;
                    }
                }
            });
            this.loggingExecutorService.execute(logDataFutureTask);
        } else {
            this.logData(moduleInstance, logData, externalReferenceData);
        }
    }

    private LogDataResult logData(LogServiceModuleInstance moduleInstance, LogData logData, ExternalReferenceData externalReferenceData) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOGGER.info("logData moduleInstance={}, logData=..., externalReferenceData=...", (Object)moduleInstance);
        LOGGER.debug("OS logging enabled:{}", (Object)moduleInstance.isOpenSearchLoggingEnabled());
        LOGGER.debug("DB logging enabled:{}", (Object)moduleInstance.isDatabaseLoggingEnabled());
        ZonedDateTime currentDateTime = ZonedDateTime.now();
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.logData(moduleInstance, currentDateTime, logData, externalReferenceData);
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).logData(moduleInstance, currentDateTime, logData, externalReferenceData)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
        return new LogDataResult();
    }

    public List<LogServiceModuleInstance> getLogServicesUsingTargetIndexAliases(Set<String> aliases) throws LogServiceSettingsException {
        ArrayList<LogServiceModuleInstance> result = new ArrayList<LogServiceModuleInstance>();
        for (ModuleInstance moduleInstance : this.getModuleInstances().values()) {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig;
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
            if (!logServiceModuleInstance.isOpenSearchLoggingEnabled() || (openSearchConfig = logServiceModuleInstance.getOpenSearchConfig()) == null) continue;
            boolean found = false;
            if (openSearchConfig.parent != null && !StringUtil.isNullOrEmpty(openSearchConfig.parent.index) && aliases.contains(openSearchConfig.parent.index)) {
                found = true;
            }
            if (openSearchConfig.child != null && !StringUtil.isNullOrEmpty(openSearchConfig.child.index) && aliases.contains(openSearchConfig.child.index)) {
                found = true;
            }
            if (!found) continue;
            result.add(logServiceModuleInstance);
        }
        return result;
    }

    public void updateOpenSearchIndexMappings(LogServiceModuleInstance logServiceModuleInstance) {
        LOGGER.info("updateOpenSearchIndexMappings logServiceModuleInstance=...");
        try {
            OpenSearchLogService openSearchLogService = this.createOpenSearchLogService();
            openSearchLogService.updateOpenSearchIndexMappings(logServiceModuleInstance);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to update the OpenSearch index mapping of the log service module instance: " + logServiceModuleInstance, (Throwable)ex);
        }
    }

    public LogDataEntries getLogDataEntries(LogServiceModuleInstance logServiceModuleInstance, String timeZoneId, Integer start, Integer limit, String parentQuery, String parentFilter, String parentSort, String childSort, boolean addChilds) throws LogServiceException {
        LOGGER.info("getLogDataEntries logServiceModuleInstance=..., timeZoneId={}, start={}, limit={}, parentQuery={}, parentFilter={}, parentSort={}, childSort={}, addChilds={}", (Object)timeZoneId, (Object)start, (Object)limit, (Object)parentQuery, (Object)parentFilter, (Object)parentSort, (Object)childSort, (Object)addChilds);
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            OpenSearchLogService logService = this.createOpenSearchLogService();
            return logService.getLogDataEntries(this, logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, childSort, addChilds);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogDataEntries(this, logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, childSort, addChilds);
        }
        return null;
    }

    public LogDataEntries getLogDataEntries(LogServiceModuleInstance logServiceModuleInstance, String parentId) throws LogServiceException {
        LOGGER.info("getLogDataEntries logServiceModuleInstance=..., parentId={}", (Object)parentId);
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            OpenSearchLogService logService = this.createOpenSearchLogService();
            return logService.getLogDataEntries(logServiceModuleInstance, parentId);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogDataEntries(logServiceModuleInstance, parentId);
        }
        return null;
    }

    public LogDataEntries getLogDataEntries(LogServiceModuleInstance logServiceModuleInstance, String parentId, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        LOGGER.info("getLogDataEntries logServiceModuleInstance=..., parentId={}, timeZoneId={}, childQuery={}, childFilter={}", (Object)parentId, (Object)timeZoneId, (Object)childQuery, (Object)childFilter);
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            OpenSearchLogService logService = this.createOpenSearchLogService();
            return logService.getLogDataEntries(logServiceModuleInstance, parentId, timeZoneId, childQuery, childFilter);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogDataEntries(logServiceModuleInstance, parentId, timeZoneId, childQuery, childFilter);
        }
        return null;
    }

    public LogDataEntries getLogDataEntries(LogServiceModuleInstance logServiceModuleInstance, String parentId, String childId) throws LogServiceException {
        LOGGER.info("getLogDataEntries logServiceModuleInstance=..., parentId={}, childId={}", (Object)parentId, (Object)childId);
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            OpenSearchLogService logService = this.createOpenSearchLogService();
            return logService.getLogDataEntries(logServiceModuleInstance, parentId, childId);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogDataEntries(logServiceModuleInstance, parentId, childId);
        }
        return null;
    }

    public void dropIndices(LogServiceModuleInstance moduleInstance) throws LogServiceException, OpenSearchRelatedException {
        LOGGER.info("dropIndices moduleInstance=...");
        if (moduleInstance != null) {
            OpenSearchLogService openSearchLogService = this.createOpenSearchLogService();
            openSearchLogService.dropIndices(moduleInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areUsedIndicesTemporaryUnavailable(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceSettingsException {
        if (logServiceModuleInstance != null && logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
            Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
            synchronized (object) {
                if (openSearchConfig.parent != null && this.indicesTemporaryUnavailable.contains(openSearchConfig.parent.index)) {
                    return true;
                }
                if (openSearchConfig.child != null && this.indicesTemporaryUnavailable.contains(openSearchConfig.child.index)) {
                    return true;
                }
            }
        }
        return false;
    }

    private class DefaultLogServiceIndicesBackupSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private DefaultLogServiceIndicesBackupSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOGGER.info("{}.processSetting setting=...", (Object)this.getClass().getSimpleName());
            LogServiceModule.this.defaultLogServiceIndicesBackupSetting = setting;
        }
    }

    private class RestoreBackupStartEventHandler
    extends AbstractRestoreBackupStartEventHandler {
        private RestoreBackupStartEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processRestoreBackupStartEvent(AbstractRestoreBackupStartEventHandler.RestoreBackupStartEvent restoreBackupStartEvent) {
            LOGGER.info("{}.processRestoreBackupStartEvent restoreBackupStartEvent=...", (Object)this.getClass().getSimpleName());
            Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
            synchronized (object) {
                LogServiceModule.this.indicesTemporaryUnavailable.addAll(restoreBackupStartEvent.getAliasesOfBackupIndices());
            }
        }
    }

    private class RestoreBackupDoneEventHandler
    extends AbstractRestoreBackupDoneEventHandler {
        private RestoreBackupDoneEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processRestoreBackupDoneEvent(AbstractRestoreBackupDoneEventHandler.RestoreBackupDoneEvent restoreBackupDoneEvent) {
            LOGGER.info("{}.processRestoreBackupDoneEvent restoreBackupDoneEvent=...", (Object)this.getClass().getSimpleName());
            Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
            synchronized (object) {
                LogServiceModule.this.indicesTemporaryUnavailable.removeAll(restoreBackupDoneEvent.getAliasesOfBackupIndices());
            }
        }
    }

    private class MasterOrSlaveModeChangedEventHandler
    extends AbstractServerModeChangedEventHandler {
        private MasterOrSlaveModeChangedEventHandler() {
        }

        @Override
        public void processThisIsNowTheMasterServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowTheMasterServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            LogServiceModule.this.restartBackupJobs();
        }

        @Override
        public void processThisIsNowASlaveServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowASlaveServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
        }
    }
}

