/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.db;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.SourceTableNameExtractor;
import de.virtimo.bpc.util.MapUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseTableData {
    private static final Logger LOGGER = LogManager.getLogger(DatabaseTableData.class);
    private final String databaseProductName;
    private final String databaseProductVersion;
    private final int datasebaseMajorVersion;
    private final int databaseMinorVersion;
    private final SourceTableNameExtractor extractor;
    private final Map<String, Integer> tableColumnTypes = new HashMap<String, Integer>();

    public DatabaseTableData(Connection conn, String tableName) throws LogServiceException, SQLException {
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        this.databaseProductName = databaseMetaData.getDatabaseProductName();
        this.databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
        this.datasebaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
        this.databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
        LOGGER.debug("Database Product Name : {}", (Object)this.databaseProductName);
        LOGGER.debug("Product Version ......: {}", (Object)this.databaseProductVersion);
        LOGGER.debug("Major Version ........: {}", (Object)this.datasebaseMajorVersion);
        LOGGER.debug("Minor Version ........: {}", (Object)this.databaseMinorVersion);
        this.extractor = new SourceTableNameExtractor(databaseMetaData, tableName);
        if (!this.extractor.isParsed()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_WRONG_TABLE_NAME, "Could not parse the database table name '${tableName}'.", MapUtil.mapOf("tableName", tableName));
        }
        LOGGER.debug("Table name extractor: {}", (Object)this.extractor);
        try (ResultSet columnsResult = databaseMetaData.getColumns(this.extractor.getCatalogName(), this.extractor.getSchemaName(), this.extractor.getTableName(), null);){
            if (!columnsResult.next()) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_TABLE_MISSING, "The table '${tableName}' does not exist or has no columns.", MapUtil.mapOf("tableName", tableName));
            }
            do {
                String columnName = columnsResult.getString("COLUMN_NAME");
                int columnType = columnsResult.getInt("DATA_TYPE");
                LOGGER.debug("{} : {}, type:{}", (Object)this.extractor.getTableName(), (Object)columnName, (Object)columnType);
                this.tableColumnTypes.put(columnName.toLowerCase(), columnType);
            } while (columnsResult.next());
        }
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public int getDatasebaseMajorVersion() {
        return this.datasebaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public SourceTableNameExtractor getTableNameExtractor() {
        return this.extractor;
    }

    public Integer getTableColumnType(String columnName) {
        return this.tableColumnTypes.get(columnName.toLowerCase());
    }
}

