/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CustomFields;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.GlobalDefaultModuleConfigurations;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.ListUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DefaultModuleConfigurations {
    private static final Logger LOGGER = LogManager.getLogger(DefaultModuleConfigurations.class);
    private static DefaultModuleConfigurations instance;
    private final GlobalDefaultModuleConfigurations globalDefaultModuleConfigurations = new GlobalDefaultModuleConfigurations();

    private DefaultModuleConfigurations() {
    }

    public static DefaultModuleConfigurations getInstance() {
        if (instance == null) {
            instance = new DefaultModuleConfigurations();
        }
        return instance;
    }

    public static void destroySingleton() {
        instance = null;
    }

    public ModuleConfiguration merge(ModuleConfiguration targetConfig, ModuleConfiguration defaultConfig) throws SettingException {
        LOGGER.debug("merge targetConfig=..., defaultConfig=...");
        Collection<Setting> defaultSettings = defaultConfig.getSettings().values();
        for (Setting defaultSetting : defaultSettings) {
            Setting targetSetting = targetConfig.getSetting(defaultSetting.getName());
            if (targetSetting == null) {
                LOGGER.debug("merge default setting : {}", (Object)defaultSetting.getName());
                targetConfig.addSetting(defaultSetting, true);
                continue;
            }
            if ((targetSetting.getType() == null || !targetSetting.getType().equals(defaultSetting.getType())) && targetSetting instanceof SimpleSettingImpl) {
                ((SimpleSettingImpl)targetSetting).setType(defaultSetting.getType());
            }
            CustomFields defaultCustomFields = defaultSetting.getCustomFields();
            CustomFields targetCustomFields = targetSetting.getCustomFields();
            if (defaultCustomFields.isEmpty()) {
                if (!targetCustomFields.isEmpty()) {
                    targetCustomFields.clear();
                }
            } else {
                HashSet<String> noLongerExistingTargetFields = new HashSet<String>(targetCustomFields.getFieldNames());
                noLongerExistingTargetFields.removeAll(defaultCustomFields.getFieldNames());
                for (String string : noLongerExistingTargetFields) {
                    targetCustomFields.removeField(string);
                }
                HashSet<String> missingFieldsInTarget = new HashSet<String>(defaultCustomFields.getFieldNames());
                missingFieldsInTarget.removeAll(targetCustomFields.getFieldNames());
                for (String missingField : missingFieldsInTarget) {
                    targetCustomFields.setObjectValue(missingField, defaultCustomFields.getObjectValue(missingField));
                }
                HashSet<String> hashSet = new HashSet<String>(targetCustomFields.getFieldNames());
                hashSet.removeAll(missingFieldsInTarget);
                targetCustomFields.overwriteProtectedFieldsWith(defaultCustomFields, hashSet);
            }
            LOGGER.debug("Ignore default for setting {}", (Object)targetSetting);
        }
        return targetConfig;
    }

    public ModuleConfiguration getForModule(Module module) throws SettingException {
        LOGGER.debug("getForModule module={}", (Object)module);
        ModuleConfiguration defaultModuleConfiguration = module instanceof AbstractInstantiableModule ? ((AbstractInstantiableModule)module).getCachedDefaultConfiguration() : module.getDefaultConfiguration();
        return this.updateModuleConfigurationForNonWriteableSettingsFromLicense(this.merge(defaultModuleConfiguration, this.globalDefaultModuleConfigurations.getForModule(module)));
    }

    public ModuleConfiguration getForModuleInstance(InstantiableModule instantiableModule, String instanceType) throws SettingException {
        LOGGER.debug("getForModuleInstance instantiableModule={}, instanceType={}", (Object)instantiableModule, (Object)instanceType);
        ModuleConfiguration defaultModuleConfiguration = instantiableModule instanceof AbstractInstantiableModule ? ((AbstractInstantiableModule)instantiableModule).getCachedDefaultInstanceConfiguration(instanceType) : instantiableModule.getDefaultInstanceConfiguration(instanceType);
        return this.updateModuleConfigurationForNonWriteableSettingsFromLicense(this.merge(defaultModuleConfiguration, this.globalDefaultModuleConfigurations.getForModuleInstance(instantiableModule, instanceType)));
    }

    private ModuleConfiguration updateModuleConfigurationForNonWriteableSettingsFromLicense(ModuleConfiguration moduleConfiguration) {
        Set<String> idsOfNonWriteableSettingsFromLicense;
        if (moduleConfiguration != null && (idsOfNonWriteableSettingsFromLicense = this.getIDsOfNonWriteableSettingsFromLicense()) != null && !idsOfNonWriteableSettingsFromLicense.isEmpty()) {
            for (Setting setting : moduleConfiguration.getSettings().values()) {
                if (!idsOfNonWriteableSettingsFromLicense.contains(setting.getId())) continue;
                CustomFields customFields = setting.getCustomFields();
                customFields.setObjectValue("_writeableByRoles", ListUtil.listOf("virtimoAdmin"));
            }
        }
        return moduleConfiguration;
    }

    private Set<String> getIDsOfNonWriteableSettingsFromLicense() {
        LOGGER.debug("getIDsOfNonWriteableSettingsFromLicense");
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        BpcServicesTracker<LicenseService> licenseServiceTracker = new BpcServicesTracker<LicenseService>(bundleContext, LicenseService.class);
        try {
            Set<String> set = licenseServiceTracker.getService().getNonWriteableSettings();
            licenseServiceTracker.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                try {
                    licenseServiceTracker.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.warn("Failed to get the license service: {}", (Object)ex.getMessage());
                return null;
            }
        }
    }
}

