/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;

public class JsonDefaultsUtil {
    private static final Logger LOGGER = LogManager.getLogger(JsonDefaultsUtil.class);

    private static ObjectMapper createCustomizedObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.getFactory().disable(JsonFactory.Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING);
        return om;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadJsonFileAsListOrMap(Bundle bundle, String fileName) {
        LOGGER.debug("loadJsonFileAsListOrMap bundle:{} - fileName: {}", (Object)bundle, (Object)fileName);
        Object result = new Object();
        InputStream inputStream = null;
        try {
            URL bundleResourcesURL = bundle.getResource(fileName);
            inputStream = bundleResourcesURL.openStream();
            ObjectMapper mapper = JsonDefaultsUtil.createCustomizedObjectMapper();
            result = mapper.readValue(inputStream, Object.class);
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing JSON from resources file: {} in bundle {}", (Object)fileName, (Object)bundle.getSymbolicName(), (Object)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static List<Object> loadJsonFileAsList(Bundle bundle, String fileName) {
        LOGGER.debug("loadJsonFileAsList bundle:{} - fileName: {}", (Object)bundle, (Object)fileName);
        ArrayList result = null;
        try {
            Object parsingResult = JsonDefaultsUtil.loadJsonFileAs(bundle.getResource(fileName), List.class);
            result = parsingResult == null ? new ArrayList() : (ArrayList)parsingResult;
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing JSON from resources file: {} in bundle {}", (Object)fileName, (Object)bundle.getSymbolicName(), (Object)ex);
        }
        return result;
    }

    public static Map<String, Object> loadJsonFileAsMap(Bundle bundle, String fileName) {
        LOGGER.debug("loadJsonFileAsMap bundle:{} - fileName: {}", (Object)bundle, (Object)fileName);
        HashMap result = null;
        try {
            Object parsingResult = JsonDefaultsUtil.loadJsonFileAs(bundle.getResource(fileName), Map.class);
            result = parsingResult == null ? new HashMap() : (HashMap)parsingResult;
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing JSON from resources file: {} in bundle {}", (Object)fileName, (Object)bundle.getSymbolicName(), (Object)ex);
        }
        return result;
    }

    public static Map<String, Object> loadJsonFileAsMap(String fileName) {
        LOGGER.debug("loadJsonFileAsMap fileName: {}", (Object)fileName);
        HashMap result = null;
        try {
            Object parsingResult = JsonDefaultsUtil.loadJsonFileAs(JsonDefaultsUtil.class.getClassLoader().getResource(fileName), Map.class);
            result = parsingResult == null ? new HashMap() : (HashMap)parsingResult;
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing JSON from resources file: {}", (Object)fileName, (Object)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadJsonFileAs(URL bundleResourcesURL, Class mappingClass) {
        LOGGER.debug("loadJsonFileAs ResourcesURL={}, mappingClass={}", (Object)bundleResourcesURL, (Object)mappingClass);
        Object result = null;
        InputStream inputStream = null;
        try {
            inputStream = bundleResourcesURL.openStream();
            ObjectMapper mapper = JsonDefaultsUtil.createCustomizedObjectMapper();
            result = mapper.readValue(inputStream, mappingClass);
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing JSON from resources file: {}", (Object)bundleResourcesURL.getFile(), (Object)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static Map<String, Object> parseJsonStringAsMap(String jsonString) {
        LOGGER.debug("parseJsonStringAsMap");
        Map<String, Object> result = new HashMap<String, Object>();
        if (jsonString == null) {
            jsonString = "";
        }
        try {
            ObjectMapper mapper = JsonDefaultsUtil.createCustomizedObjectMapper();
            result = (Map)mapper.readValue(jsonString, Map.class);
        }
        catch (IOException e) {
            LOGGER.error("Error parsing json: {}", (Object)jsonString);
        }
        return result;
    }

    public static Object parseJsonStringAsListOrMap(String jsonString) {
        LOGGER.debug("parseJsonStringAsListOrMap");
        if (!StringUtil.isNullOrEmpty(jsonString)) {
            try {
                ObjectMapper mapper = JsonDefaultsUtil.createCustomizedObjectMapper();
                return mapper.readValue(jsonString, Object.class);
            }
            catch (IOException e) {
                LOGGER.error("Error parsing json: {}", (Object)jsonString);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadJsonFileAsString(Bundle bundle, String fileName) {
        LOGGER.debug("loadJsonFileAsString bundle:{} - fileName: {}", (Object)bundle, (Object)fileName);
        InputStream inputStream = null;
        String result = null;
        try {
            URL bundleResourcesURL = bundle.getResource(fileName);
            inputStream = bundleResourcesURL.openStream();
            Scanner s = new Scanner(inputStream).useDelimiter("\\A");
            result = s.hasNext() ? s.next() : "";
        }
        catch (Exception ex) {
            LOGGER.error("Error loading JSONString from resources file: {}", (Object)fileName, (Object)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }
}

