/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import com.fasterxml.jackson.databind.type.TypeFactory;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class ModuleActivator
implements BundleActivator {
    private static final Logger LOGGER = LogManager.getLogger(ModuleActivator.class);
    private BundleContext bundleContext;
    private ServiceTracker moduleManagerTracker;
    private Class<? extends Module> moduleClass = this.getBpcModuleClass();
    private Module module;

    public abstract Class<? extends Module> getBpcModuleClass();

    @Deprecated(since="3.0.0", forRemoval=true)
    public BundleContext getContext() {
        return this.bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void start(BundleContext bundleContext) throws Exception {
        LOGGER.info("BPC Module start: {}", (Object)this.moduleClass.getName());
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new ServiceTracker(bundleContext, ModuleManager.class, null){

            public Object addingService(ServiceReference reference) {
                LOGGER.info("BPC Service tracked");
                ModuleManager moduleManager = (ModuleManager)this.context.getService(reference);
                try {
                    Constructor<?> ctor;
                    Bundle moduleBundle = this.context.getBundle();
                    BpcBundleUtil.checkIfBundleWithBadSymbolicName(moduleBundle);
                    Constructor<?>[] ctors = ModuleActivator.this.moduleClass.getDeclaredConstructors();
                    Constructor<?> moduleConstructor = null;
                    Constructor<?>[] constructorArray = ctors;
                    int n = constructorArray.length;
                    for (int i = 0; !(i >= n || (moduleConstructor = (ctor = constructorArray[i])).getParameterTypes().length == 1 && moduleConstructor.getParameterTypes()[0].equals(ModuleManager.class)); ++i) {
                    }
                    ModuleActivator.this.module = (Module)moduleConstructor.newInstance(moduleManager);
                    ModuleActivator.this.module.setModuleBundle(moduleBundle);
                    moduleManager.loadModule(ModuleActivator.this.module);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                    LOGGER.error("Failed to create an Java instance of a module.", (Throwable)ex);
                }
                catch (SettingException ex) {
                    LOGGER.error("Failed to load module.", (Throwable)ex);
                }
                catch (ServiceNotFoundException ex) {
                    LOGGER.error("Failed to load module due to missing service.", (Throwable)ex);
                }
                return moduleManager;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                LOGGER.info("BPC Service changed");
            }

            public void removedService(ServiceReference reference, Object service) {
                LOGGER.info("BPC Service lost");
                if (service instanceof ModuleManager) {
                    ((ModuleManager)service).unloadModule(ModuleActivator.this.module);
                    ModuleActivator.this.module = null;
                } else {
                    LOGGER.error("There is something wrong. The given service ({}) is not the expected ModuleManager.", service);
                }
                this.context.ungetService(reference);
            }
        };
        this.moduleManagerTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        LOGGER.info("BPC Module stop: {}", (Object)this.moduleClass.getName());
        this.moduleManagerTracker.close();
        TypeFactory.defaultInstance().clearCache();
    }
}

