/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JsonUtil {
    public static JsonUtil getInstance() {
        return new JsonUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> convertPojoToMap(Object pojo) {
        if (pojo == null) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Map map = (Map)mapper.convertValue(pojo, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertPojoToJsonString(Object pojo) throws JsonProcessingException {
        if (pojo == null) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            String string = mapper.writeValueAsString(pojo);
            return string;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    public String convertPojoToJsonString(Object pojo, String errorCaseResult) {
        String result = null;
        try {
            result = this.convertPojoToJsonString(pojo);
        }
        catch (JsonProcessingException ex) {
            result = errorCaseResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertJavaContainerToPojo(Object javaContainer, Class<T> toClazz) throws IllegalArgumentException {
        if (javaContainer == null) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Object object = mapper.convertValue(javaContainer, toClazz);
            return (T)object;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertJsonStringToPojo(String jsonString, Class<T> toClazz) throws JsonProcessingException {
        if (StringUtil.isNullOrEmpty(jsonString)) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Object object = mapper.readValue(jsonString, toClazz);
            return (T)object;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> convertJsonStringToListOfPojo(String jsonString, Class<T> toClazz) throws JsonProcessingException {
        if (StringUtil.isNullOrEmpty(jsonString)) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            CollectionType javaType = mapper.getTypeFactory().constructCollectionType(List.class, toClazz);
            List list = (List)mapper.readValue(jsonString, (JavaType)javaType);
            return list;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertJsonFileToPojo(File jsonFile, Class<T> toClazz) throws IOException {
        if (jsonFile == null) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Object object = mapper.readValue(jsonFile, toClazz);
            return (T)object;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List jsonStringAsList(String jsonString) throws IOException {
        if (StringUtil.isNullOrEmpty(jsonString)) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            List list = (List)mapper.readValue(jsonString, List.class);
            return list;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> jsonStringAsMap(String jsonString) throws IOException {
        if (StringUtil.isNullOrEmpty(jsonString)) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Map map = (Map)mapper.readValue(jsonString, Map.class);
            return map;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Object> jsonInputStreamAsMap(InputStream jsonInputStream) throws IOException {
        if (jsonInputStream != null) {
            ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
            try {
                Map map = (Map)mapper.readValue(jsonInputStream, Map.class);
                return map;
            }
            finally {
                if (mapper != null) {
                    ObjectMapperPool.getInstance().restore((Object)mapper);
                }
            }
        }
        return new LinkedHashMap<String, Object>();
    }

    public static String crunchifyJSONEscapeUtil(String crunchifyJSON) {
        StringBuilder crunchifyNewJSON = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(crunchifyJSON);
        char myChar = iterator.current();
        while (myChar != '\uffff') {
            if (myChar == '\"') {
                crunchifyNewJSON.append("\\\"");
            } else if (myChar == '\t') {
                crunchifyNewJSON.append("\\t");
            } else if (myChar == '\f') {
                crunchifyNewJSON.append("\\f");
            } else if (myChar == '\n') {
                crunchifyNewJSON.append("\\n");
            } else if (myChar == '\r') {
                crunchifyNewJSON.append("\\r");
            } else if (myChar == '\\') {
                crunchifyNewJSON.append("\\\\");
            } else if (myChar == '/') {
                crunchifyNewJSON.append("\\/");
            } else if (myChar == '\b') {
                crunchifyNewJSON.append("\\b");
            } else {
                crunchifyNewJSON.append(myChar);
            }
            myChar = iterator.next();
        }
        return crunchifyNewJSON.toString();
    }
}

