/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ListUtil {
    @SafeVarargs
    public static <T> List<T> listOf(T ... objs) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, objs);
        return list;
    }

    public static <T> Reversed<T> reversed(List<T> original) {
        return new Reversed<T>(original);
    }

    public static class Reversed<T>
    implements Iterable<T> {
        private final List<T> original;

        public Reversed(List<T> original) {
            this.original = original;
        }

        @Override
        public Iterator<T> iterator() {
            final ListIterator<T> i = this.original.listIterator(this.original.size());
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return i.hasPrevious();
                }

                @Override
                public T next() {
                    return i.previous();
                }

                @Override
                public void remove() {
                    i.remove();
                }
            };
        }
    }
}

