/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.store;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.FilterIndexOutput;
import org.apache.lucene.store.IndexOutput;

public class ByteTrackingIndexOutput
extends FilterIndexOutput {
    private final AtomicLong byteTracker;
    private boolean closed = false;

    protected ByteTrackingIndexOutput(IndexOutput out, AtomicLong byteTracker) {
        super("Byte tracking wrapper for: " + out.getName(), "ByteTrackingIndexOutput{" + out.getName() + "}", out);
        this.byteTracker = byteTracker;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            this.out.close();
            return;
        }
        this.byteTracker.addAndGet(this.out.getFilePointer());
        this.closed = true;
        this.out.close();
    }
}

