/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.remotestore.stats;

import java.io.IOException;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.remote.RemoteSegmentTransferTracker;
import org.opensearch.index.remote.RemoteTranslogTransferTracker;

@PublicApi(since="2.8.0")
public class RemoteStoreStats
implements Writeable,
ToXContentFragment {
    private final RemoteSegmentTransferTracker.Stats remoteSegmentShardStats;
    private final RemoteTranslogTransferTracker.Stats remoteTranslogShardStats;
    private final ShardRouting shardRouting;

    RemoteStoreStats(RemoteSegmentTransferTracker.Stats remoteSegmentUploadShardStats, RemoteTranslogTransferTracker.Stats remoteTranslogShardStats, ShardRouting shardRouting) {
        this.remoteSegmentShardStats = remoteSegmentUploadShardStats;
        this.remoteTranslogShardStats = remoteTranslogShardStats;
        this.shardRouting = shardRouting;
    }

    RemoteStoreStats(StreamInput in) throws IOException {
        this.remoteSegmentShardStats = in.readOptionalWriteable(RemoteSegmentTransferTracker.Stats::new);
        this.remoteTranslogShardStats = in.readOptionalWriteable(RemoteTranslogTransferTracker.Stats::new);
        this.shardRouting = new ShardRouting(in);
    }

    public RemoteSegmentTransferTracker.Stats getSegmentStats() {
        return this.remoteSegmentShardStats;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public RemoteTranslogTransferTracker.Stats getTranslogStats() {
        return this.remoteTranslogShardStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.buildShardRouting(builder);
        builder.startObject("segment");
        builder.startObject("download");
        if (this.remoteSegmentShardStats.directoryFileTransferTrackerStats.transferredBytesStarted != 0L) {
            this.buildSegmentDownloadStats(builder);
        }
        builder.endObject();
        builder.startObject("upload");
        if (this.remoteSegmentShardStats.totalUploadsStarted != 0L) {
            this.buildSegmentUploadStats(builder);
        }
        builder.endObject();
        builder.endObject();
        builder.startObject("translog");
        builder.startObject("upload");
        if (this.remoteTranslogShardStats.totalUploadsStarted > 0L) {
            this.buildTranslogUploadStats(builder);
        }
        builder.endObject();
        builder.startObject("download");
        if (this.remoteTranslogShardStats.totalDownloadsSucceeded > 0L) {
            this.buildTranslogDownloadStats(builder);
        }
        builder.endObject();
        builder.endObject();
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.remoteSegmentShardStats);
        out.writeOptionalWriteable(this.remoteTranslogShardStats);
        this.shardRouting.writeTo(out);
    }

    private void buildTranslogUploadStats(XContentBuilder builder) throws IOException {
        builder.field("last_successful_upload_timestamp", this.remoteTranslogShardStats.lastSuccessfulUploadTimestamp);
        builder.startObject("total_uploads");
        builder.field("started", this.remoteTranslogShardStats.totalUploadsStarted).field("failed", this.remoteTranslogShardStats.totalUploadsFailed).field("succeeded", this.remoteTranslogShardStats.totalUploadsSucceeded);
        builder.endObject();
        builder.startObject("total_upload_size");
        builder.field("started_bytes", this.remoteTranslogShardStats.uploadBytesStarted).field("failed_bytes", this.remoteTranslogShardStats.uploadBytesFailed).field("succeeded_bytes", this.remoteTranslogShardStats.uploadBytesSucceeded);
        builder.endObject();
        builder.field("total_upload_time_in_millis", this.remoteTranslogShardStats.totalUploadTimeInMillis);
        builder.startObject("upload_size_in_bytes");
        builder.field("moving_avg", this.remoteTranslogShardStats.uploadBytesMovingAverage);
        builder.endObject();
        builder.startObject("upload_speed_in_bytes_per_sec");
        builder.field("moving_avg", this.remoteTranslogShardStats.uploadBytesPerSecMovingAverage);
        builder.endObject();
        builder.startObject("upload_time_in_millis");
        builder.field("moving_avg", this.remoteTranslogShardStats.uploadTimeMovingAverage);
        builder.endObject();
    }

    private void buildTranslogDownloadStats(XContentBuilder builder) throws IOException {
        builder.field("last_successful_download_timestamp", this.remoteTranslogShardStats.lastSuccessfulDownloadTimestamp);
        builder.startObject("total_downloads");
        builder.field("succeeded", this.remoteTranslogShardStats.totalDownloadsSucceeded);
        builder.endObject();
        builder.startObject("total_download_size");
        builder.field("succeeded_bytes", this.remoteTranslogShardStats.downloadBytesSucceeded);
        builder.endObject();
        builder.field("total_download_time_in_millis", this.remoteTranslogShardStats.totalDownloadTimeInMillis);
        builder.startObject("download_size_in_bytes");
        builder.field("moving_avg", this.remoteTranslogShardStats.downloadBytesMovingAverage);
        builder.endObject();
        builder.startObject("download_speed_in_bytes_per_sec");
        builder.field("moving_avg", this.remoteTranslogShardStats.downloadBytesPerSecMovingAverage);
        builder.endObject();
        builder.startObject("download_time_in_millis");
        builder.field("moving_avg", this.remoteTranslogShardStats.downloadTimeMovingAverage);
        builder.endObject();
    }

    private void buildSegmentUploadStats(XContentBuilder builder) throws IOException {
        builder.field("local_refresh_timestamp_in_millis", this.remoteSegmentShardStats.localRefreshClockTimeMs).field("remote_refresh_timestamp_in_millis", this.remoteSegmentShardStats.remoteRefreshClockTimeMs).field("refresh_time_lag_in_millis", this.remoteSegmentShardStats.refreshTimeLagMs).field("refresh_lag", this.remoteSegmentShardStats.localRefreshNumber - this.remoteSegmentShardStats.remoteRefreshNumber).field("bytes_lag", this.remoteSegmentShardStats.bytesLag).field("backpressure_rejection_count", this.remoteSegmentShardStats.rejectionCount).field("consecutive_failure_count", this.remoteSegmentShardStats.consecutiveFailuresCount);
        builder.startObject("total_uploads").field("started", this.remoteSegmentShardStats.totalUploadsStarted).field("succeeded", this.remoteSegmentShardStats.totalUploadsSucceeded).field("failed", this.remoteSegmentShardStats.totalUploadsFailed);
        builder.endObject();
        builder.startObject("total_upload_size").field("started_bytes", this.remoteSegmentShardStats.uploadBytesStarted).field("succeeded_bytes", this.remoteSegmentShardStats.uploadBytesSucceeded).field("failed_bytes", this.remoteSegmentShardStats.uploadBytesFailed);
        builder.endObject();
        builder.startObject("remote_refresh_size_in_bytes").field("last_successful", this.remoteSegmentShardStats.lastSuccessfulRemoteRefreshBytes).field("moving_avg", this.remoteSegmentShardStats.uploadBytesMovingAverage);
        builder.endObject();
        builder.startObject("upload_speed_in_bytes_per_sec").field("moving_avg", this.remoteSegmentShardStats.uploadBytesPerSecMovingAverage);
        builder.endObject();
        builder.startObject("remote_refresh_latency_in_millis").field("moving_avg", this.remoteSegmentShardStats.uploadTimeMovingAverage);
        builder.endObject();
    }

    private void buildSegmentDownloadStats(XContentBuilder builder) throws IOException {
        builder.field("last_sync_timestamp", this.remoteSegmentShardStats.directoryFileTransferTrackerStats.lastTransferTimestampMs);
        builder.startObject("total_download_size").field("started_bytes", this.remoteSegmentShardStats.directoryFileTransferTrackerStats.transferredBytesStarted).field("succeeded_bytes", this.remoteSegmentShardStats.directoryFileTransferTrackerStats.transferredBytesSucceeded).field("failed_bytes", this.remoteSegmentShardStats.directoryFileTransferTrackerStats.transferredBytesFailed);
        builder.endObject();
        builder.startObject("download_size_in_bytes").field("last_successful", this.remoteSegmentShardStats.directoryFileTransferTrackerStats.lastSuccessfulTransferInBytes).field("moving_avg", this.remoteSegmentShardStats.directoryFileTransferTrackerStats.transferredBytesMovingAverage);
        builder.endObject();
        builder.startObject("download_speed_in_bytes_per_sec").field("moving_avg", this.remoteSegmentShardStats.directoryFileTransferTrackerStats.transferredBytesPerSecMovingAverage);
        builder.endObject();
    }

    private void buildShardRouting(XContentBuilder builder) throws IOException {
        builder.startObject("routing");
        builder.field("state", (Object)this.shardRouting.state());
        builder.field("primary", this.shardRouting.primary());
        builder.field("node", this.shardRouting.currentNodeId());
        builder.endObject();
    }

    static final class Fields {
        static final String ROUTING = "routing";
        static final String SEGMENT = "segment";
        static final String TRANSLOG = "translog";

        Fields() {
        }
    }

    public static final class SubFields {
        public static final String STARTED = "started";
        public static final String SUCCEEDED = "succeeded";
        public static final String FAILED = "failed";
        public static final String STARTED_BYTES = "started_bytes";
        public static final String SUCCEEDED_BYTES = "succeeded_bytes";
        public static final String FAILED_BYTES = "failed_bytes";
        static final String DOWNLOAD = "download";
        public static final String UPLOAD = "upload";
        static final String MOVING_AVG = "moving_avg";
        static final String LAST_SUCCESSFUL = "last_successful";
    }

    public static final class UploadStatsFields {
        static final String BYTES_LAG = "bytes_lag";
        static final String REFRESH_LAG = "refresh_lag";
        static final String REFRESH_TIME_LAG_IN_MILLIS = "refresh_time_lag_in_millis";
        static final String LOCAL_REFRESH_TIMESTAMP = "local_refresh_timestamp_in_millis";
        static final String REMOTE_REFRESH_TIMESTAMP = "remote_refresh_timestamp_in_millis";
        static final String BACKPRESSURE_REJECTION_COUNT = "backpressure_rejection_count";
        static final String CONSECUTIVE_FAILURE_COUNT = "consecutive_failure_count";
        static final String REMOTE_REFRESH_SIZE_IN_BYTES = "remote_refresh_size_in_bytes";
        static final String REMOTE_REFRESH_LATENCY_IN_MILLIS = "remote_refresh_latency_in_millis";
        static final String LAST_SUCCESSFUL_UPLOAD_TIMESTAMP = "last_successful_upload_timestamp";
        public static final String TOTAL_UPLOADS = "total_uploads";
        public static final String TOTAL_UPLOAD_SIZE = "total_upload_size";
        static final String TOTAL_UPLOAD_TIME_IN_MILLIS = "total_upload_time_in_millis";
        static final String UPLOAD_SIZE_IN_BYTES = "upload_size_in_bytes";
        static final String UPLOAD_SPEED_IN_BYTES_PER_SEC = "upload_speed_in_bytes_per_sec";
        static final String UPLOAD_TIME_IN_MILLIS = "upload_time_in_millis";
    }

    static final class DownloadStatsFields {
        public static final String LAST_SUCCESSFUL_DOWNLOAD_TIMESTAMP = "last_successful_download_timestamp";
        static final String LAST_SYNC_TIMESTAMP = "last_sync_timestamp";
        public static final String TOTAL_DOWNLOADS = "total_downloads";
        public static final String TOTAL_DOWNLOAD_TIME_IN_MILLIS = "total_download_time_in_millis";
        static final String TOTAL_DOWNLOAD_SIZE = "total_download_size";
        static final String DOWNLOAD_SIZE_IN_BYTES = "download_size_in_bytes";
        static final String DOWNLOAD_SPEED_IN_BYTES_PER_SEC = "download_speed_in_bytes_per_sec";
        public static final String DOWNLOAD_TIME_IN_MILLIS = "download_time_in_millis";

        DownloadStatsFields() {
        }
    }

    static final class RoutingFields {
        static final String STATE = "state";
        static final String PRIMARY = "primary";
        static final String NODE_ID = "node";

        RoutingFields() {
        }
    }
}

