/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.bulk;

import java.io.IOException;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.support.WriteResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;

public class BulkShardResponse
extends ReplicationResponse
implements WriteResponse {
    private static final Version COMPACT_SHARD_ID_VERSION = LegacyESVersion.V_7_9_0;
    private final ShardId shardId;
    private final BulkItemResponse[] responses;

    BulkShardResponse(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.responses = in.readArray(in.getVersion().onOrAfter(COMPACT_SHARD_ID_VERSION) ? i -> new BulkItemResponse(this.shardId, i) : BulkItemResponse::new, BulkItemResponse[]::new);
    }

    public BulkShardResponse(ShardId shardId, BulkItemResponse[] responses) {
        this.shardId = shardId;
        this.responses = responses;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BulkItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        for (BulkItemResponse response : this.responses) {
            Object r = response.getResponse();
            if (r == null) continue;
            ((DocWriteResponse)r).setForcedRefresh(forcedRefresh);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeArray(out.getVersion().onOrAfter(COMPACT_SHARD_ID_VERSION) ? (o, item) -> item.writeThin(out) : (o, item) -> item.writeTo(o), this.responses);
    }
}

